/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.model;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import org.aksw.limes.core.gui.model.AutomatedClassMatchingNode;
import org.aksw.limes.core.gui.util.TaskResultSerializer;
import org.aksw.limes.core.io.config.KBInfo;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.ml.algorithm.matching.DefaultClassMapper;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.jena.rdf.model.Model;

public class GetAutomatedClassMatchingTask
extends Task<ObservableList<AutomatedClassMatchingNode>> {
    private final KBInfo sinfo;
    private final KBInfo tinfo;
    private final Model smodel;
    private final Model tmodel;

    public GetAutomatedClassMatchingTask(KBInfo sinfo, KBInfo tinfo, Model smodel, Model tmodel) {
        this.sinfo = sinfo;
        this.tinfo = tinfo;
        this.smodel = smodel;
        this.tmodel = tmodel;
    }

    protected ObservableList<AutomatedClassMatchingNode> call() throws Exception {
        Object serializedResult = TaskResultSerializer.getTaskResult(this);
        ObservableList result = null;
        if (serializedResult instanceof ArrayList && serializedResult != null) {
            ArrayList tmpRes = (ArrayList)serializedResult;
            result = FXCollections.observableArrayList();
            result.addAll((Collection)tmpRes);
            return result;
        }
        result = this.getAutomatedClassMatchingNodes();
        TaskResultSerializer.serializeTaskResult(this, new ArrayList(result));
        return result;
    }

    private ObservableList<AutomatedClassMatchingNode> getAutomatedClassMatchingNodes() {
        if (this.isCancelled()) {
            return null;
        }
        ObservableList result = FXCollections.observableArrayList();
        DefaultClassMapper mapper = this.smodel != null && this.tmodel != null ? new DefaultClassMapper(this.smodel, this.tmodel) : new DefaultClassMapper();
        AMapping classMapping = mapper.getEntityMapping(this.sinfo.getEndpoint(), this.tinfo.getEndpoint(), this.sinfo.getId(), this.tinfo.getId());
        for (String classTarget : classMapping.getMap().keySet()) {
            for (String classSource : ((HashMap)classMapping.getMap().get(classTarget)).keySet()) {
                try {
                    result.add((Object)new AutomatedClassMatchingNode(new URI(classSource), new URI(classTarget)));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.sinfo.getEndpoint()).append((Object)this.tinfo.getEndpoint()).append((Object)this.sinfo.getId()).append((Object)this.tinfo.getId()).append((Object)this.smodel).append((Object)this.tmodel).toHashCode();
    }
}

