/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.model;

import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.scene.control.Alert;
import org.aksw.limes.core.evaluation.evaluator.EvaluatorType;
import org.aksw.limes.core.execution.engine.SimpleExecutionEngine;
import org.aksw.limes.core.execution.planning.plan.NestedPlan;
import org.aksw.limes.core.execution.planning.planner.HeliosPlanner;
import org.aksw.limes.core.gui.model.Endpoint;
import org.aksw.limes.core.gui.model.Result;
import org.aksw.limes.core.gui.model.metric.MetricFormatException;
import org.aksw.limes.core.gui.model.metric.MetricParser;
import org.aksw.limes.core.gui.model.metric.Output;
import org.aksw.limes.core.gui.util.SourceOrTarget;
import org.aksw.limes.core.gui.util.sparql.PrefixHelper;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.config.Configuration;
import org.aksw.limes.core.io.config.KBInfo;
import org.aksw.limes.core.io.config.reader.rdf.RDFConfigurationReader;
import org.aksw.limes.core.io.config.reader.xml.XMLConfigurationReader;
import org.aksw.limes.core.io.config.writer.RDFConfigurationWriter;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.ml.algorithm.LearningParameter;
import org.aksw.limes.core.ml.algorithm.MLImplementationType;
import org.aksw.limes.core.ml.algorithm.eagle.util.PropertyMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config
extends Configuration {
    private static final Logger logger = LoggerFactory.getLogger(Config.class);
    private static final String restrictionRegex = "\\?\\w+\\s+\\w+(:\\w+){0,1}\\s+\\w+:\\w+";
    public PropertyMapping propertyMapping;
    private Output metric = null;
    private Endpoint sourceEndpoint;
    private Endpoint targetEndpoint;
    private AMapping mapping;
    private static final String sourceVar = "?x";
    private static final String targetVar = "?y";
    public static final double defaultAcceptanceThreshold = 0.9;
    public static final double defaultReviewThreshold = 0.7;
    private static final String defaultAcceptanceRelation = "owl:sameAs";
    private static final String defaultVerificationRelation = "owl:sameAs";

    public Config() {
        this.acceptanceRelation = "owl:sameAs";
        this.verificationRelation = "owl:sameAs";
        this.sourceInfo = new KBInfo();
        this.sourceInfo.setVar(sourceVar);
        this.targetInfo = new KBInfo();
        this.targetInfo.setVar(targetVar);
        this.metric = new Output();
        this.sourceEndpoint = new Endpoint(this.sourceInfo, this);
        this.targetEndpoint = new Endpoint(this.targetInfo, this);
    }

    public Config(KBInfo sourceInfo, KBInfo targetInfo, String metricExpression, String acceptanceRelation, String verificationRelation, double acceptanceThreshold, String acceptanceFile, double verificationThreshold, String verificationFile, Map<String, String> prefixes, String outputFormat, String executionRewriter, String executionPlanner, String executionEngine, int granularity, String mlAlgorithmName, List<LearningParameter> mlParameters, MLImplementationType mlImplementationType, String mlTrainingDataFile, EvaluatorType mlPseudoFMeasure) {
        this.sourceInfo = sourceInfo;
        this.targetInfo = targetInfo;
        this.metricExpression = metricExpression;
        this.acceptanceRelation = acceptanceRelation;
        this.verificationRelation = verificationRelation;
        this.acceptanceThreshold = acceptanceThreshold;
        this.acceptanceFile = acceptanceFile;
        this.verificationThreshold = verificationThreshold;
        this.verificationFile = verificationFile;
        this.prefixes = prefixes;
        this.outputFormat = outputFormat;
        this.executionRewriter = executionRewriter;
        this.executionPlanner = executionPlanner;
        this.executionEngine = executionEngine;
        this.granularity = granularity;
        this.mlAlgorithmName = mlAlgorithmName;
        this.mlAlgorithmParameters = mlParameters;
        this.mlImplementationType = mlImplementationType;
        this.mlTrainingDataFile = mlTrainingDataFile;
        this.mlPseudoFMeasure = mlPseudoFMeasure;
        if (this.acceptanceRelation.equals("") || this.acceptanceRelation == null || this.acceptanceRelation.startsWith("file:")) {
            this.acceptanceRelation = "owl:sameAs";
        }
        if (this.verificationRelation.equals("") || this.verificationRelation == null || this.verificationRelation.startsWith("file:")) {
            this.verificationRelation = "owl:sameAs";
        }
        this.metric = new Output();
        this.sourceEndpoint = new Endpoint(this.sourceInfo, this);
        this.targetEndpoint = new Endpoint(this.targetInfo, this);
        for (Map.Entry e : this.sourceInfo.getPrefixes().entrySet()) {
            PrefixHelper.addPrefix((String)e.getKey(), (String)e.getValue());
        }
        for (Map.Entry e : this.targetInfo.getPrefixes().entrySet()) {
            PrefixHelper.addPrefix((String)e.getKey(), (String)e.getValue());
        }
        if (sourceInfo.getRestrictions().size() == 1 && targetInfo.getRestrictions().size() == 1) {
            if (Pattern.matches(restrictionRegex, (CharSequence)sourceInfo.getRestrictions().get(0)) && Pattern.matches(restrictionRegex, (CharSequence)targetInfo.getRestrictions().get(0))) {
                String sourceRestriction = (String)sourceInfo.getRestrictions().get(0);
                String targetRestriction = (String)targetInfo.getRestrictions().get(0);
                String sourceClass = sourceRestriction.substring(sourceRestriction.lastIndexOf(" ")).trim();
                String targetClass = targetRestriction.substring(targetRestriction.lastIndexOf(" ")).trim();
                this.sourceEndpoint.setCurrentClassAsString(PrefixHelper.expand(sourceClass));
                this.targetEndpoint.setCurrentClassAsString(PrefixHelper.expand(targetClass));
                logger.debug(this.sourceEndpoint.getCurrentClass().getUri() + " " + this.targetEndpoint.getCurrentClass().getUri());
            } else if (((String)sourceInfo.getRestrictions().get(0)).equals("") && ((String)targetInfo.getRestrictions().get(0)).equals("") || sourceInfo.getRestrictions().get(0) == null && targetInfo.getRestrictions().get(0) == null) {
                this.sourceEndpoint.setCurrentClassAsString("");
                this.targetEndpoint.setCurrentClassAsString("");
                logger.error("Restrictions are empty!");
            } else {
                logger.error("Restrictions that are more complex than \" ?y a prefix:class \" are not yet implemented in the GUI");
            }
        } else {
            logger.error("Restrictions that are more complex than \" ?y a prefix:class \" are not yet implemented in the GUI");
        }
    }

    public static Config loadFromFile(File file) throws Exception {
        XMLConfigurationReader reader = null;
        if (file.getAbsolutePath().contains(".xml")) {
            reader = new XMLConfigurationReader(file.getPath());
        } else if (file.getAbsolutePath().contains(".rdf") || file.getAbsolutePath().contains(".ttl") || file.getAbsolutePath().contains(".n3") || file.getAbsolutePath().contains(".nt")) {
            reader = new RDFConfigurationReader(file.getPath());
        } else {
            throw new RuntimeException("Unknown filetype!");
        }
        Configuration tmp = reader.read();
        if (tmp.getSourceInfo() == null || tmp.getTargetInfo() == null || tmp.getSourceInfo().equals((Object)new KBInfo()) || tmp.getTargetInfo().equals((Object)new KBInfo())) {
            throw new RuntimeException("Invalid configuration file!");
        }
        for (String s : tmp.getSourceInfo().getPrefixes().keySet()) {
            PrefixHelper.addPrefix(s, (String)tmp.getSourceInfo().getPrefixes().get(s));
        }
        for (String s : tmp.getTargetInfo().getPrefixes().keySet()) {
            PrefixHelper.addPrefix(s, (String)tmp.getTargetInfo().getPrefixes().get(s));
        }
        Config outConfig = new Config(tmp.getSourceInfo(), tmp.getTargetInfo(), tmp.getMetricExpression(), tmp.getAcceptanceRelation(), tmp.getVerificationRelation(), tmp.getAcceptanceThreshold(), tmp.getAcceptanceFile(), tmp.getVerificationThreshold(), tmp.getVerificationFile(), tmp.getPrefixes(), tmp.getOutputFormat(), tmp.getExecutionRewriter(), tmp.getExecutionPlanner(), tmp.getExecutionEngine(), tmp.getGranularity(), tmp.getMlAlgorithmName(), tmp.getMlAlgorithmParameters(), tmp.getMlImplementationType(), tmp.getMlTrainingDataFile(), tmp.getMlPseudoFMeasure());
        outConfig.setMlTrainingDataFile(tmp.getMlTrainingDataFile());
        if (tmp.getMlAlgorithmName() == null || tmp.getMlAlgorithmName().equals("")) {
            outConfig.metric = MetricParser.parse(outConfig.metricExpression, outConfig.getSourceInfo().getVar().replaceAll("\\?", ""), outConfig);
            outConfig.metric.param1 = outConfig.acceptanceThreshold;
            outConfig.metric.param2 = outConfig.verificationThreshold;
        } else {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setContentText("Running machine learning configurations in the GUI is possible, although using the command line for this most of the time is more preferable. All the usable information has been saved though and you can run any machine learning type from the GUI now");
            alert.showAndWait();
            outConfig.metric = new Output();
        }
        return outConfig;
    }

    public void save(File file) throws Exception {
        if (!this.metric.isComplete()) {
            throw new MetricFormatException();
        }
        if (this.acceptanceRelation != null && this.acceptanceRelation.startsWith("http:")) {
            this.acceptanceRelation = PrefixHelper.abbreviate(this.acceptanceRelation);
        }
        if (this.verificationRelation != null && this.verificationRelation.startsWith("http:")) {
            this.verificationRelation = PrefixHelper.abbreviate(this.verificationRelation);
        }
        String newME = this.metricExpression;
        for (String s : this.sourceEndpoint.getInfo().getFunctions().keySet()) {
            for (String t : ((Map)this.sourceEndpoint.getInfo().getFunctions().get(s)).keySet()) {
                newME = this.metricExpression.replace(t, s);
            }
        }
        for (String s : this.targetEndpoint.getInfo().getFunctions().keySet()) {
            for (String t : ((Map)this.targetEndpoint.getInfo().getFunctions().get(s)).keySet()) {
                newME = this.metricExpression.replace(t, s);
            }
        }
        this.metricExpression = newME;
        RDFConfigurationWriter rdfwriter = new RDFConfigurationWriter();
        rdfwriter.write((Configuration)this, file.getAbsolutePath());
    }

    public double getAcceptanceThreshold() {
        if (this.metric == null || this.metric.param1 == null) {
            return 0.9;
        }
        return this.metric.param1;
    }

    public void setAcceptanceThreshold(double acceptanceThreshold) {
        if (this.metric == null) {
            this.metric = new Output();
        }
        this.metric.param1 = acceptanceThreshold;
    }

    public double getVerificationThreshold() {
        if (this.metric == null || this.metric.param2 == null) {
            Number number;
            DecimalFormat twoDForm = new DecimalFormat("#.####");
            NumberFormat format = NumberFormat.getInstance();
            try {
                number = format.parse(twoDForm.format(this.getAcceptanceThreshold() - 0.1));
            }
            catch (Exception e) {
                logger.debug(e.toString());
                return 0.7;
            }
            return number.doubleValue();
        }
        return this.metric.param2;
    }

    public Task<Void> createMappingTask(final ObservableList<Result> results) {
        return new Task<Void>(){

            protected Void call() {
                ACache sourceCache = Config.this.sourceEndpoint.getCache();
                ACache targetCache = Config.this.targetEndpoint.getCache();
                LinkSpecification ls = new LinkSpecification();
                ls.readSpec(Config.this.getMetricExpression(), Config.this.getAcceptanceThreshold());
                HeliosPlanner hp = new HeliosPlanner(sourceCache, targetCache);
                NestedPlan plan = hp.plan(ls);
                SimpleExecutionEngine ee = new SimpleExecutionEngine(sourceCache, targetCache, Config.this.getSourceInfo().getVar(), Config.this.getTargetInfo().getVar());
                Config.this.mapping = ee.executeStatic(plan);
                Config.this.setMapping(Config.this.mapping);
                Config.this.mapping.getMap().forEach((sourceURI, map2) -> map2.forEach((targetURI, value) -> results.add((Object)new Result((String)sourceURI, (String)targetURI, (Double)value))));
                return null;
            }
        };
    }

    public Endpoint getSourceEndpoint() {
        return this.sourceEndpoint;
    }

    public Endpoint getTargetEndpoint() {
        return this.targetEndpoint;
    }

    public void setMetricExpression(String metricExpression) {
        this.metricExpression = metricExpression;
        if (this.metric != null) {
            double param1 = 2.0;
            double param2 = 2.0;
            if (this.metric.param1 != null) {
                param1 = this.metric.param1;
            }
            if (this.metric.param2 != null) {
                param2 = this.metric.param2;
            }
            this.metric = MetricParser.parse(metricExpression, this.getSourceInfo().getVar().replaceAll("\\?", ""), this);
            if (param1 <= 1.0) {
                this.metric.param1 = param1;
            }
            if (param2 <= 1.0) {
                this.metric.param2 = param2;
            }
        } else {
            this.metric = MetricParser.parse(metricExpression, this.getSourceInfo().getVar().replaceAll("\\?", ""), this);
        }
    }

    public String removeVar(String property, SourceOrTarget sot) {
        String var;
        String result = property;
        String string = var = sot == SourceOrTarget.SOURCE ? this.sourceInfo.getVar().substring(1) + "." : this.targetInfo.getVar().substring(1) + ".";
        if (property.startsWith(var)) {
            result = result.substring(var.length());
        }
        return result;
    }

    public String getPropertyString(String propString, SourceOrTarget sourceOrTarget) {
        if (sourceOrTarget == SourceOrTarget.SOURCE) {
            return this.getSourceInfo().getVar().substring(1) + "." + propString;
        }
        return this.getTargetInfo().getVar().substring(1) + "." + propString;
    }

    public Output getMetric() {
        return this.metric;
    }

    public HashMap<String, String> getPrefixes() {
        return (HashMap)this.prefixes;
    }

    public void setPropertiesMatching(List<String> sourcePropertiesToAdd, List<String> targetPropertiesToAdd) {
        List sourceProperties = this.sourceEndpoint.getInfo().getProperties();
        List targetProperties = this.targetEndpoint.getInfo().getProperties();
        sourceProperties.clear();
        targetProperties.clear();
        for (String sourceProp : sourcePropertiesToAdd) {
            sourceProperties.add(sourceProp);
            this.addFunction(this.sourceEndpoint, sourceProp);
        }
        for (String targetProp : targetPropertiesToAdd) {
            targetProperties.add(targetProp);
            this.addFunction(this.targetEndpoint, targetProp);
        }
    }

    private void addFunction(Endpoint endpoint, String property) {
        KBInfo info = endpoint.getInfo();
        String abbr = PrefixHelper.abbreviate(property);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(abbr, "nolang->lowercase");
        info.getFunctions().put(abbr, map);
        String[] parts = property.split(":");
        String prefixToAdd = parts[0];
        info.getPrefixes().put(prefixToAdd, PrefixHelper.getURI(prefixToAdd));
        this.prefixes.put(prefixToAdd, PrefixHelper.getURI(prefixToAdd));
    }

    public void switchPropertyOptional(String property, SourceOrTarget sot) {
        property = this.removeVar(property, sot);
        KBInfo info = sot == SourceOrTarget.SOURCE ? this.sourceInfo : this.targetInfo;
        String renamedProp = this.reverseRename(property, sot);
        List properties = info.getProperties();
        List optProperties = info.getOptionalProperties();
        if (properties.contains(property)) {
            properties.remove(property);
            info.setProperties(properties);
            info.addOptionalProperty(property);
        } else if (optProperties.contains(property)) {
            optProperties.remove(property);
            info.setOptionalProperties(optProperties);
            info.addProperty(property);
        } else if (properties.contains(renamedProp)) {
            properties.remove(renamedProp);
            info.setProperties(properties);
            info.addOptionalProperty(renamedProp);
        } else if (optProperties.contains(renamedProp)) {
            optProperties.remove(renamedProp);
            info.setOptionalProperties(optProperties);
            info.addProperty(renamedProp);
        } else {
            logger.error("Did not find property: " + property);
        }
        logger.debug("props: " + info.getProperties());
        logger.debug("optprops: " + info.getOptionalProperties());
    }

    public String reverseRename(String property, SourceOrTarget sot) {
        String rev = "";
        KBInfo info = sot == SourceOrTarget.SOURCE ? this.sourceInfo : this.targetInfo;
        for (String key : info.getFunctions().keySet()) {
            for (String value : ((Map)info.getFunctions().get(key)).keySet()) {
                if (!value.equals(property)) continue;
                rev = key;
            }
        }
        if (rev.equals("") || rev == null) {
            logger.debug("Return prop: " + property);
            return property;
        }
        logger.debug("Return rev: " + rev);
        return rev;
    }

    public AMapping getMapping() {
        return this.mapping;
    }

    public void setMetric(Output metric) {
        this.metric = metric;
    }

    public void setMapping(AMapping mapping) {
        this.mapping = mapping;
    }

    public void setSourceEndpoint(Endpoint sourceEndpoint) {
        this.sourceEndpoint = sourceEndpoint;
    }

    public void setTargetEndpoint(Endpoint targetEndpoint) {
        this.targetEndpoint = targetEndpoint;
    }
}

