/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.controller.ml;

import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.aksw.limes.core.exceptions.UnsupportedMLImplementationException;
import org.aksw.limes.core.gui.model.ActiveLearningResult;
import org.aksw.limes.core.gui.model.Config;
import org.aksw.limes.core.gui.model.InstanceProperty;
import org.aksw.limes.core.gui.model.ml.ActiveLearningModel;
import org.aksw.limes.core.gui.view.ml.ActiveLearningResultView;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.ml.algorithm.MLResults;

public class ActiveLearningResultController {
    private final ActiveLearningResultView view;
    private Config currentConfig;
    private final ActiveLearningModel model;

    public void setCurrentConfig(Config c) {
        this.currentConfig = c;
    }

    public ActiveLearningResultController(ActiveLearningResultView v, Config c, ActiveLearningModel m) {
        this.view = v;
        this.currentConfig = c;
        this.model = m;
    }

    public void showProperties(ActiveLearningResult item) {
        String value;
        String sourceURI = item.getSourceURI();
        String targetURI = item.getTargetURI();
        ObservableList sourcePropertyList = FXCollections.observableArrayList();
        ObservableList targetPropertyList = FXCollections.observableArrayList();
        Instance i1 = this.currentConfig.getSourceEndpoint().getCache().getInstance(sourceURI);
        Instance i2 = this.currentConfig.getTargetEndpoint().getCache().getInstance(targetURI);
        for (String prop : i1.getAllProperties()) {
            value = "";
            for (String s : i1.getProperty(prop)) {
                value = value + s + " ";
            }
            sourcePropertyList.add((Object)new InstanceProperty(prop, value));
        }
        this.view.showSourceInstance((ObservableList<InstanceProperty>)sourcePropertyList);
        for (String prop : i2.getAllProperties()) {
            value = "";
            for (String s : i2.getProperty(prop)) {
                value = value + s + " ";
            }
            targetPropertyList.add((Object)new InstanceProperty(prop, value));
        }
        this.view.showTargetInstance((ObservableList<InstanceProperty>)targetPropertyList);
    }

    public void learnButtonPressed() {
        final AMapping trainingMap = MappingFactory.createDefaultMapping();
        this.view.learnProgress.setVisible(true);
        for (ActiveLearningResult item : this.view.getMatchingTable().getItems()) {
            if (!item.isMatchProperty().get()) continue;
            trainingMap.add(item.getSourceURI(), item.getTargetURI(), 1.0);
        }
        final ObservableList results = FXCollections.observableArrayList();
        Thread thread = new Thread(){

            @Override
            public void run() {
                MLResults mlModel = null;
                try {
                    mlModel = ActiveLearningResultController.this.model.getMlalgorithm().asActive().activeLearn(trainingMap);
                    ActiveLearningResultController.this.model.setNextExamples(ActiveLearningResultController.this.model.getMlalgorithm().asActive().getNextExamples(10));
                }
                catch (UnsupportedMLImplementationException e) {
                    e.printStackTrace();
                }
                ActiveLearningResultController.this.model.getNextExamples().getMap().forEach((sourceURI, map2) -> map2.forEach((targetURI, value) -> results.add((Object)new ActiveLearningResult((String)sourceURI, (String)targetURI, (Double)value))));
                ActiveLearningResultController.this.model.setLearnedMapping(ActiveLearningResultController.this.model.getMlalgorithm().asActive().predict(ActiveLearningResultController.this.model.getConfig().getSourceEndpoint().getCache(), ActiveLearningResultController.this.model.getConfig().getTargetEndpoint().getCache(), mlModel));
                ActiveLearningResultController.this.onFinish((ObservableList<ActiveLearningResult>)results);
            }
        };
        thread.start();
    }

    private void onFinish(ObservableList<ActiveLearningResult> results) {
        this.view.learnProgress.setVisible(false);
        this.view.showResults(results);
    }
}

