/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.controller.ml;

import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import org.aksw.limes.core.gui.controller.MainController;
import org.aksw.limes.core.gui.controller.TaskProgressController;
import org.aksw.limes.core.gui.controller.ml.MachineLearningController;
import org.aksw.limes.core.gui.model.ActiveLearningResult;
import org.aksw.limes.core.gui.model.Config;
import org.aksw.limes.core.gui.model.ml.ActiveLearningModel;
import org.aksw.limes.core.gui.view.TaskProgressView;
import org.aksw.limes.core.gui.view.ml.ActiveLearningResultView;
import org.aksw.limes.core.gui.view.ml.MachineLearningView;
import org.aksw.limes.core.io.cache.ACache;

public class ActiveLearningController
extends MachineLearningController {
    private final MainController mainController;

    public ActiveLearningController(Config config, ACache sourceCache, ACache targetCache, MainController mainController) {
        this.mainController = mainController;
        this.mlModel = new ActiveLearningModel(config, sourceCache, targetCache);
    }

    @Override
    public void learn(MachineLearningView view) {
        Task<Void> learnTask = this.mlModel.createLearningTask();
        TaskProgressView taskProgressView = new TaskProgressView("Learning");
        TaskProgressController taskProgressController = new TaskProgressController(taskProgressView, new Task[0]);
        taskProgressView.getCancelled().addListener((observable, oldValue, newValue) -> view.getLearnButton().setDisable(false));
        taskProgressController.addTask(learnTask, items -> {
            view.getLearnButton().setDisable(false);
            ObservableList results = FXCollections.observableArrayList();
            ((ActiveLearningModel)this.mlModel).getNextExamples().getMap().forEach((sourceURI, map2) -> map2.forEach((targetURI, value) -> results.add((Object)new ActiveLearningResult((String)sourceURI, (String)targetURI, (Double)value))));
            Platform.runLater(() -> {
                ActiveLearningResultView activeLearningResultView = new ActiveLearningResultView(this.mlModel.getConfig(), (ActiveLearningModel)this.mlModel, this.mainController);
                activeLearningResultView.showResults((ObservableList<ActiveLearningResult>)results);
            });
        }, error -> view.showErrorDialog("Error during learning", error.getMessage()));
    }
}

