/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.controller;

import java.io.File;
import java.io.IOException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.aksw.limes.core.gui.controller.MainController;
import org.aksw.limes.core.gui.model.Config;
import org.aksw.limes.core.gui.model.InstanceProperty;
import org.aksw.limes.core.gui.model.Result;
import org.aksw.limes.core.gui.view.ResultView;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.writer.CSVMappingWriter;
import org.aksw.limes.core.io.mapping.writer.RDFMappingWriter;

public class ResultController {
    private final ResultView view;
    private MainController mainController;
    private Config currentConfig;
    private ACache sourceCache;
    private ACache targetCache;

    public ResultController(ResultView view, Config config) {
        this.view = view;
        this.currentConfig = config;
    }

    public ResultController(ResultView view, Config config, MainController mainController) {
        this.view = view;
        this.currentConfig = config;
        this.mainController = mainController;
    }

    public void setCachesFixed() {
        if (this.sourceCache == null) {
            this.sourceCache = this.currentConfig.getSourceEndpoint().getCache();
        }
        if (this.targetCache == null) {
            this.targetCache = this.currentConfig.getTargetEndpoint().getCache();
        }
    }

    public void showProperties(Result item) {
        String value;
        String sourceURI = item.getSourceURI();
        String targetURI = item.getTargetURI();
        ObservableList sourcePropertyList = FXCollections.observableArrayList();
        ObservableList targetPropertyList = FXCollections.observableArrayList();
        Instance i1 = this.sourceCache.getInstance(sourceURI);
        Instance i2 = this.targetCache.getInstance(targetURI);
        for (String prop : i1.getAllProperties()) {
            value = "";
            for (String s : i1.getProperty(prop)) {
                value = value + s + " ";
            }
            sourcePropertyList.add((Object)new InstanceProperty(prop, value));
        }
        this.view.showSourceInstance((ObservableList<InstanceProperty>)sourcePropertyList);
        for (String prop : i2.getAllProperties()) {
            value = "";
            for (String s : i2.getProperty(prop)) {
                value = value + s + " ";
            }
            targetPropertyList.add((Object)new InstanceProperty(prop, value));
        }
        this.view.showTargetInstance((ObservableList<InstanceProperty>)targetPropertyList);
    }

    public void saveResults(AMapping mapping, File file) {
        try {
            String format = "";
            if (!file.getName().contains(".")) {
                format = ".ttl";
                file = new File(file.toString() + format);
                System.out.println(file);
            } else {
                format = file.getName().substring(file.getName().lastIndexOf("."), file.getName().length());
            }
            if (format.equals(".csv")) {
                CSVMappingWriter csvwriter = new CSVMappingWriter();
                csvwriter.write(mapping, file.getAbsolutePath());
            } else {
                RDFMappingWriter rdfwriter = new RDFMappingWriter();
                rdfwriter.write(mapping, file.getAbsolutePath());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveLinkSpec(LinkSpecification ls) {
        this.currentConfig.setMetricExpression(ls.getFullExpression());
        this.mainController.setCurrentConfig(this.currentConfig);
    }

    public Config getCurrentConfig() {
        return this.currentConfig;
    }

    public void setCurrentConfig(Config currentConfig) {
        this.currentConfig = currentConfig;
    }
}

