/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.model;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.aksw.limes.core.gui.model.ClassMatchingNode;
import org.aksw.limes.core.gui.model.Config;
import org.aksw.limes.core.gui.model.GetClassesTask;
import org.aksw.limes.core.gui.model.GetPropertiesTask;
import org.aksw.limes.core.gui.util.sparql.PrefixHelper;
import org.aksw.limes.core.gui.view.TaskProgressView;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.cache.HybridCache;
import org.aksw.limes.core.io.config.KBInfo;
import org.aksw.limes.core.io.query.ModelRegistry;
import org.aksw.limes.core.io.query.QueryModuleFactory;
import org.apache.jena.rdf.model.Model;

public class Endpoint {
    public static final String propertyRegex = "\\s+\\w+:\\w+\\s+";
    private final KBInfo info;
    private ACache cache;
    private Model model;
    private final Config config;
    private ClassMatchingNode currentClass;

    public Endpoint(KBInfo info, Config config) {
        this.info = info;
        this.config = config;
        this.update();
    }

    public void update() {
        if (this.info.getEndpoint() == null) {
            return;
        }
        String fileType = this.info.getEndpoint().substring(this.info.getEndpoint().lastIndexOf(".") + 1);
        if (this.info.getEndpoint().startsWith("file://")) {
            this.info.setEndpoint(this.info.getEndpoint().substring(6));
        } else if (this.info.getEndpoint().startsWith("file:")) {
            this.info.setEndpoint(this.info.getEndpoint().substring(5));
        }
        System.err.println("Endpoint: " + this.info.getEndpoint());
        QueryModuleFactory.getQueryModule((String)fileType, (KBInfo)this.info);
        this.model = (Model)ModelRegistry.getInstance().getMap().get(this.info.getEndpoint());
    }

    public KBInfo getInfo() {
        return this.info;
    }

    public ACache getCache() {
        for (String key : ((HashMap)this.config.getPrefixes()).keySet()) {
            this.info.getPrefixes().put(key, ((HashMap)this.config.getPrefixes()).get(key));
        }
        this.cache = HybridCache.getData((KBInfo)this.info);
        return this.cache;
    }

    public GetClassesTask createGetClassesTask(TaskProgressView view) {
        return new GetClassesTask(this.info, this.model, view, this.config);
    }

    public ClassMatchingNode getCurrentClass() {
        return this.currentClass;
    }

    public void setCurrentClass(ClassMatchingNode currentClass) {
        this.currentClass = currentClass;
        if (currentClass == null) {
            return;
        }
        String currentClassAsString = currentClass.getUri().toString();
        this.setCurrentClassAsString(currentClassAsString);
    }

    public void setCurrentClassAsString(String currentClass) {
        try {
            this.currentClass = new ClassMatchingNode(new URI(currentClass), null);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        String[] abbr = PrefixHelper.generatePrefix(currentClass);
        this.info.getPrefixes().put(abbr[0], abbr[1]);
        String classAbbr = PrefixHelper.abbreviate(currentClass);
        boolean alreadyContains = false;
        for (String restr : this.info.getRestrictions()) {
            if (!restr.matches(Pattern.quote(this.info.getVar()) + propertyRegex + classAbbr)) continue;
            alreadyContains = true;
        }
        if (!alreadyContains) {
            this.info.getRestrictions().add(this.info.getVar() + " a " + classAbbr);
        }
        String[] abbrSource = PrefixHelper.generatePrefix(currentClass);
        ((HashMap)this.config.getPrefixes()).put(abbrSource[0], abbrSource[1]);
    }

    public GetPropertiesTask createGetPropertiesTask() {
        return new GetPropertiesTask(this.info, this.model, this.currentClass.getUri().toString());
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }
}

