/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.controller;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import javafx.concurrent.Task;
import org.aksw.limes.core.gui.view.TaskProgressView;

public class TaskProgressController {
    private static final ExecutorService executorService = Executors.newCachedThreadPool();
    private final TaskProgressView view;
    private final Set<Task<?>> tasks;

    public TaskProgressController(TaskProgressView view, Task<?> ... tasks) {
        view.setController(this);
        this.view = view;
        this.tasks = new HashSet();
    }

    public static ExecutorService getExecutorservice() {
        return executorService;
    }

    public <T> void addTask(Task<T> task, Consumer<T> successCallback, Consumer<Throwable> errorCallback) {
        this.tasks.add(task);
        task.setOnSucceeded(event -> {
            Object result;
            try {
                result = task.get();
            }
            catch (Exception e) {
                return;
            }
            successCallback.accept(result);
            this.tasks.remove(task);
            if (this.tasks.isEmpty()) {
                this.view.setFinishedSuccessfully(true);
                this.view.close();
            }
        });
        task.setOnFailed(event -> {
            this.view.setFinishedSuccessfully(false);
            this.cancel();
            errorCallback.accept(task.getException());
        });
        executorService.submit((Runnable)task);
    }

    public void cancel() {
        this.view.setCancelled(true);
        this.view.setFinishedSuccessfully(false);
        for (Task<?> task : this.tasks) {
            task.cancel();
        }
        this.view.close();
    }
}

