/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.controller;

import java.util.ArrayList;
import java.util.List;
import org.aksw.limes.core.gui.model.Config;
import org.aksw.limes.core.gui.model.metric.Measure;
import org.aksw.limes.core.gui.model.metric.MetricParser;
import org.aksw.limes.core.gui.model.metric.Node;
import org.aksw.limes.core.gui.model.metric.Operator;
import org.aksw.limes.core.gui.model.metric.Output;
import org.aksw.limes.core.gui.model.metric.Property;
import org.aksw.limes.core.gui.util.SourceOrTarget;
import org.aksw.limes.core.gui.view.ToolBox;
import org.aksw.limes.core.gui.view.graphBuilder.GraphBuildView;
import org.aksw.limes.core.gui.view.graphBuilder.NodeView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphBuildController {
    private static final Logger logger = LoggerFactory.getLogger(GraphBuildController.class);
    private Config currentConfig;
    private final GraphBuildView graphBuildView;
    private final ToolBox toolbox;

    public GraphBuildController(Config currentConfig, GraphBuildView view, ToolBox toolbox) {
        this.currentConfig = currentConfig;
        this.graphBuildView = view;
        this.toolbox = toolbox;
    }

    public GraphBuildController(GraphBuildView view, ToolBox toolbox) {
        this.graphBuildView = view;
        this.toolbox = toolbox;
    }

    public void setConfig(Config currentConfig) {
        this.currentConfig = currentConfig;
    }

    public void generateGraphFromConfig() {
        this.graphBuildView.nodeList.clear();
        this.graphBuildView.edited = true;
        this.graphBuildView.draw();
        Output out = this.currentConfig.getMetric();
        ArrayList<NodeView> newNodeList = new ArrayList<NodeView>();
        NodeView outView = new NodeView(200, 200, 2, out.id, this.graphBuildView, out);
        newNodeList.add(outView);
        this.graphBuildView.nodeList = this.drawChildRek(outView, outView.nodeData.getChilds().get(0), newNodeList);
        this.graphBuildView.reversedNodeList = (ArrayList)this.graphBuildView.nodeList.clone();
        this.layoutGraph();
    }

    public void setConfigFromGraph() {
        NodeView output = this.getOutputNode();
        this.currentConfig.setAcceptanceThreshold(output.nodeData.param1);
        this.currentConfig.setVerificationThreshold(output.nodeData.param2);
        this.currentConfig.setMetricExpression(MetricParser.parse(output.nodeData.toString(), this.currentConfig.getSourceInfo().getVar().replaceAll("\\?", ""), this.currentConfig).toString());
    }

    public NodeView getOutputNode() {
        for (int i = 0; i < this.graphBuildView.nodeList.size(); ++i) {
            if (this.graphBuildView.nodeList.get((int)i).nodeShape != 2) continue;
            return this.graphBuildView.nodeList.get(i);
        }
        logger.error("Could not find output node!");
        return null;
    }

    public void deleteGraph() {
        this.graphBuildView.nodeList.clear();
        this.graphBuildView.edited = true;
        this.graphBuildView.addNode(300, 300, 2, new Output());
        this.graphBuildView.draw();
    }

    public void layoutGraph() {
        double h = this.graphBuildView.getHeight();
        double w = this.graphBuildView.getWidth();
        ArrayList stages = new ArrayList();
        this.graphBuildView.nodeList.forEach(e -> {
            int i = 0;
            NodeView test = e;
            while (test.parent != null) {
                test = test.parent;
                ++i;
            }
            try {
                stages.get(i);
            }
            catch (IndexOutOfBoundsException exception) {
                try {
                    stages.add(i, 0);
                }
                catch (IndexOutOfBoundsException e2) {
                    this.rekListAdder(i, stages);
                }
            }
            stages.set(i, Integer.sum(Integer.max((Integer)stages.get(i), 0), 1));
        });
        ArrayList stages2 = new ArrayList(stages);
        this.graphBuildView.nodeList.forEach(e -> {
            int i = 0;
            int hInt = stages.size();
            NodeView test = e;
            while (test.parent != null) {
                test = test.parent;
                ++i;
            }
            e.setXY((int)(w - w * (double)((Integer)stages2.get(i)).intValue() / (double)((Integer)stages.get(i)).intValue() + w / (double)(2 * (Integer)stages.get(i)) - (double)e.getWidth() + this.toolbox.getWidth() / 2.0), (int)(h + (double)e.getHeight() - h * (double)(i + 1) / (double)hInt));
            stages2.set(i, (Integer)stages2.get(i) - 1);
        });
        this.graphBuildView.draw();
    }

    private List<Integer> rekListAdder(int index, List<Integer> stages) {
        try {
            stages.add(index - 1, 0);
            stages.add(index, 0);
            return stages;
        }
        catch (IndexOutOfBoundsException e) {
            this.rekListAdder(index - 1, stages);
            stages.add(index, 0);
            return stages;
        }
    }

    private ArrayList<NodeView> drawChildRek(NodeView parent, Node node, ArrayList<NodeView> nodeList) {
        Property castedNode;
        int nodeShape = new Measure("").identifiers().contains(node.id) ? 1 : (Operator.identifiers.contains(node.id) ? 3 : ((castedNode = (Property)node).getOrigin() == SourceOrTarget.SOURCE ? 4 : 5));
        NodeView thisNode = new NodeView(200, 200, nodeShape, node.id, this.graphBuildView, node);
        nodeList.add(thisNode);
        parent.addChildWithOutDataLinking(thisNode);
        if (node.getMaxChilds() == 0) {
            return nodeList;
        }
        this.drawChildRek(thisNode, node.getChilds().get(0), nodeList);
        this.drawChildRek(thisNode, node.getChilds().get(1), nodeList);
        return nodeList;
    }

    public Config getConfig() {
        return this.currentConfig;
    }
}

