/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.view.graphBuilder;

import java.util.ArrayList;
import java.util.Collections;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Alert;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import org.aksw.limes.core.gui.controller.GraphBuildController;
import org.aksw.limes.core.gui.model.Config;
import org.aksw.limes.core.gui.model.metric.Output;
import org.aksw.limes.core.gui.model.metric.Property;
import org.aksw.limes.core.gui.util.SourceOrTarget;
import org.aksw.limes.core.gui.view.ToolBox;
import org.aksw.limes.core.gui.view.graphBuilder.NodeContextMenu;
import org.aksw.limes.core.gui.view.graphBuilder.NodeView;
import org.aksw.limes.core.gui.view.graphBuilder.ThresholdModifyView;
import org.aksw.limes.core.io.config.KBInfo;

public class GraphBuildView
extends Canvas {
    public GraphBuildController graphBuildController;
    public ArrayList<NodeView> nodeList;
    public ArrayList<NodeView> reversedNodeList;
    public boolean isLinking;
    public NodeView linkNode;
    public boolean edited = false;
    public boolean contextMenuIsShown = false;
    private boolean nodeClicked;
    private NodeView clickedNode;
    private NodeContextMenu contextMenu;
    private final double[] mouseCanvasPosition = new double[]{0.0, 0.0};
    private static final int HOVER_TIME_UNTIL_NODE_TOOLTIP_IS_DISPLAYED = 1500;
    private final double[] mouseScreenPosition = new double[]{0.0, 0.0};
    private Tooltip nodeTooltip = null;
    private Task<Void> checkMouseMovementThread = null;

    public GraphBuildView(Config currentConfig, ToolBox toolbox) {
        this.widthProperty().addListener(evt -> this.draw());
        this.heightProperty().addListener(evt -> this.draw());
        this.nodeList = new ArrayList();
        this.reversedNodeList = (ArrayList)this.nodeList.clone();
        Collections.reverse(this.reversedNodeList);
        this.nodeClicked = false;
        this.isLinking = false;
        this.addNode(300, 300, 2, new Output());
        this.graphBuildController = new GraphBuildController(currentConfig, this, toolbox);
    }

    public GraphBuildView(ToolBox toolbox) {
        this.widthProperty().addListener(evt -> this.draw());
        this.heightProperty().addListener(evt -> this.draw());
        this.nodeList = new ArrayList();
        this.reversedNodeList = (ArrayList)this.nodeList.clone();
        Collections.reverse(this.reversedNodeList);
        this.nodeClicked = false;
        this.isLinking = false;
        this.addNode(300, 300, 2, new Output());
        this.graphBuildController = new GraphBuildController(this, toolbox);
    }

    public boolean isResizable() {
        return true;
    }

    public double prefWidth(double width) {
        return this.getWidth();
    }

    public double prefHeight(double height) {
        return this.getHeight();
    }

    public void setCurrentConfig(Config config) {
        this.graphBuildController.setConfig(config);
    }

    public void start() {
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> {
            if (this.isLinking) {
                for (NodeView node : this.nodeList) {
                    if (!node.contains((int)e.getX(), (int)e.getY())) continue;
                    this.isLinking = false;
                    if (!this.linkNode.addParent(node)) {
                        Alert alert = new Alert(Alert.AlertType.INFORMATION);
                        alert.setContentText("Clicked Node is no valid Parent!");
                        alert.showAndWait();
                    }
                    this.edited = true;
                    this.draw();
                    break;
                }
            }
        });
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, e -> {
            if (this.contextMenuIsShown) {
                this.contextMenu.hide();
                this.contextMenuIsShown = false;
            }
            if (e.getButton().equals((Object)MouseButton.PRIMARY) && e.getClickCount() == 2) {
                int index = 0;
                for (NodeView node : this.nodeList) {
                    if (node.contains((int)e.getX(), (int)e.getY())) {
                        this.clickedNode = this.nodeList.get(index);
                        break;
                    }
                    ++index;
                }
                if (this.clickedNode.nodeShape == 3 || this.clickedNode.nodeShape == 2) {
                    new ThresholdModifyView(this, this.clickedNode);
                }
            }
        });
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, e -> {
            int index = 0;
            for (NodeView node : this.reversedNodeList) {
                if (node.contains((int)e.getX(), (int)e.getY())) {
                    this.nodeClicked = true;
                    this.clickedNode = this.reversedNodeList.get(index);
                    this.nodeList.remove(this.clickedNode);
                    this.nodeList.add(this.clickedNode);
                    this.reversedNodeList = (ArrayList)this.nodeList.clone();
                    break;
                }
                ++index;
            }
        });
        this.addEventHandler(MouseEvent.MOUSE_DRAGGED, e -> {
            if (this.nodeTooltip != null) {
                this.nodeTooltip.hide();
                this.nodeTooltip = null;
                if (this.checkMouseMovementThread != null) {
                    this.checkMouseMovementThread.cancel();
                    this.checkMouseMovementThread = null;
                }
            }
            if (this.nodeClicked) {
                this.clickedNode.setXY((int)e.getX() - this.clickedNode.getWidth() / 2, (int)e.getY() - this.clickedNode.getHeight() / 2);
                this.draw();
            }
        });
        this.addEventHandler(MouseEvent.MOUSE_RELEASED, e -> {
            this.nodeClicked = false;
        });
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> {
            if (e.getButton() == MouseButton.SECONDARY) {
                int index = 0;
                boolean NodeClickedBySecondary = false;
                for (NodeView node : this.nodeList) {
                    if (node.contains((int)e.getX(), (int)e.getY())) {
                        this.clickedNode = this.nodeList.get(index);
                        NodeClickedBySecondary = true;
                        break;
                    }
                    if (node.containsLinkMid((int)e.getX(), (int)e.getY())) {
                        node.deleteParent(node.parent);
                        this.draw();
                    }
                    ++index;
                }
                if (NodeClickedBySecondary && this.clickedNode.nodeShape != 2 && !this.contextMenuIsShown) {
                    this.contextMenu = new NodeContextMenu(this, this.clickedNode);
                    this.contextMenu.show((Node)this, e.getScreenX(), e.getScreenY());
                }
            }
        });
        this.addEventHandler(MouseEvent.MOUSE_MOVED, e -> {
            this.mouseScreenPosition[0] = e.getScreenX();
            this.mouseScreenPosition[1] = e.getScreenY();
            this.mouseCanvasPosition[0] = e.getX();
            this.mouseCanvasPosition[1] = e.getY();
            if (this.isLinking) {
                this.draw();
            }
        });
        this.addEventHandler(MouseEvent.MOUSE_MOVED, e -> {
            this.showNodeTooltip((MouseEvent)e);
            if (this.nodeTooltip != null && this.nodeTooltip.isShowing()) {
                this.nodeTooltip.hide();
                this.nodeTooltip = null;
            }
        });
        this.draw();
    }

    private void showNodeTooltip(MouseEvent e) {
        boolean insideNode = false;
        for (NodeView node : this.nodeList) {
            if (!node.contains((int)e.getX(), (int)e.getY())) continue;
            insideNode = true;
            if (this.nodeTooltip != null) continue;
            this.nodeTooltip = new Tooltip(node.toString());
            this.checkMouseMovementThread = new Task<Void>(){

                protected Void call() throws Exception {
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return null;
                }
            };
            this.checkMouseMovementThread.setOnSucceeded(event -> {
                if (this.nodeTooltip != null) {
                    if (!this.contextMenuIsShown && !this.isLinking && node.contains((int)this.mouseCanvasPosition[0], (int)this.mouseCanvasPosition[1])) {
                        this.nodeTooltip.show((Node)this.getParent(), this.mouseScreenPosition[0], this.mouseScreenPosition[1]);
                    } else {
                        this.nodeTooltip = null;
                    }
                }
            });
            new Thread((Runnable)this.checkMouseMovementThread).start();
        }
        if (this.nodeTooltip != null && !insideNode) {
            this.nodeTooltip.hide();
            this.nodeTooltip = null;
            if (this.checkMouseMovementThread != null) {
                this.checkMouseMovementThread.cancel();
                this.checkMouseMovementThread = null;
            }
        }
    }

    public void draw() {
        GraphicsContext gc = this.getGraphicsContext2D();
        gc.clearRect(0.0, 0.0, this.getWidth(), this.getHeight());
        if (this.isLinking) {
            gc.strokeLine((double)(this.linkNode.x + this.linkNode.getWidth() / 2), (double)(this.linkNode.y + this.linkNode.getHeight() / 2), this.mouseCanvasPosition[0], this.mouseCanvasPosition[1]);
        }
        this.nodeList.forEach(e -> e.drawLink());
        this.nodeList.forEach(e -> {
            if (e.nodeShape == 4 || e.nodeShape == 5) {
                KBInfo info;
                Config c = this.graphBuildController.getConfig();
                String propString = c.removeVar(e.nodeData.id, ((Property)e.nodeData).getOrigin());
                SourceOrTarget sot = ((Property)e.nodeData).getOrigin();
                KBInfo kBInfo = info = sot == SourceOrTarget.SOURCE ? c.getSourceInfo() : c.getTargetInfo();
                if (info.getOptionalProperties().contains(propString) || info.getOptionalProperties().contains(c.reverseRename(propString, sot))) {
                    ((Property)e.nodeData).setOptional(true);
                } else {
                    ((Property)e.nodeData).setOptional(false);
                }
            }
            e.displayNode();
        });
    }

    public void addNode(int x, int y, int shape, org.aksw.limes.core.gui.model.metric.Node node) {
        int[] xy = this.findFreePlace(x, y);
        if (xy != null) {
            int new_x = xy[0];
            int new_y = xy[1];
            NodeView nv = new NodeView(new_x, new_y, shape, "test", this, node);
            nv.displayNode();
            this.nodeList.add(nv);
            this.reversedNodeList = (ArrayList)this.nodeList.clone();
            Collections.reverse(this.reversedNodeList);
        }
    }

    private int[] findFreePlace(int x, int y) {
        for (int i = 0; i < this.nodeList.size(); ++i) {
            if (this.nodeList.get((int)i).x != x && this.nodeList.get((int)i).y != y) continue;
            i = -1;
            if ((x += 10) < (int)this.widthProperty().doubleValue() && (y += 10) < (int)this.heightProperty().doubleValue()) continue;
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setContentText("Cannot add more nodes! Please move or delete some nodes!");
            alert.showAndWait();
            return null;
        }
        return new int[]{x, y};
    }

    public void removeNodeView(NodeView node) {
        this.edited = true;
        boolean remove = false;
        for (NodeView item : this.nodeList) {
            if (!node.nodeData.id.equals(item.nodeData.id)) continue;
            remove = true;
        }
        this.reversedNodeList = this.nodeList;
        Collections.reverse(this.reversedNodeList);
        if (remove) {
            node.deleteNode();
            this.nodeList.remove(node);
            this.draw();
        }
    }
}

