/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.util.sparql;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.aksw.limes.core.gui.model.Config;
import org.aksw.limes.core.gui.util.AdvancedKBInfo;
import org.aksw.limes.core.gui.util.AdvancedMemoryCache;
import org.aksw.limes.core.gui.util.GetAllSparqlQueryModule;
import org.aksw.limes.core.gui.util.sparql.PrefixHelper;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.config.KBInfo;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.vocabulary.OWL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPARQLHelper {
    public static final String DBPEDIA_ENDPOINT_OFFICIAL = "http://dbpedia.org/sparql";
    public static final String DBPEDIA_ENDPOINT_LIVE = "http://live.dbpedia.org/sparql";
    public static final String DBPEDIA_ENDPOINT = "http://dbpedia.org/sparql";
    protected static final Map<String, AdvancedMemoryCache> samples = new HashMap<String, AdvancedMemoryCache>();
    static final Set<String> blackset = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("http://dbpedia.org/property/wikiPageUsesTemplate", "http://dbpedia.org/property/wikiPageExternalLink")));
    private static final Logger logger = LoggerFactory.getLogger((String)SPARQLHelper.class.getName());

    public static String formatPrefixes(Map<String, String> prefixes) {
        if (prefixes.isEmpty()) {
            return "";
        }
        StringBuffer prefixSPARQLString = new StringBuffer();
        for (String key : prefixes.keySet()) {
            prefixSPARQLString.append("PREFIX " + key + ": <" + prefixes.get(key) + ">" + '\n');
        }
        return prefixSPARQLString.substring(0, prefixSPARQLString.length() - 1);
    }

    public static String lastPartOfURL(String url) {
        return url.substring(Math.max(url.lastIndexOf(35), url.lastIndexOf(47)) + 1);
    }

    public static Set<String> subclassesOf(String endpoint, String graph, String clazz, Model model) {
        Element element;
        Cache cache = CacheManager.getInstance().getCache("subclasses");
        List<String> key = Arrays.asList(endpoint, graph, clazz);
        if (cache.isKeyInCache(key)) {
            element = cache.get(key);
        } else {
            element = new Element(key, SPARQLHelper.subClassesOfUncached(endpoint, graph, clazz, model));
            cache.put(element);
        }
        cache.flush();
        return (Set)((Object)element.getValue());
    }

    public static Set<String> subClassesOfUncached(String endpoint, String graph, String clazz, Model model) {
        int MAX_CHILDREN = 100;
        String query = "SELECT distinct(?class) WHERE { ?class rdfs:subClassOf " + SPARQLHelper.wrapIfNecessary(clazz) + ". } LIMIT " + 100;
        query = PrefixHelper.addPrefixes(query);
        PrefixHelper.restrictPrefixes(PrefixHelper.getPrefixes(), query);
        return SPARQLHelper.resultSetToList(SPARQLHelper.querySelect(query, endpoint, graph, model));
    }

    public static Set<String> rootClasses(String endpoint, String graph, Model model) {
        Element element;
        List<String> key;
        Cache cache = CacheManager.getInstance().getCache("rootclasses");
        if (cache == null) {
            logger.info("cachenull");
        }
        if (cache.isKeyInCache(key = Arrays.asList(endpoint, graph))) {
            element = cache.get(key);
        } else {
            element = new Element(key, SPARQLHelper.rootClassesUncached(endpoint, graph, model, null));
            cache.put(element);
        }
        cache.flush();
        return (Set)element.getObjectValue();
    }

    public static Set<String> rootClassesUncached(String endpoint, String graph, Model model, Config config) {
        String queryForOWLThing = "SELECT ?class WHERE {?class rdfs:subClassOf owl:Thing} limit 1";
        if (!SPARQLHelper.resultSetToList(SPARQLHelper.querySelect(PrefixHelper.addPrefixes("SELECT ?class WHERE {?class rdfs:subClassOf owl:Thing} limit 1"), endpoint, graph, model)).isEmpty()) {
            Map<String, String> prefixesToAdd = PrefixHelper.restrictPrefixes(PrefixHelper.getPrefixes(), "SELECT ?class WHERE {?class rdfs:subClassOf owl:Thing} limit 1");
            for (String key : prefixesToAdd.keySet()) {
                config.addPrefix(key, prefixesToAdd.get(key));
            }
            return Collections.singleton(OWL.Thing.toString());
        }
        System.err.println("no owl:Thing found for endpoint " + endpoint + ", using fallback.");
        String queryForParentlessClasses = "SELECT distinct(?class) WHERE {{?class a owl:Class} UNION {?class a rdfs:Class}. OPTIONAL {?class rdfs:subClassOf ?superClass.} FILTER (!BOUND(?superClass))}";
        Set<String> classes = SPARQLHelper.resultSetToList(SPARQLHelper.querySelect(PrefixHelper.addPrefixes("SELECT distinct(?class) WHERE {{?class a owl:Class} UNION {?class a rdfs:Class}. OPTIONAL {?class rdfs:subClassOf ?superClass.} FILTER (!BOUND(?superClass))}"), endpoint, graph, model));
        if (!classes.isEmpty()) {
            Map<String, String> prefixesToAdd = PrefixHelper.restrictPrefixes(PrefixHelper.getPrefixes(), "SELECT distinct(?class) WHERE {{?class a owl:Class} UNION {?class a rdfs:Class}. OPTIONAL {?class rdfs:subClassOf ?superClass.} FILTER (!BOUND(?superClass))}");
            for (String key : prefixesToAdd.keySet()) {
                config.addPrefix(key, prefixesToAdd.get(key));
            }
            return classes;
        }
        System.err.println("no root owl:Class instance for endpoint " + endpoint + ", using fallback fallback.");
        String query = "SELECT distinct(?class) WHERE {?x a ?class. OPTIONAL {?class rdfs:subClassOf ?superClass.} FILTER (!BOUND(?superClass))}";
        classes = SPARQLHelper.resultSetToList(SPARQLHelper.querySelect(PrefixHelper.addPrefixes(query), endpoint, graph, model));
        classes.remove("http://www.w3.org/1999/02/22-rdf-syntax-ns#Property");
        classes.remove("http://www.w3.org/2000/01/rdf-schema#Class");
        classes.remove("http://www.w3.org/2002/07/owl#DatatypeProperty");
        classes.remove("http://www.w3.org/2002/07/owl#DatatypeProperty");
        if (!classes.isEmpty()) {
            Map<String, String> prefixesToAdd = PrefixHelper.restrictPrefixes(PrefixHelper.getPrefixes(), query);
            for (String key : prefixesToAdd.keySet()) {
                config.addPrefix(key, prefixesToAdd.get(key));
            }
            return classes;
        }
        System.err.println("very very bad endpoint using objects of rdf:type property");
        query = "SELECT distinct(?class) WHERE{?x a ?class.}";
        classes = SPARQLHelper.resultSetToList(SPARQLHelper.querySelect(PrefixHelper.addPrefixes(query), endpoint, graph, model));
        classes.remove("http://www.w3.org/1999/02/22-rdf-syntax-ns#Property");
        classes.remove("http://www.w3.org/2000/01/rdf-schema#Class");
        classes.remove("http://www.w3.org/2002/07/owl#DatatypeProperty");
        classes.remove("http://www.w3.org/2002/07/owl#DatatypeProperty");
        if (!classes.isEmpty()) {
            Map<String, String> prefixesToAdd = PrefixHelper.restrictPrefixes(PrefixHelper.getPrefixes(), query);
            for (String key : prefixesToAdd.keySet()) {
                config.addPrefix(key, prefixesToAdd.get(key));
            }
            return classes;
        }
        query = "SELECT distinct ?x WHERE{ ?y <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> ?x}";
        classes = SPARQLHelper.resultSetToList(SPARQLHelper.querySelect(PrefixHelper.addPrefixes(query), endpoint, graph, model));
        classes.remove("http://www.w3.org/1999/02/22-rdf-syntax-ns#Property");
        classes.remove("http://www.w3.org/2000/01/rdf-schema#Class");
        classes.remove("http://www.w3.org/2002/07/owl#DatatypeProperty");
        classes.remove("http://www.w3.org/2002/07/owl#DatatypeProperty");
        Map<String, String> prefixesToAdd = PrefixHelper.restrictPrefixes(PrefixHelper.getPrefixes(), query);
        for (String key : prefixesToAdd.keySet()) {
            config.addPrefix(key, prefixesToAdd.get(key));
        }
        return classes;
    }

    public static String wrapIfNecessary(String uriString) {
        if (uriString.startsWith("http://")) {
            return "<" + uriString + ">";
        }
        return uriString;
    }

    public static Set<String> properties(String endpoint, String graph, String className, Model model) {
        Element element;
        Cache cache = CacheManager.getInstance().getCache("properties");
        List<String> key = Arrays.asList(endpoint, graph, className);
        if (cache.isKeyInCache(key)) {
            element = cache.get(key);
        } else {
            element = new Element(key, SPARQLHelper.propertiesUncached(endpoint, graph, className, model));
            cache.put(element);
        }
        cache.flush();
        return (Set)element.getObjectValue();
    }

    public static Set<String> propertiesUncached(String endpoint, String graph, String className, Model model) {
        if (className.isEmpty()) {
            className = null;
        }
        if (className != null) {
            className = className.trim();
            className = className.replaceAll("<", "");
            className = className.replaceAll(">", "");
        }
        if ("owl:Thing".equals(className) || "http://www.w3.org/2002/07/owl#Thing".equals(className)) {
            className = null;
        }
        AdvancedKBInfo info = className != null ? new AdvancedKBInfo("", endpoint, "s", graph, "rdf:type", className) : new AdvancedKBInfo("", endpoint, "s", graph);
        try {
            HashSet<String> properties = new HashSet<String>(Arrays.asList(SPARQLHelper.commonProperties(info, 0.8, 20, 50)));
            if (className != null) {
                properties.addAll(SPARQLHelper.getPropertiesWithDomain(endpoint, graph, className, model));
            }
            properties.removeAll(blackset);
            return properties;
        }
        catch (Exception e) {
            throw new RuntimeException("error getting the properties for endpoint " + endpoint, e);
        }
    }

    static Set<String> getPropertiesWithDomain(String endpoint, String graph, String clazz, Model model) {
        long start = System.currentTimeMillis();
        String query = PrefixHelper.addPrefixes("select distinct ?p where { ?i a " + SPARQLHelper.wrapIfNecessary(clazz) + " .  ?i ?p ?o . }");
        Set<String> properties = SPARQLHelper.resultSetToList(SPARQLHelper.querySelect(query, endpoint, graph, model));
        long end = System.currentTimeMillis();
        logger.trace(properties.size() + " properties with domain " + clazz + " from endpoint " + endpoint + " in " + (end - start) + " ms.");
        return properties;
    }

    public static QueryExecution queryExecution(String query, String graph, String endpoint, Model model) {
        QueryExecution qexec;
        ARQ.setNormalMode();
        Query sparqlQuery = QueryFactory.create((String)query, (Syntax)Syntax.syntaxARQ);
        if (model == null) {
            qexec = graph != null ? QueryExecutionFactory.sparqlService((String)endpoint, (Query)sparqlQuery, (String)graph) : QueryExecutionFactory.sparqlService((String)endpoint, (Query)sparqlQuery);
        } else {
            logger.info("Query to Model...");
            qexec = QueryExecutionFactory.create((Query)sparqlQuery, (Model)model);
        }
        return qexec;
    }

    public static Set<String> resultSetToList(ResultSet rs) {
        HashSet<String> list = new HashSet<String>();
        while (rs.hasNext()) {
            QuerySolution qs = rs.nextSolution();
            logger.trace("qs: " + qs.toString());
            if (qs.toString().equals("")) continue;
            try {
                list.add(URLDecoder.decode(qs.get((String)qs.varNames().next()).toString(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                list.add(qs.get((String)qs.varNames().next()).toString());
                e.printStackTrace();
            }
        }
        return list;
    }

    public static ResultSet querySelect(String query, String endpoint, String graph, Model model) {
        try {
            logger.trace("Endpoint: " + endpoint + " graph: " + graph + "\n" + query);
            ResultSet results = SPARQLHelper.queryExecution(query, graph, endpoint, model).execSelect();
            return results;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error with query \"" + query + "\" at endpoint \"" + endpoint + "\" and graph \"" + graph + "\"", e);
        }
    }

    protected static AdvancedMemoryCache getSample(KBInfo kb, int sampleSize) {
        String hashString = Integer.toString(kb.hashCode());
        if (!samples.containsKey(hashString)) {
            samples.put(hashString, SPARQLHelper.generateSample(kb, sampleSize));
        }
        return samples.get(hashString);
    }

    protected static AdvancedMemoryCache generateSample(KBInfo kb, int sampleSize) {
        GetAllSparqlQueryModule queryModule = new GetAllSparqlQueryModule(kb, sampleSize);
        AdvancedMemoryCache cache = new AdvancedMemoryCache();
        try {
            queryModule.fillCache((ACache)cache, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return cache;
    }

    public static String[] commonProperties(KBInfo kb, double threshold, Integer limit, Integer sampleSize) throws Exception {
        return SPARQLHelper.getSample(kb, sampleSize).getCommonProperties(threshold, limit);
    }
}

