/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.util;

import java.lang.reflect.Field;
import org.aksw.limes.core.gui.util.Restriction;
import org.aksw.limes.core.gui.util.sparql.SPARQLHelper;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.config.KBInfo;
import org.aksw.limes.core.io.query.ModelRegistry;
import org.aksw.limes.core.io.query.SparqlQueryModule;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetAllSparqlQueryModule
extends SparqlQueryModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetAllSparqlQueryModule.class);
    Integer subjectLimit = null;

    public GetAllSparqlQueryModule(KBInfo kbinfo) {
        super(kbinfo);
    }

    public GetAllSparqlQueryModule(KBInfo kbinfo, Integer subjectLimit) {
        super(kbinfo);
        this.subjectLimit = subjectLimit;
    }

    public static ResultSet querySelect(String query, KBInfo kb) {
        Model model = (Model)ModelRegistry.getInstance().getMap().get(kb.getEndpoint());
        SPARQLHelper.formatPrefixes(kb.getPrefixes());
        return SPARQLHelper.querySelect(query, kb.getEndpoint(), kb.getGraph(), model);
    }

    protected KBInfo getKB() {
        try {
            Field field = SparqlQueryModule.class.getDeclaredField("kb");
            field.setAccessible(true);
            return (KBInfo)field.get((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void fillCache(ACache cache, boolean paginate) {
        try {
            this.fillCache(cache, null, paginate);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean hasNext(ResultSet rs) {
        try {
            return rs.hasNext();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void fillCache(ACache cache, String getOnlyThisProperty, boolean paginate) throws Exception {
        String var = this.getKB().getVar().replace("?", "");
        long startTime = System.currentTimeMillis();
        String query = "";
        LOGGER.debug(this.getKB().getPrefixes().toString());
        for (Object key : this.getKB().getPrefixes().keySet()) {
            query = query + "PREFIX " + (String)key + ": <" + (String)this.getKB().getPrefixes().get(key) + ">\n";
        }
        query = query + "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n";
        query = query + "SELECT DISTINCT ?" + var + " ?p ?o ";
        query = query + "\n";
        query = query + "WHERE {?" + var + " ?p ?o. \n";
        if (this.subjectLimit != null) {
            query = query + "{ select ?" + var + " where {";
        }
        if (this.getKB().getRestrictions().size() > 0) {
            for (String restrictionStr : this.getKB().getRestrictions()) {
                String where = Restriction.fromString(restrictionStr).toString(var);
                query = query + where + " .\n";
            }
        } else {
            query = query + '?' + var + " ?p ?o.";
        }
        if (getOnlyThisProperty != null) {
            query = query + '?' + var + " <" + getOnlyThisProperty + "> ?o.";
        }
        if (this.subjectLimit != null) {
            query = query + "} limit " + this.subjectLimit + "}";
        }
        query = query + "}\n";
        LOGGER.info("Querying the endpoint.");
        int offset = 0;
        boolean moreResults = false;
        int counter = 0;
        String basicQuery = query;
        do {
            if (this.getKB().getPageSize() > 0) {
                query = basicQuery + " LIMIT " + this.getKB().getPageSize() + " OFFSET " + offset;
            }
            ResultSet results = null;
            try {
                results = GetAllSparqlQueryModule.querySelect(query, this.getKB());
            }
            catch (Exception e) {
                throw new Exception("error with query " + query + " " + e.getLocalizedMessage(), e);
            }
            moreResults = this.hasNext(results);
            while (this.hasNext(results)) {
                QuerySolution soln = results.nextSolution();
                try {
                    String uri = soln.get("?" + var).toString();
                    String property = soln.get("?p").toString();
                    String value = soln.get("?o").toString();
                    cache.addTriple(uri, property, value);
                }
                catch (Exception e) {
                    throw new Exception("Error while processing " + soln, e);
                }
                ++counter;
            }
            offset += this.getKB().getPageSize();
        } while (paginate && moreResults && this.getKB().getPageSize() > 0);
        LOGGER.info("Retrieved " + counter + " instances.");
        LOGGER.info(cache.size() + " of these instances contained valid data.");
        LOGGER.info("Retrieving statements took " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds.");
    }
}

