/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.view.graphBuilder;

import java.util.List;
import java.util.Vector;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import org.aksw.limes.core.gui.model.metric.Node;
import org.aksw.limes.core.gui.view.graphBuilder.GraphBuildView;
import org.aksw.limes.core.gui.view.graphBuilder.NodeViewRectangle;

public class NodeView {
    public static final int METRIC = 1;
    public static final int OUTPUT = 2;
    public static final int OPERATOR = 3;
    public static final int SOURCE = 4;
    public static final int TARGET = 5;
    private final Image arrow = new Image("gui/arrow.png", 10.0, 10.0, true, true);
    public int x;
    public int y;
    public int nodeShape;
    public Node nodeData;
    public NodeView parent = null;
    GraphBuildView gbv;
    private int width = 200;
    private int height = 80;
    private final List<NodeView> children = new Vector<NodeView>();
    private int midLinkX;
    private int midLinkY;
    private NodeViewRectangle nvr;

    public NodeView(int x, int y, int nodeShape, String label, GraphBuildView gbv, Node node) {
        this.x = x;
        this.y = y;
        this.nodeShape = nodeShape;
        this.width = nodeShape == 2 ? 230 : 200;
        this.height = nodeShape != 1 ? 80 : 20;
        this.gbv = gbv;
        this.nodeData = node;
    }

    public void displayNode() {
        GraphicsContext gc = this.gbv.getGraphicsContext2D();
        this.nvr = new NodeViewRectangle(this.x, this.y, this.nodeShape, this, this.nodeData);
        this.nvr.drawNodeViewRectangle(gc);
    }

    public void setXY(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public boolean contains(int x, int y) {
        int minX = this.x;
        int maxX = this.x + this.width;
        int minY = this.y;
        int maxY = this.y + this.height;
        if (x >= minX && x <= maxX) {
            return y >= minY && y <= maxY;
        }
        return false;
    }

    public boolean containsLinkMid(int x, int y) {
        int minX = this.midLinkX - 10;
        int maxX = this.midLinkX + 10;
        int minY = this.midLinkY - 10;
        int maxY = this.midLinkY + 10;
        if (x >= minX && x <= maxX) {
            return y >= minY && y <= maxY;
        }
        return false;
    }

    public boolean addParent(NodeView parent) {
        boolean test = parent.nodeData.addChild(this.nodeData);
        if (!test) {
            return false;
        }
        parent.children.add(this);
        this.parent = parent;
        return true;
    }

    public void deleteParent(NodeView parent) {
        parent.nodeData.removeChild(this.nodeData);
        parent.children.remove(this);
        this.parent = null;
    }

    public void addChildWithOutDataLinking(NodeView child) {
        this.children.add(child);
        child.parent = this;
        child.nodeData.overwriteParent(this.nodeData);
    }

    public void drawLink() {
        GraphicsContext gc = this.gbv.getGraphicsContext2D();
        gc.setStroke((Paint)Color.BLACK);
        this.children.forEach(nodeView -> {
            int x1 = this.x + this.width / 2;
            int y1 = this.y + this.height / 2;
            int x2 = nodeView.x + nodeView.width / 2;
            int y2 = nodeView.y + nodeView.height / 2;
            gc.strokeLine((double)x1, (double)y1, (double)x2, (double)y2);
            double linkMidX = (double)(x1 + x2) / 2.0;
            nodeView.midLinkX = (int)linkMidX;
            double linkMidY = (double)(y1 + y2) / 2.0;
            nodeView.midLinkY = (int)linkMidY;
            double rotate = Math.toDegrees(Math.atan2(y2 - y1, x2 - x1)) + 225.0;
            gc.setTransform(new Affine((Transform)new Rotate(rotate, linkMidX, linkMidY)));
            double arrowX = linkMidX - this.arrow.getWidth() * 3.0 / 4.0;
            double arrowY = linkMidY - this.arrow.getWidth() / 4.0;
            gc.drawImage(this.arrow, arrowX, arrowY);
            gc.setTransform(new Affine());
        });
    }

    public void deleteNode() {
        if (this.parent != null) {
            this.parent.nodeData.removeChild(this.nodeData);
            this.parent.children.remove(this);
        }
        this.children.forEach(e -> {
            e.nodeData.removeParent();
            e.parent = null;
        });
        this.parent = null;
        this.nodeData.removeParent();
    }

    public String toString() {
        String str = this.nodeData.id + "\n";
        switch (this.nodeShape) {
            case 2: {
                str = str + "Acceptance threshold: " + this.nodeData.param1 + "\n";
                str = str + "Verification threshold: " + this.nodeData.param2 + "\n";
                break;
            }
            case 3: {
                if (this.nodeData.getChilds().isEmpty()) {
                    str = str + "parent1 threshold: " + this.nodeData.param1 + "\n";
                    str = str + "parent2 threshold: " + this.nodeData.param2 + "\n";
                    break;
                }
                if (this.nodeData.getChilds().size() == 1) {
                    str = str + this.nodeData.getChilds().get((int)0).id + " threshold: " + this.nodeData.param1 + "\n";
                    str = str + "parent2 threshold: " + this.nodeData.param2 + "\n";
                    break;
                }
                str = str + this.nodeData.getChilds().get((int)0).id + " threshold: " + this.nodeData.param1 + "\n";
                str = str + this.nodeData.getChilds().get((int)1).id + " threshold: " + this.nodeData.param2 + "\n";
            }
        }
        return str;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMidLinkX() {
        return this.midLinkX;
    }

    public int getMidLinkY() {
        return this.midLinkY;
    }
}

