/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.view;

import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import org.aksw.limes.core.gui.controller.WizardController;
import org.aksw.limes.core.gui.view.IEditView;

public class WizardView {
    private WizardController controller;
    private Button buttonBack;
    private Button buttonNext;
    private BorderPane rootPane;
    private Stage stage;

    WizardView() {
        this.createWindow();
    }

    public void setController(WizardController controller) {
        this.controller = controller;
    }

    private void createWindow() {
        ButtonBar buttonBar = new ButtonBar();
        this.buttonBack = new Button("Back");
        this.buttonBack.setOnAction(e -> this.controller.back());
        buttonBar.getButtons().add((Object)this.buttonBack);
        this.buttonNext = new Button("???");
        this.buttonNext.setOnAction(e -> this.controller.nextOrFinish());
        buttonBar.getButtons().add((Object)this.buttonNext);
        Button buttonCancel = new Button("Cancel");
        buttonBar.getButtons().add((Object)buttonCancel);
        this.rootPane = new BorderPane();
        this.rootPane.setCenter(null);
        this.rootPane.setBottom((Node)buttonBar);
        Scene scene = new Scene((Parent)this.rootPane, 1200.0, 600.0);
        scene.getStylesheets().add((Object)"gui/main.css");
        this.stage = new Stage();
        this.stage.setMinWidth(1200.0);
        this.stage.setMinHeight(600.0);
        buttonCancel.setOnAction(e -> this.stage.close());
        this.stage.setTitle("LIMES - New Configuration");
        this.stage.setScene(scene);
        this.stage.show();
    }

    public void setEditView(IEditView editView, boolean canGoBack, boolean canGoNext) {
        this.buttonBack.setDisable(!canGoBack);
        this.buttonNext.setText(canGoNext ? "Next" : "Finish");
        this.rootPane.setCenter((Node)editView.getPane());
    }

    public void close() {
        this.stage.close();
    }

    public Stage getStage() {
        return this.stage;
    }

    public void setToRootPane(Parent pane) {
        this.rootPane.setCenter((Node)pane);
    }
}

