/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.model.ml;

import java.util.List;
import javafx.concurrent.Task;
import org.aksw.limes.core.gui.model.Config;
import org.aksw.limes.core.gui.model.ml.MachineLearningModel;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.ml.algorithm.MLResults;

public class ActiveLearningModel
extends MachineLearningModel {
    private AMapping nextExamples = MappingFactory.createDefaultMapping();
    public static final int nextExamplesNum = 10;

    public ActiveLearningModel(Config config, ACache sourceCache, ACache targetCache) {
        super(config, sourceCache, targetCache);
    }

    @Override
    public Task<Void> createLearningTask() {
        return new Task<Void>(){

            protected Void call() {
                MLResults model = null;
                List learningParameters = ActiveLearningModel.this.mlalgorithm.getParameters();
                try {
                    ActiveLearningModel.this.mlalgorithm.init(learningParameters, ActiveLearningModel.this.sourceCache, ActiveLearningModel.this.targetCache);
                    model = ActiveLearningModel.this.mlalgorithm.asActive().activeLearn();
                    ActiveLearningModel.this.nextExamples = ActiveLearningModel.this.mlalgorithm.asActive().getNextExamples(10);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ActiveLearningModel.this.setLearnedMapping(ActiveLearningModel.this.mlalgorithm.predict(ActiveLearningModel.this.sourceCache, ActiveLearningModel.this.targetCache, model));
                ActiveLearningModel.this.learnedLS = model.getLinkSpecification();
                return null;
            }
        };
    }

    public AMapping getNextExamples() {
        return this.nextExamples;
    }

    public void setNextExamples(AMapping nextExamples) {
        this.nextExamples = nextExamples;
    }
}

