/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.controller;

import org.aksw.limes.core.gui.controller.IEditController;
import org.aksw.limes.core.gui.view.WizardView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WizardController {
    private final Runnable finishCallback;
    private final Runnable cancelCallback;
    private final WizardView view;
    private final IEditController[] editControllers;
    private int currentPage = -1;
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public WizardController(Runnable finishCallback, Runnable cancelCallback, WizardView view, IEditController ... editControllers) {
        this.finishCallback = finishCallback;
        this.cancelCallback = cancelCallback;
        view.setController(this);
        this.view = view;
        assert (editControllers.length != 0);
        this.editControllers = editControllers;
        this.setPage(0);
    }

    private void setPage(int newPage) {
        if (newPage < 0 || newPage > this.editControllers.length) {
            return;
        }
        if (this.currentPage != -1 && newPage > this.currentPage) {
            if (this.editControllers[this.currentPage].validate()) {
                this.editControllers[this.currentPage].save();
            } else {
                return;
            }
        }
        if (newPage == this.editControllers.length) {
            this.currentPage = -1;
            this.view.close();
            this.finish();
        } else {
            this.currentPage = newPage;
            IEditController editController = this.editControllers[newPage];
            editController.load();
            if (this.editControllers[this.currentPage].getTaskProgressView() != null) {
                this.editControllers[this.currentPage].getTaskProgressView().getFinishedSuccessfully().addListener((observable, oldValue, newValue) -> {
                    if (newValue.booleanValue()) {
                        this.view.setEditView(editController.getView(), newPage != 0, newPage < this.editControllers.length - 1);
                        this.editControllers[this.currentPage].setTaskProgressView(null);
                    }
                });
                this.editControllers[this.currentPage].getTaskProgressView().getCancelled().addListener((observable, oldValue, newValue) -> {
                    if (newValue.booleanValue()) {
                        --this.currentPage;
                        this.editControllers[this.currentPage].setTaskProgressView(null);
                    }
                });
            } else {
                this.view.setEditView(editController.getView(), newPage != 0, newPage < this.editControllers.length - 1);
            }
        }
    }

    public void back() {
        this.setPage(this.currentPage - 1);
    }

    public void nextOrFinish() {
        this.setPage(this.currentPage + 1);
    }

    private void finish() {
        this.finishCallback.run();
    }

    public void cancel() {
        this.cancelCallback.run();
    }
}

