/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.view.ml;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Spinner;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.CheckBoxListCell;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import org.aksw.limes.core.evaluation.qualititativeMeasures.Accuracy;
import org.aksw.limes.core.evaluation.qualititativeMeasures.FMeasure;
import org.aksw.limes.core.evaluation.qualititativeMeasures.Precision;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoFMeasure;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoPrecision;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoRecall;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoRefFMeasure;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoRefPrecision;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoRefRecall;
import org.aksw.limes.core.evaluation.qualititativeMeasures.Recall;
import org.aksw.limes.core.gui.controller.ml.MachineLearningController;
import org.aksw.limes.core.gui.util.EQualitativeMeasure;
import org.aksw.limes.core.gui.view.MainView;
import org.aksw.limes.core.gui.view.ml.MLPropertyMatchingView;
import org.aksw.limes.core.io.config.Configuration;
import org.aksw.limes.core.measures.measure.MeasureType;
import org.aksw.limes.core.ml.algorithm.AMLAlgorithm;
import org.aksw.limes.core.ml.algorithm.LearningParameter;
import org.aksw.limes.core.ml.algorithm.MLAlgorithmFactory;
import org.aksw.limes.core.ml.algorithm.MLImplementationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MachineLearningView {
    protected static Logger logger = LoggerFactory.getLogger((String)"LIMES");
    private static final String[] algorithms = new String[]{"euclid linear", "euclid boolean", "euclid mesh", "eagle", "wombat complete", "wombat simple", "dragon"};
    protected MachineLearningController mlController;
    private final MainView mainView;
    private Button learnButton;
    private final MLImplementationType type;

    public MachineLearningView(MainView mainView, MachineLearningController mlController, MLImplementationType type) {
        this.mainView = mainView;
        this.mlController = mlController;
        this.mlController.setMlView(this);
        this.type = type;
        this.createMLAlgorithmsRootPane();
    }

    public void createMLAlgorithmsRootPane() {
        BorderPane border = new BorderPane();
        HBox content = new HBox();
        GridPane root = new GridPane();
        ObservableList mloptions = FXCollections.observableArrayList();
        for (int i = 0; i < algorithms.length; ++i) {
            AMLAlgorithm algorithm2;
            if (this.type == MLImplementationType.SUPERVISED_ACTIVE) {
                try {
                    algorithm2 = MLAlgorithmFactory.createMLAlgorithm((Class)MLAlgorithmFactory.getAlgorithmType((String)algorithms[i]), (MLImplementationType)MLAlgorithmFactory.getImplementationType((String)"supervised active"));
                    mloptions.add((Object)algorithm2.getName());
                }
                catch (Exception algorithm2) {}
                continue;
            }
            if (this.type == MLImplementationType.SUPERVISED_BATCH) {
                try {
                    algorithm2 = MLAlgorithmFactory.createMLAlgorithm((Class)MLAlgorithmFactory.getAlgorithmType((String)algorithms[i]), (MLImplementationType)MLAlgorithmFactory.getImplementationType((String)"supervised batch"));
                    mloptions.add((Object)algorithm2.getName());
                }
                catch (Exception algorithm3) {}
                continue;
            }
            if (this.type == MLImplementationType.UNSUPERVISED) {
                try {
                    algorithm2 = MLAlgorithmFactory.createMLAlgorithm((Class)MLAlgorithmFactory.getAlgorithmType((String)algorithms[i]), (MLImplementationType)MLAlgorithmFactory.getImplementationType((String)"unsupervised"));
                    mloptions.add((Object)algorithm2.getName());
                }
                catch (Exception algorithm4) {}
                continue;
            }
            logger.info("Unknown subclass of MachineLearningView");
        }
        Collections.sort(mloptions);
        ComboBox mlOptionsChooser = new ComboBox(mloptions);
        mlOptionsChooser.setPromptText("choose algorithm");
        this.learnButton = new Button("learn");
        this.learnButton.setTooltip(new Tooltip("start learning"));
        this.learnButton.setDisable(true);
        HBox buttonWrapper = new HBox();
        buttonWrapper.setAlignment(Pos.BASELINE_RIGHT);
        buttonWrapper.setPadding(new Insets(25.0, 25.0, 25.0, 25.0));
        buttonWrapper.getChildren().addAll((Object[])new Node[]{this.learnButton});
        content.getChildren().add((Object)mlOptionsChooser);
        border.setTop((Node)content);
        border.setBottom((Node)buttonWrapper);
        Scene scene = new Scene((Parent)border, 600.0, 600.0);
        scene.getStylesheets().add((Object)"gui/main.css");
        mlOptionsChooser.setOnAction(e -> {
            root.getChildren().removeAll((Collection)root.getChildren());
            this.mlController.setMLAlgorithmToModel((String)mlOptionsChooser.getValue());
            this.mlController.getMlModel().getMlalgorithm().getMl().setConfiguration((Configuration)this.mlController.getMlModel().getConfig());
            this.mlController.getMlModel().getMlalgorithm().getMl().setDefaultParameters();
            this.showParameters(root, (String)mlOptionsChooser.getValue());
            border.setCenter((Node)root);
            this.learnButton.setDisable(false);
        });
        this.learnButton.setOnAction(e -> {
            this.learnButton.setDisable(true);
            this.mlController.learn(this);
        });
        Stage stage = new Stage();
        stage.setMinHeight(scene.getHeight());
        stage.setMinWidth(scene.getWidth());
        stage.setTitle("LIMES - Machine Learning");
        stage.setScene(scene);
        stage.show();
    }

    private GridPane showParameters(GridPane root, String algorithm) {
        AMLAlgorithm mlalgorithm = this.mlController.getMlModel().getMlalgorithm();
        List params = mlalgorithm.getParameters();
        block22: for (int i = 0; i < params.size(); ++i) {
            switch (((LearningParameter)params.get(i)).getClazz().getSimpleName().toString().toLowerCase().trim()) {
                case "integer": {
                    this.addNumberParameterHBox((LearningParameter)params.get(i), root, i);
                    continue block22;
                }
                case "long": {
                    this.addNumberParameterHBox((LearningParameter)params.get(i), root, i);
                    continue block22;
                }
                case "double": {
                    this.addNumberParameterHBox((LearningParameter)params.get(i), root, i);
                    continue block22;
                }
                case "float": {
                    this.addNumberParameterHBox((LearningParameter)params.get(i), root, i);
                    continue block22;
                }
                case "boolean": {
                    this.addBooleanParameterHBox((LearningParameter)params.get(i), root, i);
                    continue block22;
                }
                case "measuretype": {
                    this.addMeasureTypeParameterHBox((LearningParameter)params.get(i), root, i);
                    continue block22;
                }
                case "propertymapping": {
                    this.handlePropertyMapping((LearningParameter)params.get(i));
                    continue block22;
                }
                case "iqualitativemeasure": {
                    this.addQualitativeMeasureParameterHBox((LearningParameter)params.get(i), root, i);
                    continue block22;
                }
                case "amapping": {
                    continue block22;
                }
                default: {
                    if (((LearningParameter)params.get(i)).getClazz().isEnum()) {
                        this.addEnumParameterHBox((LearningParameter)params.get(i), root, i);
                        continue block22;
                    }
                    this.addObjectParameterHBox((LearningParameter)params.get(i), root, i);
                }
            }
        }
        root.setHgap(10.0);
        root.setVgap(10.0);
        root.setPadding(new Insets(25.0, 25.0, 25.0, 25.0));
        return root;
    }

    private void addNumberParameterHBox(LearningParameter param, GridPane root, int position) {
        String type = param.getClazz().getSimpleName().toString().toLowerCase().trim();
        Label parameterText = new Label(param.getName());
        Spinner parameterSpinner = null;
        int intStep = 1;
        double doubleStep = 0.01;
        if (!Double.isNaN(param.getRangeStep())) {
            intStep = (int)param.getRangeStep();
            doubleStep = param.getRangeStep();
        }
        switch (type) {
            case "integer": {
                parameterSpinner = new Spinner((int)param.getRangeStart(), (int)param.getRangeEnd(), ((Integer)param.getValue()).intValue(), intStep);
                break;
            }
            case "double": {
                parameterSpinner = new Spinner(param.getRangeStart(), param.getRangeEnd(), ((Double)param.getValue()).doubleValue(), doubleStep);
                break;
            }
            case "float": {
                parameterSpinner = new Spinner(Double.valueOf(param.getRangeStart()).doubleValue(), Double.valueOf(param.getRangeEnd()).doubleValue(), Double.valueOf(param.getValue().toString()).doubleValue(), doubleStep);
                break;
            }
            default: {
                int rangeEnd = param.getRangeEnd() < 2.147483647E9 ? (int)param.getRangeEnd() : Integer.MAX_VALUE;
                parameterSpinner = new Spinner((int)param.getRangeStart(), rangeEnd, Integer.valueOf(param.getValue().toString()).intValue(), intStep);
            }
        }
        parameterSpinner.setEditable(true);
        root.add((Node)parameterText, 0, position);
        root.add((Node)parameterSpinner, 1, position);
    }

    private void addBooleanParameterHBox(LearningParameter param, GridPane root, int position) {
        Label parameterLabel = new Label(param.getName());
        CheckBox parameterCheckBox = new CheckBox();
        parameterCheckBox.setTooltip(new Tooltip(param.getDescription()));
        parameterCheckBox.setSelected(false);
        parameterCheckBox.selectedProperty().addListener((ov, old_val, new_val) -> param.setValue(new_val));
        root.add((Node)parameterLabel, 0, position);
        root.add((Node)parameterCheckBox, 1, position);
    }

    private void handlePropertyMapping(LearningParameter param) {
        if (this.mlController.getMlModel().getConfig().propertyMapping != null) {
            param.setValue((Object)this.mlController.getMlModel().getConfig().propertyMapping);
        } else {
            new MLPropertyMatchingView(this.mlController.getMlModel().getConfig(), param, this.mainView.toolBox);
        }
    }

    private void addMeasureTypeParameterHBox(LearningParameter param, GridPane root, int position) {
        Label parameterLabel = new Label(param.getName());
        ListView parameterListView = new ListView();
        EnumTypeItem.setParams((Set)param.getValue());
        for (int i = 0; i < MeasureType.values().length; ++i) {
            String measure = MeasureType.values()[i].toString().toLowerCase();
            EnumTypeItem item2 = null;
            item2 = ((Set)param.getValue()).contains(measure) ? new EnumTypeItem(measure, true) : new EnumTypeItem(measure, false);
            parameterListView.getItems().add((Object)item2);
        }
        parameterListView.setCellFactory(CheckBoxListCell.forListView(item -> ((EnumTypeItem)item).onProperty()));
        parameterListView.setOnMouseClicked(event -> ((EnumTypeItem)parameterListView.getSelectionModel().getSelectedItem()).setOn(!((EnumTypeItem)parameterListView.getSelectionModel().getSelectedItem()).isOn()));
        root.add((Node)parameterLabel, 0, position);
        root.add((Node)parameterListView, 1, position);
    }

    private void addEnumParameterHBox(LearningParameter param, GridPane root, int position) {
        Label parameterLabel = new Label(param.getName());
        ChoiceBox cb = new ChoiceBox();
        cb.setItems(FXCollections.observableArrayList(this.getEnumArrayList(param.getClazz())));
        cb.setValue(param.getValue());
        cb.getSelectionModel().selectedItemProperty().addListener((ov, value, new_value) -> param.setValue(new_value));
        root.add((Node)parameterLabel, 0, position);
        root.add((Node)cb, 1, position);
    }

    private void addObjectParameterHBox(LearningParameter param, GridPane root, int position) {
        Label parameterLabel = new Label(param.getName());
        ChoiceBox cb = new ChoiceBox();
        if (param.getInstanceOptions() == null) {
            logger.error("Wrongly implemented learning parameter " + param.getName() + "!\n Please provide instanceOptions!");
            return;
        }
        cb.setItems((ObservableList)FXCollections.observableArrayList((Object[])param.getInstanceOptions()).sorted());
        cb.setValue(param.getValue());
        cb.getSelectionModel().selectedItemProperty().addListener((ov, value, new_value) -> param.setValue(new_value));
        root.add((Node)parameterLabel, 0, position);
        root.add((Node)cb, 1, position);
    }

    private void addQualitativeMeasureParameterHBox(LearningParameter param, GridPane root, int position) {
        Label parameterLabel = new Label(param.getName());
        ChoiceBox cb = new ChoiceBox();
        cb.setItems(FXCollections.observableArrayList(this.getEnumArrayList(EQualitativeMeasure.class)));
        try {
            cb.setValue((Object)EQualitativeMeasure.valueOf(param.getValue().toString().substring(param.getValue().toString().lastIndexOf(".") + 1, param.getValue().toString().lastIndexOf("@"))));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        cb.getSelectionModel().selectedItemProperty().addListener((ov, value, new_value) -> {
            switch (new_value.toString().toLowerCase().trim()) {
                case "accuracy": {
                    param.setValue((Object)new Accuracy());
                    break;
                }
                case "pseudofmeasure": {
                    param.setValue((Object)new PseudoFMeasure());
                    break;
                }
                case "pseudorefmeasure": {
                    param.setValue((Object)new PseudoRefFMeasure());
                    break;
                }
                case "pseudoprecision": {
                    param.setValue((Object)new PseudoPrecision());
                    break;
                }
                case "pseudorefprecision": {
                    param.setValue((Object)new PseudoRefPrecision());
                    break;
                }
                case "pseudorecall": {
                    param.setValue((Object)new PseudoRecall());
                    break;
                }
                case "pseudorefrecall": {
                    param.setValue((Object)new PseudoRefRecall());
                    break;
                }
                case "fmeasure": {
                    param.setValue((Object)new FMeasure());
                    break;
                }
                case "precision": {
                    param.setValue((Object)new Precision());
                    break;
                }
                case "recall": {
                    param.setValue((Object)new Recall());
                    break;
                }
                default: {
                    logger.error("This IQualitativeMeasure does not exist!");
                }
            }
        });
        root.add((Node)parameterLabel, 0, position);
        root.add((Node)cb, 1, position);
    }

    private <E extends Enum<E>> ObservableList<E> getEnumArrayList(Class<E> elemType) {
        ObservableList list = FXCollections.observableArrayList();
        for (Enum e : EnumSet.allOf(elemType)) {
            list.add((Object)e);
        }
        return list;
    }

    public void showErrorDialog(String header, String content) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setHeaderText(header);
        alert.setContentText(content);
        alert.showAndWait();
    }

    public Button getLearnButton() {
        return this.learnButton;
    }

    public MainView getMainView() {
        return this.mainView;
    }

    private static class EnumTypeItem {
        private final StringProperty name = new SimpleStringProperty();
        private final BooleanProperty on = new SimpleBooleanProperty();
        private static Set<String> params;

        private EnumTypeItem(String name, boolean on) {
            this.setName(name);
            this.setOn(on);
            this.on.addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    params.add(name);
                } else {
                    params.remove(name);
                }
            });
        }

        private static final void setParams(Set<String> p) {
            params = p;
        }

        private final StringProperty nameProperty() {
            return this.name;
        }

        private final String getName() {
            return (String)this.nameProperty().get();
        }

        private final void setName(String name) {
            this.nameProperty().set((Object)name);
        }

        private final BooleanProperty onProperty() {
            return this.on;
        }

        private final boolean isOn() {
            return this.onProperty().get();
        }

        private final void setOn(boolean on) {
            this.onProperty().set(on);
        }

        public String toString() {
            return this.getName();
        }
    }
}

