/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.view.ml;

import java.io.File;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.aksw.limes.core.gui.model.ml.BatchLearningModel;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.reader.CSVMappingReader;
import org.aksw.limes.core.io.mapping.reader.RDFMappingReader;

public class BatchLearningInputView {
    private Stage stage;
    private ScrollPane rootPane;
    private static final String filePathFieldError = "File not found!";
    private final BatchLearningModel blm;
    private AMapping trainingMapping;
    public BooleanProperty finished = new SimpleBooleanProperty(false);

    public BatchLearningInputView(BatchLearningModel blm) {
        this.blm = blm;
        this.createRootPane();
    }

    private void createRootPane() {
        HBox fileHBox = new HBox();
        TextField filePathField = new TextField("");
        filePathField.setId("filePathField");
        Tooltip tip = new Tooltip();
        tip.setText("Provide a file with a training mapping");
        filePathField.setTooltip(tip);
        filePathField.focusedProperty().addListener((arg0, oldValue, newValue) -> {
            File f;
            if (!(filePathField.getText() == null || filePathField.getText().equals("") || newValue.booleanValue() || (f = new File(filePathField.getText())).exists() && !f.isDirectory())) {
                filePathField.setText(filePathFieldError);
                filePathField.setStyle("-fx-text-inner-color: red;");
            }
        });
        filePathField.setOnMouseClicked(e -> {
            if (filePathField.getText() != null && !filePathField.getText().equals("") && filePathField.getText().equals(filePathFieldError)) {
                filePathField.setStyle("");
                filePathField.setText("");
            }
        });
        Button fileEndpointButton = new Button();
        Image fileButtonImage = new Image(this.getClass().getResourceAsStream("/gui/file.png"), 20.0, 20.0, true, false);
        fileEndpointButton.setGraphic((Node)new ImageView(fileButtonImage));
        fileEndpointButton.setOnAction(e -> {
            FileChooser fileChooser = new FileChooser();
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Mapping File (*.csv , *.rdf, *.ttl, *.n3, *.nt)", new String[]{"*.xml", "*.rdf", "*.ttl", "*.n3", "*.nt", "*.csv"});
            fileChooser.getExtensionFilters().add((Object)extFilter);
            File file = fileChooser.showOpenDialog((Window)this.stage);
            if (file != null) {
                filePathField.setText(file.getAbsolutePath());
            }
        });
        fileHBox.getChildren().addAll((Object[])new Node[]{filePathField, fileEndpointButton});
        HBox buttons = new HBox();
        Button save = new Button("Save");
        Button cancel = new Button("Cancel");
        save.setOnAction(e_ -> {
            if (filePathField.getText() != null && !filePathField.getText().equals("")) {
                CSVMappingReader reader = null;
                if (filePathField.getText().endsWith("csv")) {
                    reader = new CSVMappingReader(filePathField.getText());
                    this.trainingMapping = reader.read();
                    this.blm.setTrainingMapping(this.trainingMapping);
                } else if (filePathField.getText().endsWith("rdf") || filePathField.getText().endsWith("ttl") || filePathField.getText().endsWith("nt") || filePathField.getText().endsWith("n3")) {
                    reader = new RDFMappingReader(filePathField.getText());
                    this.trainingMapping = reader.read();
                    this.blm.setTrainingMapping(this.trainingMapping);
                } else {
                    Alert alert = new Alert(Alert.AlertType.INFORMATION);
                    alert.setContentText("Unknown Mapping filetype!");
                    alert.showAndWait();
                }
            }
            this.finished.set(true);
            this.stage.close();
        });
        cancel.setOnAction(e -> this.stage.close());
        buttons.getChildren().addAll((Object[])new Node[]{save, cancel});
        HBox.setHgrow((Node)fileHBox, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)buttons, (Priority)Priority.ALWAYS);
        BorderPane root = new BorderPane();
        root.setTop((Node)fileHBox);
        root.setBottom((Node)buttons);
        this.rootPane = new ScrollPane((Node)root);
        Scene scene = new Scene((Parent)this.rootPane, 300.0, 400.0);
        scene.getStylesheets().add((Object)"gui/main.css");
        this.stage = new Stage();
        this.stage.setTitle("LIMES - Get training mapping");
        this.stage.setScene(scene);
        this.stage.show();
    }
}

