/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.view.ml;

import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.aksw.limes.core.gui.controller.MainController;
import org.aksw.limes.core.gui.controller.ml.ActiveLearningResultController;
import org.aksw.limes.core.gui.model.ActiveLearningResult;
import org.aksw.limes.core.gui.model.Config;
import org.aksw.limes.core.gui.model.InstanceProperty;
import org.aksw.limes.core.gui.model.Result;
import org.aksw.limes.core.gui.model.ml.ActiveLearningModel;
import org.aksw.limes.core.gui.view.ResultView;

public class ActiveLearningResultView {
    private TableView<ActiveLearningResult> table;
    private ActiveLearningResultController controller;
    private TableView<InstanceProperty> sourceInstanceTable;
    private TableView<InstanceProperty> targetInstanceTable;
    private Config config;
    private final Button learnButton = new Button("Learn");
    private final Button getResultsButton = new Button("Get Results");
    private ActiveLearningModel model;
    public ProgressIndicator learnProgress;

    public ActiveLearningResultView(Config c, ActiveLearningModel m, MainController mainController) {
        this.model = m;
        this.config = c;
        this.controller = new ActiveLearningResultController(this, this.config, this.model);
        Stage stage = new Stage();
        VBox root = new VBox();
        HBox resultProperties = new HBox();
        this.sourceInstanceTable = new TableView();
        TableColumn sourceInstancePropertyColumn = new TableColumn("Property");
        sourceInstancePropertyColumn.setCellValueFactory((Callback)new PropertyValueFactory("property"));
        this.sourceInstanceTable.getColumns().add((Object)sourceInstancePropertyColumn);
        TableColumn sourceInstanceValueColumn = new TableColumn("Value");
        sourceInstanceValueColumn.setCellValueFactory((Callback)new PropertyValueFactory("value"));
        this.sourceInstanceTable.getColumns().add((Object)sourceInstanceValueColumn);
        resultProperties.getChildren().add(this.sourceInstanceTable);
        sourceInstancePropertyColumn.prefWidthProperty().bind((ObservableValue)this.sourceInstanceTable.widthProperty().divide(2));
        sourceInstanceValueColumn.prefWidthProperty().bind((ObservableValue)this.sourceInstanceTable.widthProperty().divide(2));
        this.targetInstanceTable = new TableView();
        TableColumn targetInstancePropertyColumn = new TableColumn("Property");
        targetInstancePropertyColumn.setCellValueFactory((Callback)new PropertyValueFactory("property"));
        this.targetInstanceTable.getColumns().add((Object)targetInstancePropertyColumn);
        TableColumn targetInstanceValueColumn = new TableColumn("Value");
        targetInstanceValueColumn.setCellValueFactory((Callback)new PropertyValueFactory("value"));
        this.targetInstanceTable.getColumns().add((Object)targetInstanceValueColumn);
        resultProperties.getChildren().add(this.targetInstanceTable);
        targetInstancePropertyColumn.prefWidthProperty().bind((ObservableValue)this.targetInstanceTable.widthProperty().divide(2));
        targetInstanceValueColumn.prefWidthProperty().bind((ObservableValue)this.targetInstanceTable.widthProperty().divide(2));
        this.table = new TableView();
        TableColumn columnSource = new TableColumn("Source URI");
        columnSource.setCellValueFactory((Callback)new PropertyValueFactory("sourceURI"));
        this.table.getColumns().add((Object)columnSource);
        TableColumn columnTarget = new TableColumn("Target URI");
        columnTarget.setCellValueFactory((Callback)new PropertyValueFactory("targetURI"));
        this.table.getColumns().add((Object)columnTarget);
        TableColumn columnValue = new TableColumn("value");
        columnValue.setCellValueFactory((Callback)new PropertyValueFactory("value"));
        this.table.getColumns().add((Object)columnValue);
        TableColumn columnIsMatch = new TableColumn("Match?");
        columnIsMatch.setCellValueFactory((Callback)new PropertyValueFactory("isMatch"));
        columnIsMatch.setCellFactory(p -> new CheckBoxTableCell());
        columnIsMatch.setEditable(true);
        this.table.setEditable(true);
        this.table.getColumns().add((Object)columnIsMatch);
        this.table.setOnMouseClicked(e -> this.controller.showProperties((ActiveLearningResult)this.table.getSelectionModel().getSelectedItem()));
        columnSource.prefWidthProperty().bind((ObservableValue)this.table.widthProperty().divide(40).multiply(15));
        columnTarget.prefWidthProperty().bind((ObservableValue)this.table.widthProperty().divide(40).multiply(15));
        columnValue.prefWidthProperty().bind((ObservableValue)this.table.widthProperty().divide(9));
        columnIsMatch.prefWidthProperty().bind((ObservableValue)this.table.widthProperty().divide(9));
        root.getChildren().add((Object)resultProperties);
        root.getChildren().add(this.table);
        root.widthProperty().addListener((arg0, arg1, arg2) -> {
            this.sourceInstanceTable.setMinWidth(arg2.doubleValue() / 2.0);
            this.sourceInstanceTable.setMaxWidth(arg2.doubleValue() / 2.0);
            this.sourceInstanceTable.setPrefWidth(arg2.doubleValue() / 2.0);
            this.targetInstanceTable.setMinWidth(arg2.doubleValue() / 2.0);
            this.targetInstanceTable.setMaxWidth(arg2.doubleValue() / 2.0);
            this.targetInstanceTable.setPrefWidth(arg2.doubleValue() / 2.0);
        });
        this.learnProgress = new ProgressIndicator();
        this.learnProgress.setVisible(false);
        this.learnButton.setOnAction(e -> this.controller.learnButtonPressed());
        this.learnButton.setTooltip(new Tooltip("start learning"));
        this.getResultsButton.setTooltip(new Tooltip("compute results"));
        HBox buttonBox = new HBox();
        buttonBox.getChildren().addAll((Object[])new Node[]{this.learnButton, this.getResultsButton, this.learnProgress});
        buttonBox.setSpacing(10.0);
        root.setSpacing(10.0);
        root.getChildren().add((Object)buttonBox);
        Scene scene = new Scene((Parent)root, 1000.0, 600.0);
        scene.getStylesheets().add((Object)"gui/main.css");
        this.sourceInstanceTable.setPrefWidth(scene.getWidth() / 2.0);
        this.targetInstanceTable.setPrefWidth(scene.getWidth() / 2.0);
        this.getResultsButton.setOnAction(e -> {
            stage.close();
            ResultView resultView = new ResultView(this.config, this.model.getLearnedLS(), mainController);
            ObservableList resultList = FXCollections.observableArrayList();
            this.model.getLearnedMapping().getMap().forEach((sourceURI, map2) -> map2.forEach((targetURI, value) -> resultList.add((Object)new Result((String)sourceURI, (String)targetURI, (Double)value))));
            resultView.showResults((ObservableList<Result>)resultList, this.model.getLearnedMapping());
        });
        stage.setTitle("LIMES");
        stage.setMinHeight(scene.getHeight());
        stage.setMinWidth(scene.getWidth());
        stage.setScene(scene);
        stage.show();
    }

    public void showResults(ObservableList<ActiveLearningResult> results) {
        this.table.setItems(results);
    }

    public void showSourceInstance(ObservableList<InstanceProperty> instanceProperty) {
        this.sourceInstanceTable.setItems(instanceProperty);
    }

    public void showTargetInstance(ObservableList<InstanceProperty> instanceProperty) {
        this.targetInstanceTable.setItems(instanceProperty);
    }

    public ActiveLearningResultController getActiveLearningResultController() {
        return this.controller;
    }

    public TableView<ActiveLearningResult> getMatchingTable() {
        return this.table;
    }
}

