/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.view.graphBuilder;

import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.text.Text;
import org.aksw.limes.core.gui.model.metric.Node;
import org.aksw.limes.core.gui.model.metric.Property;
import org.aksw.limes.core.gui.view.graphBuilder.NodeView;

public class NodeViewRectangle {
    public static final Color targetCol = Color.rgb((int)23, (int)104, (int)19);
    public static final Color targetOptionalCol = Color.rgb((int)23, (int)104, (int)19, (double)0.6);
    public static final Color sourceCol = Color.rgb((int)128, (int)23, (int)26);
    public static final Color sourceOptionalCol = Color.rgb((int)128, (int)23, (int)26, (double)0.6);
    public static final Color metricCol = Color.rgb((int)129, (int)70, (int)23);
    public static final Color operatorCol = Color.rgb((int)14, (int)78, (int)76);
    public static final Color outputCol = Color.rgb((int)1, (int)30, (int)0);
    public static final Color targetHeadTextCol = Color.rgb((int)236, (int)237, (int)236);
    public static final Color sourceHeadTextCol = Color.rgb((int)254, (int)242, (int)242);
    public static final Color metricHeadTextCol = Color.rgb((int)217, (int)218, (int)218);
    public static final Color operatorHeadtextCol = Color.rgb((int)255, (int)254, (int)253);
    public static final Color outputHeadTextCol = Color.rgb((int)243, (int)243, (int)243);
    public static double arch = 50.0;
    private final NodeView node;
    private final double x;
    private final double y;
    private Color color;
    private Color HeadTextCol;
    private Node nodeData;

    public NodeViewRectangle(double x, double y, int nodeShape, NodeView node, Node nodeData) {
        this.x = x;
        this.y = y;
        this.nodeData = nodeData;
        switch (nodeShape) {
            case 1: {
                this.color = metricCol;
                this.HeadTextCol = metricHeadTextCol;
                break;
            }
            case 2: {
                this.color = outputCol;
                this.HeadTextCol = outputHeadTextCol;
                break;
            }
            case 3: {
                this.color = operatorCol;
                this.HeadTextCol = operatorHeadtextCol;
                break;
            }
            case 4: {
                this.HeadTextCol = sourceHeadTextCol;
                if (((Property)nodeData).isOptional()) {
                    this.color = sourceOptionalCol;
                    break;
                }
                this.color = sourceCol;
                break;
            }
            case 5: {
                this.HeadTextCol = targetHeadTextCol;
                this.color = ((Property)nodeData).isOptional() ? targetOptionalCol : targetCol;
            }
        }
        this.node = node;
        this.nodeData = nodeData;
    }

    public void drawNodeViewRectangle(GraphicsContext gc) {
        if (this.color != metricCol) {
            gc.setFill((Paint)Color.rgb((int)243, (int)243, (int)243));
            gc.setStroke((Paint)this.color);
            gc.strokeRoundRect(this.x, this.y, (double)this.node.getWidth(), (double)this.node.getHeight(), arch, arch);
            gc.fillRoundRect(this.x, this.y, (double)this.node.getWidth(), (double)this.node.getHeight(), arch, arch);
            gc.setFill((Paint)this.color);
            gc.fillArc(this.x, this.y, arch, arch, 90.0, 90.0, ArcType.ROUND);
            gc.fillArc(this.x + (double)this.node.getWidth() - arch, this.y, arch, arch, 0.0, 90.0, ArcType.ROUND);
            gc.fillRect(this.x + arch / 2.0, this.y, (double)this.node.getWidth() - arch, arch / 2.0);
        } else {
            gc.setFill((Paint)this.color);
            gc.fillRoundRect(this.x, this.y, (double)this.node.getWidth(), (double)this.node.getHeight(), arch, arch);
        }
        if (this.color != sourceCol && this.color != sourceOptionalCol && this.color != targetCol && this.color != targetOptionalCol) {
            gc.setFill((Paint)this.HeadTextCol);
            this.fillText(gc, this.nodeData.id, this.node.getWidth(), 0.0, arch / 4.0, false);
            if (this.color == outputCol) {
                gc.setFill((Paint)operatorCol);
                this.fillText(gc, "Acceptance threshold: ", this.nodeData.param1, this.node.getWidth(), 4.0, arch * 0.75, true);
                this.fillText(gc, "Verification threshold: ", this.nodeData.param2, this.node.getWidth(), 4.0, arch * 1.25, true);
            } else if (this.color == operatorCol) {
                gc.setFill((Paint)operatorCol);
                if (this.nodeData.getChilds().isEmpty()) {
                    this.fillText(gc, "parent1 threshold: ", this.nodeData.param1, this.node.getWidth(), 4.0, arch * 0.75, true);
                    this.fillText(gc, "parent2 threshold: ", this.nodeData.param2, this.node.getWidth(), 4.0, arch * 1.25, true);
                } else if (this.nodeData.getChilds().size() == 1) {
                    this.fillText(gc, this.nodeData.getChilds().get((int)0).id + " threshold: ", this.nodeData.param1, this.node.getWidth(), 4.0, arch * 0.75, true);
                    this.fillText(gc, "parent2 threshold: ", this.nodeData.param2, this.node.getWidth(), 4.0, arch * 1.25, true);
                } else {
                    this.fillText(gc, this.nodeData.getChilds().get((int)0).id + " threshold: ", this.nodeData.param1, this.node.getWidth(), 4.0, arch * 0.75, true);
                    this.fillText(gc, this.nodeData.getChilds().get((int)1).id + " threshold: ", this.nodeData.param2, this.node.getWidth(), 4.0, arch * 1.25, true);
                }
            }
        } else if (this.color == sourceCol || this.color == sourceOptionalCol) {
            gc.setFill((Paint)this.HeadTextCol);
            this.fillText(gc, "source", this.node.getWidth(), 0.0, arch / 4.0, false);
            gc.setFill((Paint)operatorCol);
            this.fillText(gc, this.nodeData.id, this.node.getWidth(), 4.0, arch * 0.75, true);
        } else if (this.color == targetCol || this.color == targetOptionalCol) {
            gc.setFill((Paint)this.HeadTextCol);
            this.fillText(gc, "target", this.node.getWidth(), 0.0, arch / 4.0, false);
            gc.setFill((Paint)operatorCol);
            this.fillText(gc, this.nodeData.id, this.node.getWidth(), 4.0, arch * 0.75, true);
        }
    }

    private void fillText(GraphicsContext gc, String text, int nodeWidth, double xoffset, double yoffset, boolean leftAligned) {
        this.fillText(gc, text, -1.0, nodeWidth, xoffset, yoffset, leftAligned);
    }

    private void fillText(GraphicsContext gc, String text, double thresholdValue, int nodeWidth, double xoffset, double yoffset, boolean leftAligned) {
        Text label = new Text(text);
        double labelWidth = label.getLayoutBounds().getWidth();
        if (labelWidth > 0.85 * (double)this.node.getWidth()) {
            double cutoff = 0.0;
            cutoff = leftAligned ? (100.0 / (double)(this.node.getWidth() - 20) * labelWidth - 100.0) / 100.0 : (100.0 / (double)(this.node.getWidth() - 30) * labelWidth - 100.0) / 100.0;
            label = thresholdValue == -1.0 ? new Text(text.substring(0, (int)((double)text.length() - Math.abs((double)text.length() * cutoff))) + "...") : new Text(text.substring(0, (int)((double)text.length() - Math.abs((double)text.length() * cutoff))) + "... : ");
        }
        if (!leftAligned) {
            xoffset += (double)this.calculateOffset(label, nodeWidth);
        }
        if (thresholdValue == -1.0) {
            gc.fillText(label.getText(), this.x + xoffset, this.y + yoffset);
        } else {
            gc.fillText(label.getText() + thresholdValue, this.x + xoffset, this.y + yoffset);
        }
    }

    private int calculateOffset(Text label, int width) {
        double labelWidth = label.getLayoutBounds().getWidth();
        return (int)((double)width / 2.0 - labelWidth / 2.0);
    }
}

