/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.view.graphBuilder;

import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import org.aksw.limes.core.gui.view.graphBuilder.GraphBuildView;
import org.aksw.limes.core.gui.view.graphBuilder.NodeView;

public class NodeContextMenu
extends ContextMenu {
    private final GraphBuildView graphBuildView;
    private final MenuItem close;
    private final MenuItem linkTo;
    private final MenuItem delete;
    private final NodeView node;

    public NodeContextMenu(GraphBuildView view, NodeView clickedNode) {
        this.graphBuildView = view;
        this.linkTo = new MenuItem("Link To");
        this.delete = new MenuItem("Delete");
        this.close = new MenuItem("Close");
        this.addListeners();
        this.getItems().addAll((Object[])new MenuItem[]{this.linkTo, this.delete, this.close});
        this.node = clickedNode;
        this.graphBuildView.contextMenuIsShown = true;
    }

    private void addListeners() {
        this.delete.setOnAction(e -> {
            this.graphBuildView.removeNodeView(this.node);
            this.graphBuildView.contextMenuIsShown = false;
        });
        this.linkTo.setOnAction(e -> {
            this.graphBuildView.isLinking = true;
            this.graphBuildView.linkNode = this.node;
            this.graphBuildView.contextMenuIsShown = false;
        });
        this.close.setOnAction(e -> {
            this.graphBuildView.contextMenuIsShown = false;
        });
    }
}

