/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.VBox;
import org.aksw.limes.core.gui.model.Config;
import org.aksw.limes.core.gui.model.metric.Measure;
import org.aksw.limes.core.gui.model.metric.Node;
import org.aksw.limes.core.gui.model.metric.Operator;
import org.aksw.limes.core.gui.model.metric.Property;
import org.aksw.limes.core.gui.util.SourceOrTarget;
import org.aksw.limes.core.gui.util.sparql.PrefixHelper;
import org.aksw.limes.core.gui.view.MainView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolBox
extends VBox {
    private static final Logger logger = LoggerFactory.getLogger(ToolBox.class);
    private ListView<PropertyItem> toolBoxSourceProperties;
    private ListView<PropertyItem> toolBoxTargetProperties;
    private ListView<String> toolBoxOperators;
    private ListView<String> toolBoxMetrics;
    private final Label sourcePropertiesLabel = new Label("source properties");
    private final Label targetPropertiesLabel = new Label("target properties");
    private Config config;
    private final MainView view;

    public ToolBox(MainView view) {
        this.generateView(this);
        this.setListeners();
        this.config = null;
        this.view = view;
    }

    private void generateView(VBox box) {
        this.toolBoxSourceProperties = new ListView();
        this.toolBoxSourceProperties.setId("toolBoxSourceProperties");
        this.toolBoxSourceProperties.setTooltip(new Tooltip("Add source properties to metric builder by clicking.\n Optional properties are grey. You can make properties optional by right-clicking on them"));
        this.toolBoxTargetProperties = new ListView();
        this.toolBoxTargetProperties.setId("toolBoxTargetProperties");
        this.toolBoxTargetProperties.setTooltip(new Tooltip("Add target properties to metric builder by clicking.\n Optional properties are grey. You can make properties optional by right-clicking on them"));
        this.toolBoxMetrics = this.generateListViewFromNodeIdentifiers(new Measure("").identifiers());
        this.toolBoxMetrics.setTooltip(new Tooltip("Add measures to metric builder by clicking"));
        this.toolBoxOperators = this.generateListViewFromNodeIdentifiers(Operator.identifiers);
        this.toolBoxOperators.setTooltip(new Tooltip("Add operators to metric builder by clicking"));
        box.getChildren().add((Object)this.sourcePropertiesLabel);
        box.getChildren().add(this.toolBoxSourceProperties);
        box.getChildren().add((Object)this.targetPropertiesLabel);
        box.getChildren().add(this.toolBoxTargetProperties);
        box.getChildren().add((Object)new Label("Measures"));
        box.getChildren().add(this.toolBoxMetrics);
        box.getChildren().add((Object)new Label("Operators"));
        box.getChildren().add(this.toolBoxOperators);
    }

    private void setListeners() {
        this.toolBoxSourceProperties.setOnMouseClicked(e -> {
            if (e.getButton().equals((Object)MouseButton.SECONDARY)) {
                this.switchPropertyOptional(this.toolBoxSourceProperties, 4);
            } else {
                this.generateProperty(this.toolBoxSourceProperties, 4);
            }
        });
        this.toolBoxTargetProperties.setOnMouseClicked(e -> {
            if (e.getButton().equals((Object)MouseButton.SECONDARY)) {
                this.switchPropertyOptional(this.toolBoxTargetProperties, 5);
            } else {
                this.generateProperty(this.toolBoxTargetProperties, 5);
            }
        });
        this.toolBoxMetrics.setOnMouseClicked(e -> this.generateNode(this.toolBoxMetrics, 1));
        this.toolBoxOperators.setOnMouseClicked(e -> this.generateNode(this.toolBoxOperators, 3));
    }

    private void switchPropertyOptional(ListView<PropertyItem> view, int shape) {
        if (view.getSelectionModel().getSelectedItem() != null) {
            if (shape == 4) {
                logger.debug("switch source");
                this.config.switchPropertyOptional(this.config.getPropertyString(((PropertyItem)view.getSelectionModel().getSelectedItem()).getName(), SourceOrTarget.SOURCE), SourceOrTarget.SOURCE);
            } else {
                logger.debug("switch target");
                this.config.switchPropertyOptional(this.config.getPropertyString(((PropertyItem)view.getSelectionModel().getSelectedItem()).getName(), SourceOrTarget.TARGET), SourceOrTarget.TARGET);
            }
            ((PropertyItem)view.getSelectionModel().getSelectedItem()).setOptional(!((PropertyItem)view.getSelectionModel().getSelectedItem()).isOptional());
            ObservableList listItems = view.getItems();
            view.setItems(null);
            view.setItems(listItems);
            this.view.getGraphBuild().draw();
        }
    }

    private void setListViewFromList(ListView<PropertyItem> view, List<PropertyItem> items) {
        ObservableList listItems = FXCollections.observableArrayList();
        items.forEach(item -> listItems.add(item));
        Platform.runLater(() -> {
            view.setItems(listItems);
            view.setCellFactory(list -> new ListCell<PropertyItem>(){

                protected void updateItem(PropertyItem item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    this.setText(empty ? null : item.getName());
                    if (!empty && item.isOptional()) {
                        this.setStyle("-fx-text-fill:grey;");
                    } else if (!empty && !item.isOptional()) {
                        this.setStyle("");
                    }
                }
            });
        });
    }

    private ListView<String> generateListViewFromNodeIdentifiers(Set<String> nodeIdentifiers) {
        ObservableList listItems = FXCollections.observableArrayList();
        nodeIdentifiers.forEach(identifier -> listItems.add(identifier));
        Collections.sort(listItems);
        return new ListView(listItems);
    }

    private void generateProperty(ListView<PropertyItem> view, int shape) {
        if (view.getSelectionModel().getSelectedItem() != null) {
            Property gen = null;
            if (shape == 4) {
                String propString = this.config.getPropertyString(((PropertyItem)view.getSelectionModel().getSelectedItem()).getName(), SourceOrTarget.SOURCE);
                boolean optional = this.config.getSourceInfo().getOptionalProperties().contains(propString);
                gen = new Property(propString, SourceOrTarget.SOURCE, optional);
            } else {
                String propString = this.config.getPropertyString(((PropertyItem)view.getSelectionModel().getSelectedItem()).getName(), SourceOrTarget.TARGET);
                boolean optional = this.config.getTargetInfo().getOptionalProperties().contains(propString);
                gen = new Property(propString, SourceOrTarget.TARGET, optional);
            }
            this.setNodeToGraph(gen, shape);
        }
    }

    private void setNodeToGraph(Node e, int shape) {
        this.view.getGraphBuild().addNode(200, 200, shape, e);
    }

    private void generateNode(ListView<String> view, int shape) {
        if (view.getSelectionModel().getSelectedItem() != null) {
            Node node = Node.createNode((String)view.getSelectionModel().getSelectedItem());
            this.setNodeToGraph(node, shape);
        }
    }

    public void showLoadedConfig(Config config) {
        ArrayList<PropertyItem> targetProperties;
        ArrayList<PropertyItem> sourceProperties;
        this.config = config;
        if (config.getSourceInfo().getFunctions() != null) {
            sourceProperties = new ArrayList<PropertyItem>();
            for (String prop : config.getSourceInfo().getProperties()) {
                if (((Map)config.getSourceInfo().getFunctions().get(prop)).keySet().toArray().length == 1) {
                    sourceProperties.add(new PropertyItem((String)((Map)config.getSourceInfo().getFunctions().get(prop)).keySet().toArray()[0]));
                    continue;
                }
                sourceProperties.add(new PropertyItem(PrefixHelper.abbreviate(prop)));
            }
            for (String prop : config.getSourceInfo().getOptionalProperties()) {
                if (((Map)config.getSourceInfo().getFunctions().get(prop)).keySet().toArray().length == 1) {
                    sourceProperties.add(new PropertyItem((String)((Map)config.getSourceInfo().getFunctions().get(prop)).keySet().toArray()[0], true));
                    continue;
                }
                sourceProperties.add(new PropertyItem(PrefixHelper.abbreviate(prop), true));
            }
            this.setListViewFromList(this.toolBoxSourceProperties, sourceProperties);
        } else {
            sourceProperties = new ArrayList();
            for (String prop : config.getSourceInfo().getProperties()) {
                sourceProperties.add(new PropertyItem(prop));
            }
            for (String prop : config.getSourceInfo().getOptionalProperties()) {
                sourceProperties.add(new PropertyItem(prop));
            }
            this.setListViewFromList(this.toolBoxSourceProperties, sourceProperties);
        }
        if (config.getTargetInfo().getFunctions() != null) {
            targetProperties = new ArrayList<PropertyItem>();
            for (String prop : config.getTargetInfo().getProperties()) {
                if (((Map)config.getTargetInfo().getFunctions().get(prop)).keySet().toArray().length == 1) {
                    targetProperties.add(new PropertyItem((String)((Map)config.getTargetInfo().getFunctions().get(prop)).keySet().toArray()[0]));
                    continue;
                }
                targetProperties.add(new PropertyItem(PrefixHelper.abbreviate(prop)));
            }
            for (String prop : config.getTargetInfo().getOptionalProperties()) {
                if (((Map)config.getTargetInfo().getFunctions().get(prop)).keySet().toArray().length == 1) {
                    targetProperties.add(new PropertyItem((String)((Map)config.getTargetInfo().getFunctions().get(prop)).keySet().toArray()[0], true));
                    continue;
                }
                targetProperties.add(new PropertyItem(PrefixHelper.abbreviate(prop), true));
            }
            this.setListViewFromList(this.toolBoxTargetProperties, targetProperties);
        } else {
            targetProperties = new ArrayList();
            for (String prop : config.getTargetInfo().getProperties()) {
                targetProperties.add(new PropertyItem(prop));
            }
            for (String prop : config.getTargetInfo().getOptionalProperties()) {
                targetProperties.add(new PropertyItem(prop));
            }
            this.setListViewFromList(this.toolBoxTargetProperties, targetProperties);
        }
        Platform.runLater(() -> {
            this.sourcePropertiesLabel.setText(config.getSourceEndpoint().getCurrentClass().getName() + " properties");
            this.targetPropertiesLabel.setText(config.getTargetEndpoint().getCurrentClass().getName() + " properties");
        });
    }

    public ListView<PropertyItem> getToolBoxSourceProperties() {
        return this.toolBoxSourceProperties;
    }

    public ListView<PropertyItem> getToolBoxTargetProperties() {
        return this.toolBoxTargetProperties;
    }

    public static class PropertyItem {
        private final StringProperty name = new SimpleStringProperty();
        private final BooleanProperty optional = new SimpleBooleanProperty();

        public PropertyItem(String name) {
            this(name, false);
        }

        public PropertyItem(String name, boolean optional) {
            this.setName(name);
            this.setOptional(optional);
        }

        public final StringProperty nameProperty() {
            return this.name;
        }

        public final String getName() {
            return (String)this.nameProperty().get();
        }

        public final void setName(String name) {
            this.nameProperty().set((Object)name);
        }

        public final BooleanProperty optionalProperty() {
            return this.optional;
        }

        public final boolean isOptional() {
            return this.optionalProperty().get();
        }

        public final void setOptional(boolean optional) {
            this.optionalProperty().set(optional);
        }

        public String toString() {
            return this.getName();
        }
    }
}

