/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.view;

import java.io.File;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.aksw.limes.core.gui.controller.MainController;
import org.aksw.limes.core.gui.controller.ResultController;
import org.aksw.limes.core.gui.model.Config;
import org.aksw.limes.core.gui.model.InstanceProperty;
import org.aksw.limes.core.gui.model.Result;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.io.mapping.AMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultView {
    private TableView<Result> table;
    private final ResultController controller;
    private TableView<InstanceProperty> sourceInstanceTable;
    private TableView<InstanceProperty> targetInstanceTable;
    private MenuItem itemSaveResults;
    private Button saveLinkSpecButton;
    private LinkSpecification learnedLS;
    private AMapping mapping;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ResultView(Config config) {
        this.createWindow();
        this.controller = new ResultController(this, config);
    }

    public ResultView(Config config, LinkSpecification learnedLS, MainController mainController) {
        this.createWindow();
        this.learnedLS = learnedLS;
        this.controller = new ResultController(this, config, mainController);
    }

    private void createWindow() {
        Stage stage = new Stage();
        VBox root = new VBox();
        HBox resultProperties = new HBox();
        Menu menuFile = new Menu("File");
        this.itemSaveResults = new MenuItem("Save Results");
        this.itemSaveResults.setOnAction(e -> {
            FileChooser fileChooser = new FileChooser();
            FileChooser.ExtensionFilter extFilterRDF = new FileChooser.ExtensionFilter("RDF File", new String[]{".n3", ".nt", ".ttl", ".rdf", ".jsonld"});
            FileChooser.ExtensionFilter extFilterCSV = new FileChooser.ExtensionFilter("CSV File", new String[]{".csv"});
            fileChooser.getExtensionFilters().add((Object)extFilterRDF);
            fileChooser.getExtensionFilters().add((Object)extFilterCSV);
            File file = fileChooser.showSaveDialog((Window)stage);
            if (file != null) {
                if (this.mapping != null) {
                    this.controller.saveResults(this.mapping, file);
                } else if (this.controller.getCurrentConfig().getMapping() != null) {
                    this.controller.saveResults(this.controller.getCurrentConfig().getMapping(), file);
                } else {
                    this.logger.error("No mapping to save found!");
                }
            }
        });
        menuFile.getItems().add((Object)this.itemSaveResults);
        root.getChildren().add((Object)new MenuBar(new Menu[]{menuFile}));
        this.sourceInstanceTable = new TableView();
        TableColumn sourceInstancePropertyColumn = new TableColumn("Property");
        sourceInstancePropertyColumn.setCellValueFactory((Callback)new PropertyValueFactory("property"));
        this.sourceInstanceTable.getColumns().add((Object)sourceInstancePropertyColumn);
        TableColumn sourceInstanceValueColumn = new TableColumn("Value");
        sourceInstanceValueColumn.setCellValueFactory((Callback)new PropertyValueFactory("value"));
        this.sourceInstanceTable.getColumns().add((Object)sourceInstanceValueColumn);
        resultProperties.getChildren().add(this.sourceInstanceTable);
        sourceInstancePropertyColumn.prefWidthProperty().bind((ObservableValue)this.sourceInstanceTable.widthProperty().divide(2));
        sourceInstanceValueColumn.prefWidthProperty().bind((ObservableValue)this.sourceInstanceTable.widthProperty().divide(2));
        this.targetInstanceTable = new TableView();
        TableColumn targetInstancePropertyColumn = new TableColumn("Property");
        targetInstancePropertyColumn.setCellValueFactory((Callback)new PropertyValueFactory("property"));
        this.targetInstanceTable.getColumns().add((Object)targetInstancePropertyColumn);
        TableColumn targetInstanceValueColumn = new TableColumn("Value");
        targetInstanceValueColumn.setCellValueFactory((Callback)new PropertyValueFactory("value"));
        this.targetInstanceTable.getColumns().add((Object)targetInstanceValueColumn);
        resultProperties.getChildren().add(this.targetInstanceTable);
        targetInstancePropertyColumn.prefWidthProperty().bind((ObservableValue)this.targetInstanceTable.widthProperty().divide(2));
        targetInstanceValueColumn.prefWidthProperty().bind((ObservableValue)this.targetInstanceTable.widthProperty().divide(2));
        this.table = new TableView();
        TableColumn columnSource = new TableColumn("Source URI");
        columnSource.setCellValueFactory((Callback)new PropertyValueFactory("sourceURI"));
        this.table.getColumns().add((Object)columnSource);
        TableColumn columnTarget = new TableColumn("Target URI");
        columnTarget.setCellValueFactory((Callback)new PropertyValueFactory("targetURI"));
        this.table.getColumns().add((Object)columnTarget);
        TableColumn columnValue = new TableColumn("value");
        columnValue.setCellValueFactory((Callback)new PropertyValueFactory("value"));
        this.table.getColumns().add((Object)columnValue);
        this.table.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> {
            if (newSelection != null) {
                this.controller.showProperties((Result)this.table.getSelectionModel().getSelectedItem());
            }
        });
        columnSource.prefWidthProperty().bind((ObservableValue)this.table.widthProperty().divide(40).multiply(17));
        columnTarget.prefWidthProperty().bind((ObservableValue)this.table.widthProperty().divide(40).multiply(17));
        columnValue.prefWidthProperty().bind((ObservableValue)this.table.widthProperty().divide(10));
        root.getChildren().add((Object)resultProperties);
        root.getChildren().add(this.table);
        root.widthProperty().addListener((arg0, arg1, arg2) -> {
            this.sourceInstanceTable.setMinWidth(arg2.doubleValue() / 2.0);
            this.sourceInstanceTable.setMaxWidth(arg2.doubleValue() / 2.0);
            this.sourceInstanceTable.setPrefWidth(arg2.doubleValue() / 2.0);
            this.targetInstanceTable.setMinWidth(arg2.doubleValue() / 2.0);
            this.targetInstanceTable.setMaxWidth(arg2.doubleValue() / 2.0);
            this.targetInstanceTable.setPrefWidth(arg2.doubleValue() / 2.0);
        });
        this.saveLinkSpecButton = new Button("Save Linkspecification");
        this.saveLinkSpecButton.setTooltip(new Tooltip("Puts the learned link specification to the metric builder"));
        this.saveLinkSpecButton.setVisible(false);
        root.getChildren().add((Object)this.saveLinkSpecButton);
        this.saveLinkSpecButton.setOnMouseClicked(e -> this.controller.saveLinkSpec(this.learnedLS));
        Scene scene = new Scene((Parent)root, 800.0, 600.0);
        scene.getStylesheets().add((Object)"gui/main.css");
        this.sourceInstanceTable.setPrefWidth(scene.getWidth() / 2.0);
        this.targetInstanceTable.setPrefWidth(scene.getWidth() / 2.0);
        stage.setMinHeight(600.0);
        stage.setMinWidth(800.0);
        stage.setTitle("LIMES");
        stage.setScene(scene);
        stage.show();
    }

    public void showResults(ObservableList<Result> results, AMapping resultMapping) {
        if (this.learnedLS != null) {
            this.saveLinkSpecButton.setVisible(true);
        }
        this.table.setItems(results);
        this.mapping = resultMapping;
        this.controller.setCachesFixed();
    }

    public void showSourceInstance(ObservableList<InstanceProperty> instanceProperty) {
        this.sourceInstanceTable.setItems(instanceProperty);
    }

    public void showTargetInstance(ObservableList<InstanceProperty> instanceProperty) {
        this.targetInstanceTable.setItems(instanceProperty);
    }

    public AMapping getMapping() {
        return this.mapping;
    }

    public void setMapping(AMapping mapping) {
        this.mapping = mapping;
    }
}

