/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.view;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.aksw.limes.core.gui.controller.MainController;
import org.aksw.limes.core.gui.view.EditClassMatchingView;
import org.aksw.limes.core.gui.view.EditEndpointsView;
import org.aksw.limes.core.gui.view.EditPropertyMatchingView;
import org.aksw.limes.core.gui.view.ToolBox;
import org.aksw.limes.core.gui.view.WizardView;
import org.aksw.limes.core.gui.view.graphBuilder.GraphBuildView;

public class MainView {
    public ToolBox toolBox;
    private GraphBuildView graphBuild;
    private MainController controller;
    private MenuItem itemSave;
    private Menu menuEdit;
    private Button toolBarNewConfigButton;
    private Button toolBarLoadConfigButton;
    private Button toolBarSaveConfigButton;
    private Button toolBarRunButton;
    private MenuItem itemBatchLearning;
    private MenuItem itemUnsupervisedLearning;
    private MenuItem itemActiveLearning;
    private BorderPane root;
    private Scene scene;
    private final String toolbarPath = "gui/toolbar/";

    public MainView(Stage stage) {
        this.showWindow(stage);
    }

    public void setController(MainController controller) {
        this.controller = controller;
    }

    private void showWindow(Stage stage) {
        this.root = new BorderPane();
        MenuBar menuBar = this.buildMenuBar((Window)stage);
        FlowPane flow = new FlowPane(Orientation.HORIZONTAL);
        flow.setAlignment(Pos.CENTER_RIGHT);
        flow.setStyle("-fx-background-color: linear-gradient(to top, -fx-base, derive(-fx-base,30%));");
        flow.getChildren().add((Object)new ImageView(new Image("gui/limes.png")));
        HBox menuBox = new HBox(0.0);
        menuBox.setAlignment(Pos.CENTER_LEFT);
        HBox.setHgrow((Node)flow, (Priority)Priority.ALWAYS);
        menuBox.getChildren().addAll((Object[])new Node[]{menuBar, flow});
        VBox menuAndToolbarBox = new VBox();
        menuAndToolbarBox.getChildren().addAll((Object[])new Node[]{menuBox, this.buildToolbar((Window)stage)});
        this.toolBox = new ToolBox(this);
        this.graphBuild = new GraphBuildView(this.toolBox);
        this.root.setTop((Node)menuAndToolbarBox);
        this.root.setLeft((Node)this.toolBox);
        this.root.setRight((Node)this.graphBuild);
        this.graphBuild.widthProperty().bind((ObservableValue)this.root.widthProperty().subtract((ObservableNumberValue)this.toolBox.widthProperty()));
        this.graphBuild.heightProperty().bind((ObservableValue)this.toolBox.heightProperty());
        this.toolBox.prefHeightProperty().bind((ObservableValue)this.root.heightProperty());
        this.toolBox.setMinHeight(this.toolBox.prefHeightProperty().doubleValue());
        this.graphBuild.start();
        this.scene = new Scene((Parent)this.root, 950.0, 650.0);
        this.root.prefHeightProperty().bind((ObservableValue)this.scene.heightProperty());
        this.root.prefWidthProperty().bind((ObservableValue)this.scene.widthProperty());
        this.root.minHeightProperty().bind((ObservableValue)this.scene.heightProperty());
        this.root.minWidthProperty().bind((ObservableValue)this.scene.widthProperty());
        this.scene.getStylesheets().add((Object)"gui/main.css");
        stage.setMinHeight(this.scene.getHeight());
        stage.setMinWidth(this.scene.getWidth());
        stage.setMaximized(true);
        stage.setTitle("LIMES");
        stage.setScene(this.scene);
        stage.show();
    }

    private HBox buildToolbar(Window stage) {
        double imageSize = 20.0;
        Image imageNewConfig = new Image(this.toolbarPath + "new_file.png", 20.0, 20.0, true, true);
        Image imageSaveConfig = new Image(this.toolbarPath + "save_file.png", 20.0, 20.0, true, true);
        Image imageLoadConfig = new Image(this.toolbarPath + "load_file.png", 20.0, 20.0, true, true);
        Image imageRun = new Image(this.toolbarPath + "run.png", 20.0, 20.0, true, true);
        this.toolBarNewConfigButton = new Button("", (Node)new ImageView(imageNewConfig));
        this.toolBarLoadConfigButton = new Button("", (Node)new ImageView(imageLoadConfig));
        this.toolBarSaveConfigButton = new Button("", (Node)new ImageView(imageSaveConfig));
        this.toolBarRunButton = new Button("", (Node)new ImageView(imageRun));
        this.toolBarNewConfigButton.setTooltip(new Tooltip("Create a new configuration"));
        this.toolBarLoadConfigButton.setTooltip(new Tooltip("Load a new configuration file"));
        this.toolBarSaveConfigButton.setTooltip(new Tooltip("Save this configuration to a file"));
        this.toolBarRunButton.setTooltip(new Tooltip("Execute this link specification"));
        this.toolBarNewConfigButton.setId("toolBarNewConfigButton");
        this.toolBarLoadConfigButton.setId("toolBarLoadConfigButton");
        this.toolBarSaveConfigButton.setId("toolBarSaveConfigButton");
        this.toolBarRunButton.setId("toolBarRunButton");
        this.toolBarNewConfigButton.getStyleClass().add((Object)"toolBarButton");
        this.toolBarLoadConfigButton.getStyleClass().add((Object)"toolBarButton");
        this.toolBarSaveConfigButton.getStyleClass().add((Object)"toolBarButton");
        this.toolBarRunButton.getStyleClass().add((Object)"toolBarButton");
        this.toolBarNewConfigButton.setOnMouseClicked(e -> {
            WizardView wizardView = new WizardView();
            this.controller.newConfig(wizardView, new EditEndpointsView(wizardView), new EditClassMatchingView(wizardView), new EditPropertyMatchingView(wizardView));
        });
        this.toolBarLoadConfigButton.setOnMouseClicked((EventHandler)new LoadConfigEventHandler(stage));
        this.toolBarSaveConfigButton.setOnMouseClicked((EventHandler)new SaveConfigEventHandler(stage));
        this.toolBarRunButton.setOnMouseClicked(e -> this.controller.map());
        HBox toolBarBox = new HBox();
        toolBarBox.getChildren().addAll((Object[])new Node[]{this.toolBarNewConfigButton, this.toolBarLoadConfigButton, this.toolBarSaveConfigButton, this.toolBarRunButton});
        toolBarBox.setStyle("-fx-background-color: linear-gradient(to bottom, derive(-fx-base,30%), derive(-fx-base,60%));");
        toolBarBox.setSpacing(5.0);
        toolBarBox.setPadding(new Insets(0.0, 0.0, 1.0, 15.0));
        return toolBarBox;
    }

    private MenuBar buildMenuBar(Window stage) {
        Menu menuConfiguration = new Menu("Configuration");
        menuConfiguration.setId("menuConfiguration");
        MenuItem itemNew = new MenuItem("New");
        itemNew.setId("#itemNew");
        itemNew.setOnAction(e -> {
            WizardView wizardView = new WizardView();
            this.controller.newConfig(wizardView, new EditEndpointsView(wizardView), new EditClassMatchingView(wizardView), new EditPropertyMatchingView(wizardView));
        });
        menuConfiguration.getItems().add((Object)itemNew);
        this.menuEdit = new Menu("Edit");
        this.menuEdit.setId("menuEdit");
        MenuItem itemEditClasses = new MenuItem("Edit Classes");
        itemEditClasses.setId("itemEditClasses");
        itemEditClasses.setOnAction(e -> {
            WizardView wizardView = new WizardView();
            this.controller.editConfig(wizardView, new EditClassMatchingView(wizardView), new EditPropertyMatchingView(wizardView));
        });
        MenuItem itemEditProperties = new MenuItem("Edit Properties");
        itemEditProperties.setId("itemEditProperties");
        itemEditProperties.setOnAction(e -> {
            WizardView wizardView = new WizardView();
            this.controller.editConfig(wizardView, new EditPropertyMatchingView(wizardView));
        });
        this.menuEdit.getItems().addAll((Object[])new MenuItem[]{itemEditClasses, itemEditProperties});
        menuConfiguration.getItems().add((Object)this.menuEdit);
        menuConfiguration.getItems().add((Object)new SeparatorMenuItem());
        MenuItem itemLoad = new MenuItem("Load Configuration");
        itemLoad.setId("itemLoad");
        itemLoad.setOnAction((EventHandler)new LoadConfigEventHandler(stage));
        menuConfiguration.getItems().add((Object)itemLoad);
        this.itemSave = new MenuItem("Save Configuration");
        this.itemSave.setId("itemSave");
        this.itemSave.setOnAction((EventHandler)new SaveConfigEventHandler(stage));
        menuConfiguration.getItems().add((Object)this.itemSave);
        menuConfiguration.getItems().add((Object)new SeparatorMenuItem());
        MenuItem itemExit = new MenuItem("Exit");
        itemExit.setId("itemExit");
        itemExit.setOnAction(e -> this.controller.exit());
        menuConfiguration.getItems().add((Object)itemExit);
        Menu menuLayout = new Menu("Layout");
        menuLayout.setId("menuLayout");
        MenuItem layoutGraph = new MenuItem("Refresh Layout");
        layoutGraph.setId("layoutGraph");
        layoutGraph.setOnAction(e -> this.graphBuild.graphBuildController.layoutGraph());
        MenuItem deleteGraph = new MenuItem("Delete Graph");
        deleteGraph.setId("deleteGraph");
        deleteGraph.setOnAction(e -> this.graphBuild.graphBuildController.deleteGraph());
        menuLayout.getItems().addAll((Object[])new MenuItem[]{layoutGraph, deleteGraph});
        Menu menuLearn = new Menu("Learn");
        menuLearn.setId("menuLearn");
        this.itemBatchLearning = new MenuItem("Batch Learning");
        this.itemBatchLearning.setId("#menuLearnBatchLearning");
        this.itemBatchLearning.setOnAction(e -> this.controller.showBatchLearning());
        this.itemUnsupervisedLearning = new MenuItem("Unsupervised Learning");
        this.itemUnsupervisedLearning.setId("#menuLearnUnsupervisedLearning");
        this.itemUnsupervisedLearning.setOnAction(e -> this.controller.showUnsupervisedLearning());
        this.itemActiveLearning = new MenuItem("Active Learning");
        this.itemActiveLearning.setId("#menuLearnActiveLearning");
        this.itemActiveLearning.setOnAction(e -> this.controller.showActiveLearning());
        menuLearn.getItems().add((Object)this.itemActiveLearning);
        menuLearn.getItems().add((Object)this.itemBatchLearning);
        menuLearn.getItems().add((Object)this.itemUnsupervisedLearning);
        MenuBar menuBar = new MenuBar(new Menu[]{menuConfiguration, menuLayout, menuLearn});
        menuBar.setId("menuBar");
        return menuBar;
    }

    public void showLoadedConfig(boolean isLoaded) {
        this.menuEdit.setDisable(!isLoaded);
        this.itemSave.setDisable(!isLoaded);
        this.toolBarSaveConfigButton.setDisable(!isLoaded);
        this.toolBarRunButton.setDisable(!isLoaded);
        this.itemBatchLearning.setDisable(!isLoaded);
        this.itemUnsupervisedLearning.setDisable(!isLoaded);
        this.itemActiveLearning.setDisable(!isLoaded);
    }

    public static void showErrorWithStacktrace(String header, String content, Throwable ex) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setHeaderText(header);
        alert.setContentText(content);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        ex.printStackTrace();
        String exceptionText = sw.toString();
        Label label = new Label("The exception stacktrace was:");
        TextArea textArea = new TextArea(exceptionText);
        textArea.setEditable(false);
        textArea.setWrapText(true);
        textArea.setMaxWidth(Double.MAX_VALUE);
        textArea.setMaxHeight(Double.MAX_VALUE);
        GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane expContent = new GridPane();
        expContent.setMaxWidth(Double.MAX_VALUE);
        expContent.add((Node)label, 0, 0);
        expContent.add((Node)textArea, 0, 1);
        alert.getDialogPane().setExpandableContent((Node)expContent);
        alert.showAndWait();
    }

    public BorderPane getRoot() {
        return this.root;
    }

    public Scene getScene() {
        return this.scene;
    }

    public GraphBuildView getGraphBuild() {
        return this.graphBuild;
    }

    private class SaveConfigEventHandler
    implements EventHandler {
        private final Window stage;

        public SaveConfigEventHandler(Window stage) {
            this.stage = stage;
        }

        public void handle(Event event) {
            FileChooser fileChooser = new FileChooser();
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("LIMES Configuration File (*.rdf, *.ttl, *.n3, *.nt)", new String[]{"*.rdf", "*.ttl", "*.n3", "*.nt"});
            fileChooser.getExtensionFilters().add((Object)extFilter);
            File file = fileChooser.showSaveDialog(this.stage);
            if (file != null) {
                MainView.this.controller.saveConfig(file);
            }
        }
    }

    private class LoadConfigEventHandler
    implements EventHandler {
        private final Window stage;

        public LoadConfigEventHandler(Window stage) {
            this.stage = stage;
        }

        public void handle(Event event) {
            FileChooser fileChooser = new FileChooser();
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("LIMES Configuration File (*.xml, *.rdf, *.ttl, *.n3, *.nt)", new String[]{"*.xml", "*.rdf", "*.ttl", "*.n3", "*.nt"});
            fileChooser.getExtensionFilters().add((Object)extFilter);
            File file = fileChooser.showOpenDialog(this.stage);
            if (file != null) {
                MainView.this.controller.loadConfig(file);
            }
        }
    }
}

