/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import org.aksw.limes.core.gui.controller.EditPropertyMatchingController;
import org.aksw.limes.core.gui.model.AutomatedPropertyMatchingNode;
import org.aksw.limes.core.gui.util.SourceOrTarget;
import org.aksw.limes.core.gui.util.sparql.PrefixHelper;
import org.aksw.limes.core.gui.view.IEditView;
import org.aksw.limes.core.gui.view.WizardView;
import org.aksw.limes.core.io.mapping.AMapping;

public class EditPropertyMatchingView
implements IEditView {
    private EditPropertyMatchingController controller;
    private ScrollPane rootPane;
    WizardView wizardView;
    private Button addAllButton;
    private Button removeAllButton;
    private final Button switchModeButton = new Button("Default Text");
    private Label missingPropertiesLabel;
    private final BooleanProperty automated = new SimpleBooleanProperty(true);
    private ListView<String> sourcePropList;
    private ListView<String> targetPropList;
    private ListView<String> addedSourcePropsList;
    private ListView<String> addedTargetPropsList;
    private final ObservableList<String> sourceProperties = FXCollections.observableArrayList();
    private final ObservableList<String> targetProperties = FXCollections.observableArrayList();
    private Label sourceID;
    private Label targetID;
    private TableView<AutomatedPropertyMatchingNode> automatedPropList;
    private TableView<AutomatedPropertyMatchingNode> addedAutomatedPropsList;
    private final ObservableList<AutomatedPropertyMatchingNode> availableProperties = FXCollections.observableArrayList();
    private final ObservableList<AutomatedPropertyMatchingNode> addedProperties = FXCollections.observableArrayList();

    EditPropertyMatchingView(WizardView wizardView) {
        this.wizardView = wizardView;
        this.createRootPane();
    }

    public void setController(EditPropertyMatchingController controller) {
        this.controller = controller;
    }

    private Parent createRootPane() {
        if (this.automated.get()) {
            this.rootPane = this.createAutomatedRootPane();
            this.addListeners();
        } else {
            this.rootPane = this.createManualRootPane();
            this.addListeners();
        }
        this.rootPane.setId("editPropertyMatchingRootPane");
        return this.rootPane;
    }

    private ScrollPane createAutomatedRootPane() {
        this.automatedPropList = new TableView();
        this.automatedPropList.setId("automatedPropList");
        TableColumn sourcePropColumn = new TableColumn();
        TableColumn targetPropColumn = new TableColumn();
        sourcePropColumn.setCellValueFactory((Callback)new PropertyValueFactory("sourceProperty"));
        sourcePropColumn.setId("sourcePropColumn");
        targetPropColumn.setCellValueFactory((Callback)new PropertyValueFactory("targetProperty"));
        targetPropColumn.setId("targetPropColumn");
        this.automatedPropList.getColumns().addAll((Object[])new TableColumn[]{sourcePropColumn, targetPropColumn});
        this.automatedPropList.setItems(this.availableProperties);
        this.automatedPropList.setEditable(false);
        this.automatedPropList.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.addedAutomatedPropsList = new TableView();
        TableColumn addedSourcePropColumn = new TableColumn();
        TableColumn addedTargetPropColumn = new TableColumn();
        addedSourcePropColumn.setText("source");
        addedTargetPropColumn.setText("target");
        addedSourcePropColumn.setCellValueFactory((Callback)new PropertyValueFactory("sourceProperty"));
        addedTargetPropColumn.setCellValueFactory((Callback)new PropertyValueFactory("targetProperty"));
        this.addedAutomatedPropsList.getColumns().addAll((Object[])new TableColumn[]{addedSourcePropColumn, addedTargetPropColumn});
        this.addedAutomatedPropsList.setItems(this.addedProperties);
        this.addedAutomatedPropsList.setEditable(false);
        this.addedAutomatedPropsList.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        Label propertiesLabel = new Label("recommended properties:");
        propertiesLabel.setTextFill((Paint)Color.DARKSLATEGREY);
        Label addedPropertiesLabel = new Label("added properties:");
        addedPropertiesLabel.setTextFill((Paint)Color.DARKSLATEGREY);
        VBox propertiesColumn = new VBox();
        propertiesColumn.getChildren().addAll((Object[])new Node[]{propertiesLabel, this.automatedPropList, addedPropertiesLabel, this.addedAutomatedPropsList});
        this.addAllButton = new Button("Add all");
        this.removeAllButton = new Button("Remove all");
        this.missingPropertiesLabel = new Label("At least one property must be chosen!");
        this.missingPropertiesLabel.setTextFill((Paint)Color.RED);
        this.missingPropertiesLabel.setVisible(false);
        HBox buttons = new HBox();
        this.switchModeButton.setText("Manual Matching");
        this.switchModeButton.setId("switchModeButton");
        Region leftRegion = new Region();
        Region rightRegion = new Region();
        HBox.setHgrow((Node)leftRegion, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)rightRegion, (Priority)Priority.ALWAYS);
        buttons.getChildren().addAll((Object[])new Node[]{this.switchModeButton, leftRegion, this.missingPropertiesLabel, rightRegion, this.addAllButton, this.removeAllButton});
        BorderPane root = new BorderPane();
        root.setId("root");
        root.setCenter((Node)propertiesColumn);
        root.setBottom((Node)buttons);
        ScrollPane pane = new ScrollPane((Node)root);
        pane.setOnMouseClicked(e -> this.missingPropertiesLabel.setVisible(false));
        pane.setFitToHeight(true);
        pane.setFitToWidth(true);
        pane.setPadding(new Insets(5.0));
        return pane;
    }

    private ScrollPane createManualRootPane() {
        this.sourcePropList = new ListView();
        this.sourcePropList.setId("sourcePropList");
        this.targetPropList = new ListView();
        this.targetPropList.setId("targetPropList");
        this.addedSourcePropsList = new ListView();
        this.addedSourcePropsList.setId("addedSourcePropsList");
        this.addedTargetPropsList = new ListView();
        this.addedTargetPropsList.setId("addedTargetPropsList");
        Label sourceLabel = new Label("available Source Properties:");
        this.sourceID = new Label();
        Label targetLabel = new Label("available Target Properties:");
        this.targetID = new Label();
        Label addedSourceLabel = new Label("added Source Properties:");
        Label addedTargetLabel = new Label("added Target Properties:");
        VBox sourceColumn = new VBox();
        VBox targetColumn = new VBox();
        sourceColumn.getChildren().addAll((Object[])new Node[]{this.sourceID, sourceLabel, this.sourcePropList, addedSourceLabel, this.addedSourcePropsList});
        targetColumn.getChildren().addAll((Object[])new Node[]{this.targetID, targetLabel, this.targetPropList, addedTargetLabel, this.addedTargetPropsList});
        this.addAllButton = new Button("Add all");
        this.removeAllButton = new Button("Remove all");
        this.missingPropertiesLabel = new Label("At least one source and one target property must be chosen!");
        this.missingPropertiesLabel.setTextFill((Paint)Color.RED);
        this.missingPropertiesLabel.setVisible(false);
        HBox buttons = new HBox();
        this.switchModeButton.setText("Automated Matching");
        this.switchModeButton.setId("switchModeButton");
        Region leftRegion = new Region();
        Region rightRegion = new Region();
        HBox.setHgrow((Node)leftRegion, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)rightRegion, (Priority)Priority.ALWAYS);
        buttons.getChildren().addAll((Object[])new Node[]{this.switchModeButton, leftRegion, this.missingPropertiesLabel, rightRegion, this.addAllButton, this.removeAllButton});
        BorderPane root = new BorderPane();
        HBox hb = new HBox();
        hb.getChildren().addAll((Object[])new Node[]{sourceColumn, targetColumn});
        HBox.setHgrow((Node)sourceColumn, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)targetColumn, (Priority)Priority.ALWAYS);
        root.setCenter((Node)hb);
        root.setBottom((Node)buttons);
        ScrollPane pane = new ScrollPane((Node)root);
        pane.setOnMouseClicked(e -> this.missingPropertiesLabel.setVisible(false));
        pane.setFitToHeight(true);
        pane.setFitToWidth(true);
        pane.setPadding(new Insets(5.0));
        return pane;
    }

    private void addListeners() {
        if (this.automated.get()) {
            this.addListenersForAutomated();
        } else {
            this.addListenersForManual();
        }
        this.switchModeButton.setOnAction(e -> {
            this.rootPane = null;
            this.automated.set(!this.automated.get());
            this.wizardView.setToRootPane((Parent)this.rootPane);
            this.controller.load(this.automated.get());
        });
        this.automated.addListener((observable, oldValue, newValue) -> {
            if (this.rootPane == null) {
                this.createRootPane();
            }
            if (!this.automated.get() && this.addedSourcePropsList == null) {
                this.createRootPane();
            }
        });
    }

    public void addListenersForAutomated() {
        this.automatedPropList.setOnMouseClicked(e -> {
            if (this.automatedPropList.getSelectionModel().getSelectedItem() != null) {
                this.addedAutomatedPropsList.getItems().add(this.automatedPropList.getSelectionModel().getSelectedItem());
                this.automatedPropList.getItems().remove(this.automatedPropList.getSelectionModel().getSelectedItem());
            }
        });
        this.addedAutomatedPropsList.setOnMouseClicked(e -> {
            if (this.addedAutomatedPropsList.getSelectionModel().getSelectedItem() != null) {
                this.automatedPropList.getItems().add(this.addedAutomatedPropsList.getSelectionModel().getSelectedItem());
                this.addedAutomatedPropsList.getItems().remove(this.addedAutomatedPropsList.getSelectionModel().getSelectedItem());
            }
        });
        this.addAllButton.setOnAction(e -> {
            this.addedAutomatedPropsList.getItems().addAll((Collection)this.automatedPropList.getItems());
            this.automatedPropList.getItems().clear();
        });
        this.removeAllButton.setOnAction(e -> {
            this.automatedPropList.getItems().addAll((Collection)this.addedAutomatedPropsList.getItems());
            this.addedAutomatedPropsList.getItems().clear();
        });
    }

    public void addListenersForManual() {
        this.sourceProperties.addListener(change -> {
            if (this.sourceProperties.size() != 0 && this.targetProperties.size() != 0) {
                this.putAllPropertiesToTable();
            }
        });
        this.targetProperties.addListener(change -> {
            if (this.sourceProperties.size() != 0 && this.targetProperties.size() != 0) {
                this.putAllPropertiesToTable();
            }
        });
        this.sourcePropList.setOnMouseClicked(e -> {
            if (this.sourcePropList.getSelectionModel().getSelectedItem() != null) {
                this.addedSourcePropsList.getItems().add(this.sourcePropList.getSelectionModel().getSelectedItem());
                this.sourcePropList.getItems().remove(this.sourcePropList.getSelectionModel().getSelectedItem());
            }
        });
        this.targetPropList.setOnMouseClicked(e -> {
            if (this.targetPropList.getSelectionModel().getSelectedItem() != null) {
                this.addedTargetPropsList.getItems().add(this.targetPropList.getSelectionModel().getSelectedItem());
                this.targetPropList.getItems().remove(this.targetPropList.getSelectionModel().getSelectedItem());
            }
        });
        this.addedSourcePropsList.setOnMouseClicked(e -> {
            if (this.addedSourcePropsList.getSelectionModel().getSelectedItem() != null) {
                this.sourcePropList.getItems().add(this.addedSourcePropsList.getSelectionModel().getSelectedItem());
                Collections.sort(this.sourcePropList.getItems());
                this.addedSourcePropsList.getItems().remove(this.addedSourcePropsList.getSelectionModel().getSelectedItem());
            }
        });
        this.addedTargetPropsList.setOnMouseClicked(e -> {
            if (this.addedTargetPropsList.getSelectionModel().getSelectedItem() != null) {
                this.targetPropList.getItems().add(this.addedTargetPropsList.getSelectionModel().getSelectedItem());
                Collections.sort(this.targetPropList.getItems());
                this.addedTargetPropsList.getItems().remove(this.addedTargetPropsList.getSelectionModel().getSelectedItem());
            }
        });
        this.addAllButton.setOnAction(e -> {
            this.addedSourcePropsList.getItems().addAll((Collection)new SortedList(this.sourcePropList.getItems()));
            this.addedTargetPropsList.getItems().addAll((Collection)new SortedList(this.targetPropList.getItems()));
            this.sourcePropList.getItems().clear();
            this.targetPropList.getItems().clear();
        });
        this.removeAllButton.setOnAction(e -> {
            this.sourcePropList.getItems().addAll((Collection)new SortedList(this.addedSourcePropsList.getItems()));
            this.targetPropList.getItems().addAll((Collection)new SortedList(this.addedTargetPropsList.getItems()));
            this.addedSourcePropsList.getItems().clear();
            this.addedTargetPropsList.getItems().clear();
        });
    }

    @Override
    public Parent getPane() {
        return this.rootPane;
    }

    @Override
    public void save() {
        if (this.automated.get()) {
            ArrayList<String> sourceProperties = new ArrayList<String>();
            ArrayList<String> targetProperties = new ArrayList<String>();
            for (AutomatedPropertyMatchingNode addedPropertyNode : this.addedProperties) {
                sourceProperties.add(addedPropertyNode.getSourceProperty().get());
                targetProperties.add(addedPropertyNode.getTargetProperty().get());
            }
            this.controller.save(sourceProperties, targetProperties);
        } else {
            this.controller.save((List<String>)this.addedSourcePropsList.getItems(), (List<String>)this.addedTargetPropsList.getItems());
        }
    }

    public void showAutomatedProperties(AMapping properties) {
        this.availableProperties.removeAll(this.availableProperties);
        for (String sourceProperty : properties.getMap().keySet()) {
            for (String targetProperty : ((HashMap)properties.getMap().get(sourceProperty)).keySet()) {
                this.availableProperties.add((Object)new AutomatedPropertyMatchingNode(PrefixHelper.abbreviate(sourceProperty), PrefixHelper.abbreviate(targetProperty)));
            }
        }
        Collections.sort(this.availableProperties, AutomatedPropertyMatchingNode.AUTOMATED_PROPERTY_MATCHING_NODE_COMPARATOR);
        this.automatedPropList.setItems(this.availableProperties);
        ((TableColumn)this.automatedPropList.getColumns().get(0)).setText(this.controller.getConfig().getSourceEndpoint().getCurrentClass().getName() + "  properties");
        ((TableColumn)this.automatedPropList.getColumns().get(1)).setText(this.controller.getConfig().getTargetEndpoint().getCurrentClass().getName() + "  properties");
    }

    public void showAvailableProperties(SourceOrTarget sourceOrTarget, List<String> properties) {
        if (!this.automated.get()) {
            this.addedSourcePropsList.getItems().clear();
            this.addedTargetPropsList.getItems().clear();
        } else {
            this.addedAutomatedPropsList.getItems().clear();
        }
        Collections.sort(properties);
        (sourceOrTarget == SourceOrTarget.SOURCE ? this.sourceProperties : this.targetProperties).setAll(properties);
        (sourceOrTarget == SourceOrTarget.SOURCE ? this.sourcePropList : this.targetPropList).setItems(sourceOrTarget == SourceOrTarget.SOURCE ? this.sourceProperties : this.targetProperties);
    }

    private void putAllPropertiesToTable() {
        this.sourcePropList.setItems(this.sourceProperties);
        this.targetPropList.setItems(this.targetProperties);
        this.sourceID.setText("ID: " + this.controller.getConfig().getSourceInfo().getId() + "\t Class: " + this.controller.getConfig().getSourceEndpoint().getCurrentClass().getName());
        this.targetID.setText("ID: " + this.controller.getConfig().getTargetInfo().getId() + "\t Class: " + this.controller.getConfig().getTargetEndpoint().getCurrentClass().getName());
    }

    public void showError(String header, String content) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setHeaderText(header);
        alert.setContentText(content);
        alert.showAndWait();
    }

    public ListView<String> getAddedSourcePropsList() {
        return this.addedSourcePropsList;
    }

    public ListView<String> getAddedTargetPropsList() {
        return this.addedTargetPropsList;
    }

    public Label getMissingPropertiesLabel() {
        return this.missingPropertiesLabel;
    }

    public TableView<AutomatedPropertyMatchingNode> getAddedAutomatedPropsList() {
        return this.addedAutomatedPropsList;
    }

    public Button getSwitchModeButton() {
        return this.switchModeButton;
    }

    @Override
    public void setAutomated(boolean automated) {
        this.automated.set(automated);
        this.switchModeButton.setVisible(automated);
    }

    @Override
    public Boolean isAutomated() {
        return this.automated.get();
    }
}

