/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.view;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.aksw.limes.core.gui.controller.EditEndpointsController;
import org.aksw.limes.core.gui.util.SourceOrTarget;
import org.aksw.limes.core.gui.view.IEditView;
import org.aksw.limes.core.gui.view.WizardView;

public class EditEndpointsView
implements IEditView {
    private static final String pageSizeError = "Only numbers are permitted!";
    private static final String endpointURLError = "Invalid URL or file not found!";
    private static final String[] recommendedEndpoints = new String[]{"http://dbpedia.org/sparql", "http://linkedgeodata.org/sparql"};
    private EditEndpointsController controller;
    private Node[] sourceFields;
    private Node[] targetFields;
    private ScrollPane rootPane;
    private final WizardView wizardView;

    EditEndpointsView(WizardView wizardView) {
        this.createRootPane();
        this.wizardView = wizardView;
    }

    public void setController(EditEndpointsController controller) {
        this.controller = controller;
    }

    private void createRootPane() {
        HBox hbox = new HBox();
        Node sourcePanelWithTitle = this.createEndpointPane(SourceOrTarget.SOURCE);
        HBox.setHgrow((Node)sourcePanelWithTitle, (Priority)Priority.ALWAYS);
        hbox.getChildren().add((Object)sourcePanelWithTitle);
        Node targetPaneWithTitle = this.createEndpointPane(SourceOrTarget.TARGET);
        HBox.setHgrow((Node)targetPaneWithTitle, (Priority)Priority.ALWAYS);
        hbox.getChildren().add((Object)targetPaneWithTitle);
        this.rootPane = new ScrollPane((Node)hbox);
        this.rootPane.setFitToHeight(true);
        this.rootPane.setFitToWidth(true);
    }

    @Override
    public Parent getPane() {
        return this.rootPane;
    }

    private Node createEndpointPane(SourceOrTarget sourceOrTarget) {
        GridPane pane = new GridPane();
        pane.setAlignment(Pos.CENTER);
        pane.setHgap(10.0);
        pane.setVgap(10.0);
        pane.setPadding(new Insets(25.0, 25.0, 25.0, 25.0));
        ColumnConstraints column1 = new ColumnConstraints();
        column1.setMinWidth(Double.NEGATIVE_INFINITY);
        ColumnConstraints column2 = new ColumnConstraints();
        column2.setMinWidth(300.0);
        column2.setHgrow(Priority.ALWAYS);
        pane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column1, column2});
        pane.add((Node)new Label("Endpoint URL"), 0, 0);
        ComboBox endpointURL = new ComboBox();
        endpointURL.getItems().addAll((Object[])recommendedEndpoints);
        endpointURL.setEditable(true);
        endpointURL.setId((Object)((Object)sourceOrTarget) + "endpointURLTextField");
        endpointURL.valueProperty().addListener((observable, oldValue, newValue) -> {
            File f;
            if (!(endpointURL.getValue() == null || ((String)endpointURL.getValue()).equals("") || (f = new File((String)endpointURL.getValue())).exists() && !f.isDirectory())) {
                try {
                    new URL((String)endpointURL.getValue());
                }
                catch (MalformedURLException e) {
                    endpointURL.setValue((Object)endpointURLError);
                    endpointURL.setStyle("-fx-text-inner-color: red;");
                }
            }
        });
        endpointURL.setOnMouseEntered(e -> {
            if (endpointURL.getValue() != null && !((String)endpointURL.getValue()).equals("") && ((String)endpointURL.getValue()).equals(endpointURLError)) {
                endpointURL.setStyle("");
                endpointURL.setValue((Object)"");
            }
        });
        Button fileEndpointButton = new Button();
        fileEndpointButton.setId((Object)((Object)sourceOrTarget) + "fileEndpointButton");
        Image fileButtonImage = new Image(this.getClass().getResourceAsStream("/gui/file.png"), 20.0, 20.0, true, false);
        fileEndpointButton.setGraphic((Node)new ImageView(fileButtonImage));
        fileEndpointButton.setOnAction(e -> {
            FileChooser fileChooser = new FileChooser();
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Endpoint File (*.xml, *.rdf, *.ttl, *.n3, *.nt)", new String[]{"*.xml", "*.rdf", "*.ttl", "*.n3", "*.nt"});
            fileChooser.getExtensionFilters().add((Object)extFilter);
            File file = fileChooser.showOpenDialog((Window)this.wizardView.getStage());
            if (file != null) {
                endpointURL.setValue((Object)file.getAbsolutePath());
            }
        });
        HBox endpointBox = new HBox();
        HBox.setHgrow((Node)endpointURL, (Priority)Priority.ALWAYS);
        endpointBox.getChildren().addAll((Object[])new Node[]{endpointURL, fileEndpointButton});
        pane.add((Node)endpointBox, 1, 0);
        pane.add((Node)new Label("ID / Namespace"), 0, 1);
        TextField idNamespace = new TextField();
        idNamespace.setId((Object)((Object)sourceOrTarget) + "idNamespaceTextField");
        pane.add((Node)idNamespace, 1, 1);
        pane.add((Node)new Label("Graph"), 0, 2);
        TextField graph = new TextField();
        graph.setId((Object)((Object)sourceOrTarget) + "graphTextField");
        pane.add((Node)graph, 1, 2);
        pane.add((Node)new Label("Page size"), 0, 3);
        TextField pageSize = new TextField();
        pageSize.setId((Object)((Object)sourceOrTarget) + "pageSizeTextField");
        pageSize.focusedProperty().addListener((arg0, oldValue, newValue) -> {
            if (!(newValue.booleanValue() || pageSize.getText().matches("[0-9]+") || pageSize.getText().equals("-1"))) {
                pageSize.setText(pageSizeError);
                pageSize.setStyle("-fx-text-inner-color: red;");
            }
        });
        pageSize.setOnMouseClicked(e -> {
            if (pageSize.getText().equals(pageSizeError)) {
                pageSize.setStyle("");
                pageSize.setText("");
            }
        });
        pane.add((Node)pageSize, 1, 3);
        Node[] textFields = new Node[]{endpointURL, idNamespace, graph, pageSize};
        if (sourceOrTarget == SourceOrTarget.SOURCE) {
            this.sourceFields = textFields;
            return new TitledPane("Source endpoint", (Node)pane);
        }
        this.targetFields = textFields;
        return new TitledPane("Target endpoint", (Node)pane);
    }

    public void setFields(SourceOrTarget sourceOrTarget, String endpoint, String idNamespace, String graph, String pageSize) {
        Node[] textFields = sourceOrTarget == SourceOrTarget.SOURCE ? this.sourceFields : this.targetFields;
        ((ComboBox)textFields[0]).setValue((Object)endpoint);
        ((TextField)textFields[1]).setText(idNamespace);
        ((TextField)textFields[2]).setText(graph);
        ((TextField)textFields[3]).setText(pageSize);
    }

    @Override
    public void save() {
        this.controller.save(SourceOrTarget.SOURCE, (String)((ComboBox)this.sourceFields[0]).getValue(), ((TextField)this.sourceFields[1]).getText(), ((TextField)this.sourceFields[2]).getText(), ((TextField)this.sourceFields[3]).getText());
        this.controller.save(SourceOrTarget.TARGET, (String)((ComboBox)this.targetFields[0]).getValue(), ((TextField)this.targetFields[1]).getText(), ((TextField)this.targetFields[2]).getText(), ((TextField)this.targetFields[3]).getText());
    }

    public Node[] getSourceFields() {
        return this.sourceFields;
    }

    public Node[] getTargetFields() {
        return this.targetFields;
    }

    @Override
    public Boolean isAutomated() {
        return false;
    }

    @Override
    public void setAutomated(boolean automated) {
    }
}

