/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javafx.concurrent.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskResultSerializer {
    public static File folder = new File(System.getProperty("user.dir") + "/cache/");
    static Logger logger = LoggerFactory.getLogger((String)TaskResultSerializer.class.getName());

    public static Object getTaskResult(Task task) {
        String hash = task.hashCode() + "";
        File serializationFile = new File(folder + hash + ".ser");
        logger.info("Checking for file " + serializationFile.getAbsolutePath());
        Object taskResult = null;
        try {
            if (!serializationFile.exists()) {
                return null;
            }
            logger.info("Found serialization. Loading data from file " + serializationFile.getAbsolutePath());
            FileInputStream fileIn = new FileInputStream(serializationFile);
            ObjectInputStream in = new ObjectInputStream(fileIn);
            taskResult = in.readObject();
            in.close();
            fileIn.close();
            if (taskResult == null) {
                throw new Exception();
            }
            logger.info("Serialization loaded successfully from file " + serializationFile.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return taskResult;
    }

    public static void serializeTaskResult(Task task, Object result) {
        try {
            String hash = task.hashCode() + "";
            File serializationFile = new File(folder + hash + ".ser");
            FileOutputStream fileOut = new FileOutputStream(serializationFile);
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(result);
            out.close();
            fileOut.close();
            logger.info("Serialized data is saved in " + serializationFile.getAbsolutePath());
        }
        catch (IOException i) {
            i.printStackTrace();
        }
    }
}

