/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.aksw.limes.core.gui.util.sparql.SPARQLHelper;

public class Restriction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String property;
    private String object;

    public Restriction(String property, String object) {
        if (property == null | object == null || property.isEmpty() || object.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.property = property;
        this.object = object;
    }

    public static Restriction fromString(String s) throws IllegalArgumentException {
        String[] tokens = s.split("\\s+");
        if (tokens.length < 2 || tokens.length > 3) {
            throw new IllegalArgumentException("parameter s has to consist of exactly two or three parts separated by space characters, instead it is \"" + s + "\".");
        }
        if (tokens.length == 3) {
            return new Restriction(tokens[1], tokens[2]);
        }
        return new Restriction(tokens[0], tokens[1]);
    }

    public static String restrictionUnion(Collection<Restriction> restrictions, String var) throws IllegalArgumentException {
        StringBuilder restrictionBuilder = new StringBuilder();
        for (Restriction restriction : restrictions) {
            if (restriction == null) {
                throw new IllegalArgumentException("Oone of the input restrictions was null.");
            }
            if (restrictionBuilder.length() > 0) {
                restrictionBuilder.append(" UNION ");
            }
            restrictionBuilder.append('{' + restriction.toString(var) + '}');
        }
        return restrictionBuilder.toString();
    }

    public static List<Restriction> fromString(List<String> restrictionStrings) {
        Vector<Restriction> restrictions = new Vector<Restriction>();
        for (String restrictionString : restrictionStrings) {
            restrictions.add(Restriction.fromString(restrictionString));
        }
        return restrictions;
    }

    public static String restrictionUnion(Vector<String> restrictionStrings, String var) {
        return Restriction.restrictionUnion(Restriction.fromString(restrictionStrings), var);
    }

    public String getProperty() {
        return this.property;
    }

    public String getObject() {
        return this.object;
    }

    public String toString() {
        return this.property + ' ' + this.object;
    }

    public String toString(String var) {
        return '?' + var + ' ' + SPARQLHelper.wrapIfNecessary(this.property) + ' ' + SPARQLHelper.wrapIfNecessary(this.object);
    }
}

