/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.io.cache.MemoryCache;

public class AdvancedMemoryCache
extends MemoryCache
implements Serializable {
    private static final long serialVersionUID = 1L;

    public static AdvancedMemoryCache loadFromFile(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        ObjectInputStream deSerializer = new ObjectInputStream(in);
        try {
            AdvancedMemoryCache cache;
            AdvancedMemoryCache advancedMemoryCache = cache = (AdvancedMemoryCache)deSerializer.readObject();
            return advancedMemoryCache;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        finally {
            in.close();
        }
    }

    public String[] getCommonProperties(Double threshold, Integer limit) {
        if (threshold != null && (threshold < 0.0 || threshold > 1.0)) {
            throw new IllegalArgumentException("parameter relativeThreshold must lie between 0 and 1 inclusively.");
        }
        HashMap<String, Integer> propertyOccurrences = new HashMap<String, Integer>();
        for (String uri : this.getAllUris()) {
            Instance instance = this.getInstance(uri);
            for (String property : instance.getAllProperties()) {
                if (!propertyOccurrences.containsKey(property)) {
                    propertyOccurrences.put(property, 1);
                    continue;
                }
                propertyOccurrences.put(property, (Integer)propertyOccurrences.get(property) + 1);
            }
        }
        LinkedList allProperties = new LinkedList(propertyOccurrences.keySet());
        Collections.sort(allProperties, (p1, p2) -> {
            int c = -new Integer((Integer)propertyOccurrences.get(p1)).compareTo((Integer)propertyOccurrences.get(p2));
            if (c != 0) {
                return c;
            }
            return p1.compareTo((String)p2);
        });
        if (threshold == null && limit == null) {
            return propertyOccurrences.keySet().toArray(new String[0]);
        }
        int absoluteThreshold = (int)(threshold * (double)this.getAllInstances().size());
        LinkedList<String> properties = new LinkedList<String>();
        for (String property : allProperties) {
            if (properties.size() >= limit) break;
            if ((Integer)propertyOccurrences.get(property) < absoluteThreshold) continue;
            properties.add(property);
        }
        return properties.toArray(new String[0]);
    }
}

