/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.model.ml;

import java.util.List;
import javafx.concurrent.Task;
import org.aksw.limes.core.exceptions.UnsupportedMLImplementationException;
import org.aksw.limes.core.gui.model.Config;
import org.aksw.limes.core.gui.model.ml.ActiveLearningModel;
import org.aksw.limes.core.gui.model.ml.BatchLearningModel;
import org.aksw.limes.core.gui.model.ml.UnsupervisedLearningModel;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.ml.algorithm.AMLAlgorithm;
import org.aksw.limes.core.ml.algorithm.LearningParameter;
import org.aksw.limes.core.ml.algorithm.MLAlgorithmFactory;
import org.aksw.limes.core.ml.algorithm.MLImplementationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MachineLearningModel {
    protected static Logger logger = LoggerFactory.getLogger((String)"LIMES");
    protected AMLAlgorithm mlalgorithm;
    protected List<LearningParameter> learningParameters;
    protected ACache sourceCache;
    protected ACache targetCache;
    protected Thread learningThread;
    protected Config config;
    protected AMapping learnedMapping;
    protected LinkSpecification learnedLS;

    public MachineLearningModel(Config config, ACache sourceCache, ACache targetCache) {
        this.setConfig(config);
        this.sourceCache = sourceCache;
        this.targetCache = targetCache;
    }

    public abstract Task<Void> createLearningTask();

    public AMLAlgorithm getMlalgorithm() {
        return this.mlalgorithm;
    }

    public void setMlalgorithm(AMLAlgorithm mlalgorithm) {
        this.mlalgorithm = mlalgorithm;
    }

    public void setLearningParameters(List<LearningParameter> learningParameters) {
        this.learningParameters = learningParameters;
    }

    public void initializeData(String algorithmName) {
        algorithmName = algorithmName.toLowerCase();
        String implementationTypeName = null;
        if (this instanceof ActiveLearningModel) {
            implementationTypeName = "supervised active";
        } else if (this instanceof BatchLearningModel) {
            implementationTypeName = "supervised batch";
        } else if (this instanceof UnsupervisedLearningModel) {
            implementationTypeName = "unsupervised";
        } else {
            logger.error("Unknown subclass of MachineLearningModel");
        }
        try {
            this.mlalgorithm = MLAlgorithmFactory.createMLAlgorithm((Class)MLAlgorithmFactory.getAlgorithmType((String)algorithmName), (MLImplementationType)MLAlgorithmFactory.getImplementationType((String)implementationTypeName));
        }
        catch (UnsupportedMLImplementationException e) {
            logger.error("Unsupported Machine Learning Implementation!");
            e.printStackTrace();
        }
    }

    public Thread getLearningThread() {
        return this.learningThread;
    }

    public void setLearningThread(Thread learningThread) {
        this.learningThread = learningThread;
    }

    public AMapping getLearnedMapping() {
        return this.learnedMapping;
    }

    public void setLearnedMapping(AMapping learnedMapping) {
        this.learnedMapping = learnedMapping;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public LinkSpecification getLearnedLS() {
        return this.learnedLS;
    }

    public void setLearnedLS(LinkSpecification learnedLS) {
        this.learnedLS = learnedLS;
    }
}

