/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.model.metric;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.aksw.limes.core.gui.model.metric.Measure;
import org.aksw.limes.core.gui.model.metric.MetricFormatException;
import org.aksw.limes.core.gui.model.metric.Operator;

public abstract class Node {
    protected static int colors = 0;
    public final String id;
    public Double param1 = null;
    public Double param2 = null;
    protected int color;
    protected Node parent = null;
    protected List<Node> childs = new Vector<Node>();

    public Node(String id) {
        this.id = id;
        this.color = colors++;
    }

    public static Node createNode(String id) {
        id = id.toLowerCase().trim();
        if (new Measure("").identifiers().contains(id)) {
            return new Measure(id);
        }
        if (Operator.identifiers.contains(id)) {
            return new Operator(id);
        }
        throw new MetricFormatException("There is no node with id \"" + id + "\", creation is not possible.");
    }

    public abstract Set<String> identifiers();

    public byte getMaxChilds() {
        return 0;
    }

    public abstract Set<Class<? extends Node>> validChildClasses();

    public final boolean isValidParentOf(Node node) {
        return this.validChildClasses().contains(node.getClass());
    }

    public List<Node> getChilds() {
        return Collections.unmodifiableList(this.childs);
    }

    public boolean addChild(Node child) {
        if (!this.acceptsChild(child)) {
            return false;
        }
        this.childs.add(child);
        child.parent = this;
        child.pushDownColor(this.color);
        return true;
    }

    public void removeChild(Node child) {
        this.childs.remove(child);
        child.parent = null;
        child.pushDownColor(colors++);
    }

    public boolean acceptsChild(Node n) {
        return this.isValidParentOf(n) && n.parent == null && this.childs.size() < this.getMaxChilds() && this.color != n.color;
    }

    public Acceptance acceptsChildWithReason(Node n) {
        if (!this.isValidParentOf(n)) {
            return Acceptance.INVALID_PARENT;
        }
        if (n.parent != null) {
            return Acceptance.ALREADY_HAS_A_PARENT;
        }
        if (this.childs.size() >= this.getMaxChilds()) {
            return Acceptance.CANNOT_ACCEPT_ANYMORE_CHILDREN;
        }
        return Acceptance.OK;
    }

    public boolean isComplete() {
        if (this.childs.size() < this.getMaxChilds()) {
            return false;
        }
        for (Node child : this.childs) {
            if (child.isComplete()) continue;
            return false;
        }
        return true;
    }

    protected void pushDownColor(int color) {
        this.color = color;
        for (Node child : this.childs) {
            child.pushDownColor(color);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder(this.id);
        Node node = this;
        synchronized (node) {
            if (this.getChilds().isEmpty()) {
                return sb.toString();
            }
            int i = 0;
            for (Node child : this.getChilds()) {
                Double p;
                if (i == 0) {
                    sb.append('(');
                } else {
                    sb.append(',');
                }
                if (this.hasFrontParameters() && (p = i == 0 ? this.param1 : this.param2) != null) {
                    sb.append(p);
                    sb.append('*');
                }
                sb.append(child.toString());
                if (!this.hasFrontParameters() && (p = i == 0 ? this.param1 : this.param2) != null) {
                    sb.append('|');
                    sb.append(p);
                }
                ++i;
            }
        }
        sb.append(')');
        return sb.toString();
    }

    public boolean hasFrontParameters() {
        return "add".equalsIgnoreCase(this.id);
    }

    public boolean equals(Object o) {
        return this.equals(o, false);
    }

    public boolean equals(Object o, boolean strict) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node n2 = (Node)o;
        boolean stringTest = false;
        boolean parentTest = true;
        stringTest = this.toString().equals(o.toString());
        if (!(this.parent == null && n2.parent != null || n2.parent == null && this.parent != null || this.parent == null || n2.parent == null || this.parent == n2.parent)) {
            parentTest = false;
        }
        if (this.getMaxChilds() == n2.getMaxChilds() && this.getMaxChilds() > 0) {
            List<Node> childrens1 = this.getChilds();
            List<Node> childrens2 = n2.getChilds();
            for (int i = 0; i < childrens1.size(); ++i) {
                for (int j = 0; j < childrens2.size(); ++j) {
                    if (childrens1.get(i).equals(childrens2.get(j))) continue;
                }
            }
        }
        if (strict) {
            return stringTest && parentTest;
        }
        return stringTest;
    }

    public void removeParent() {
        this.parent = null;
    }

    public void overwriteParent(Node parent) {
        this.parent = parent;
    }

    public static enum Acceptance {
        OK,
        INVALID_PARENT,
        ALREADY_HAS_A_PARENT,
        CANNOT_ACCEPT_ANYMORE_CHILDREN,
        SOURCE_PROPERTY_EXPECTED,
        TARGET_PROPERTY_EXPECTED;

    }
}

