/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.concurrent.Task;
import org.aksw.limes.core.gui.util.TaskResultSerializer;
import org.aksw.limes.core.gui.util.sparql.PrefixHelper;
import org.aksw.limes.core.gui.util.sparql.SPARQLHelper;
import org.aksw.limes.core.io.config.KBInfo;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.jena.rdf.model.Model;

public class GetPropertiesTask
extends Task<List<String>> {
    private final KBInfo info;
    private final Model model;
    private final String class_;

    public GetPropertiesTask(KBInfo info, Model model, String class_) {
        this.info = info;
        this.model = model;
        this.class_ = class_;
    }

    protected List<String> call() throws Exception {
        ArrayList<String> result = (ArrayList<String>)TaskResultSerializer.getTaskResult(this);
        if (result != null) {
            Collections.sort(result);
            return result;
        }
        result = new ArrayList<String>();
        for (String property : SPARQLHelper.propertiesUncached(this.info.getEndpoint(), this.info.getGraph(), this.class_, this.model)) {
            result.add(PrefixHelper.abbreviate(property));
        }
        TaskResultSerializer.serializeTaskResult(this, result);
        Collections.sort(result);
        return result;
    }

    public int hashCode() {
        return new HashCodeBuilder(15, 37).append((Object)this.info.getEndpoint()).append((Object)this.info.getGraph()).append((Object)this.model).append((Object)this.class_).toHashCode();
    }
}

