/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javafx.application.Platform;
import javafx.concurrent.Task;
import org.aksw.limes.core.gui.model.ClassMatchingNode;
import org.aksw.limes.core.gui.model.Config;
import org.aksw.limes.core.gui.util.TaskResultSerializer;
import org.aksw.limes.core.gui.util.sparql.SPARQLHelper;
import org.aksw.limes.core.gui.view.TaskProgressView;
import org.aksw.limes.core.io.config.KBInfo;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.jena.rdf.model.Model;

public class GetClassesTask
extends Task<List<ClassMatchingNode>> {
    private final Config config;
    private final KBInfo info;
    private final Model model;
    private final TaskProgressView view;
    private int counter;
    private int maxSize;
    private double progress;

    public GetClassesTask(KBInfo info, Model model, TaskProgressView view, Config config) {
        this.info = info;
        this.model = model;
        this.view = view;
        this.config = config;
    }

    protected List<ClassMatchingNode> call() throws Exception {
        List<ClassMatchingNode> result = (List<ClassMatchingNode>)TaskResultSerializer.getTaskResult(this);
        if (result != null) {
            Collections.sort(result, new ClassMatchingNodeComparator());
            return result;
        }
        Set<String> rootClasses = SPARQLHelper.rootClassesUncached(this.info.getEndpoint(), this.info.getGraph(), this.model, this.config);
        this.counter = 0;
        this.progress = 0.0;
        result = this.getClassMatchingNodes(rootClasses);
        TaskResultSerializer.serializeTaskResult(this, result);
        Collections.sort(result, new ClassMatchingNodeComparator());
        return result;
    }

    private List<ClassMatchingNode> getClassMatchingNodes(Set<String> classes) {
        this.maxSize += classes.size();
        if (this.isCancelled()) {
            return null;
        }
        ArrayList<ClassMatchingNode> result = new ArrayList<ClassMatchingNode>();
        for (String class_ : classes) {
            try {
                ++this.counter;
                List<ClassMatchingNode> children = this.getClassMatchingNodes(SPARQLHelper.subClassesOfUncached(this.info.getEndpoint(), this.info.getGraph(), class_, this.model));
                result.add(new ClassMatchingNode(new URI(class_), children));
                double tmpProgress = (double)this.counter / (double)this.maxSize;
                Platform.runLater(() -> {
                    this.view.getInformationLabel().set((Object)("Getting: " + class_));
                    if (tmpProgress > this.progress) {
                        this.progress = tmpProgress;
                        this.view.getProgressBar().setProgress(this.progress);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.info.getEndpoint()).append((Object)this.info.getGraph()).append((Object)this.model).toHashCode();
    }

    class ClassMatchingNodeComparator
    implements Comparator<ClassMatchingNode> {
        ClassMatchingNodeComparator() {
        }

        @Override
        public int compare(ClassMatchingNode a, ClassMatchingNode b) {
            return a.getName().compareToIgnoreCase(b.getName());
        }
    }
}

