/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.model;

import java.io.Serializable;
import java.net.URI;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ClassMatchingNode
implements Serializable {
    private static final long serialVersionUID = -2983091498542870621L;
    private final URI uri;
    private String name;
    private final List<ClassMatchingNode> children;
    public static final Comparator<ClassMatchingNode> CLASS_MATCHING_NODE_COMPARATOR = (c1, c2) -> c1.name.compareTo(c2.name);

    public ClassMatchingNode(URI uri, List<ClassMatchingNode> children) {
        this.uri = uri;
        String fragment = uri.getFragment();
        if (fragment != null) {
            this.name = fragment;
        } else {
            String path = uri.getPath();
            this.name = path.substring(path.lastIndexOf(47) + 1);
        }
        this.children = children;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getName() {
        return this.name;
    }

    public List<ClassMatchingNode> getChildren() {
        return this.children;
    }

    public int hashCode() {
        return new HashCodeBuilder(19, 37).append((Object)this.uri).append((Object)this.name).append(this.children).toHashCode();
    }
}

