/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.controller;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.scene.control.Alert;
import org.aksw.limes.core.gui.controller.EditClassMatchingController;
import org.aksw.limes.core.gui.controller.EditEndpointsController;
import org.aksw.limes.core.gui.controller.EditPropertyMatchingController;
import org.aksw.limes.core.gui.controller.TaskProgressController;
import org.aksw.limes.core.gui.controller.WizardController;
import org.aksw.limes.core.gui.controller.ml.ActiveLearningController;
import org.aksw.limes.core.gui.controller.ml.BatchLearningController;
import org.aksw.limes.core.gui.controller.ml.UnsupervisedLearningController;
import org.aksw.limes.core.gui.model.Config;
import org.aksw.limes.core.gui.model.Result;
import org.aksw.limes.core.gui.view.EditClassMatchingView;
import org.aksw.limes.core.gui.view.EditEndpointsView;
import org.aksw.limes.core.gui.view.EditPropertyMatchingView;
import org.aksw.limes.core.gui.view.MainView;
import org.aksw.limes.core.gui.view.ResultView;
import org.aksw.limes.core.gui.view.TaskProgressView;
import org.aksw.limes.core.gui.view.WizardView;
import org.aksw.limes.core.gui.view.ml.MachineLearningView;
import org.aksw.limes.core.ml.algorithm.MLImplementationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainController {
    private static final Logger logger = LoggerFactory.getLogger(MainController.class);
    private final MainView view;
    private Config currentConfig;

    public MainController(MainView view) {
        this.view = view;
        view.showLoadedConfig(false);
    }

    public void newConfig(WizardView createWizardView, EditEndpointsView editEndpointsView, EditClassMatchingView editClassMatchingView, EditPropertyMatchingView editPropertyMatchingView) {
        this.confirmPotentialDataLoss();
        this.setCurrentConfig(null);
        Config newConfig = new Config();
        new WizardController(() -> {
            this.setCurrentConfig(newConfig);
            this.view.getGraphBuild().graphBuildController.deleteGraph();
        }, () -> {}, createWizardView, new EditEndpointsController(newConfig, editEndpointsView), new EditClassMatchingController(newConfig, editClassMatchingView), new EditPropertyMatchingController(newConfig, editPropertyMatchingView));
    }

    public void editConfig(WizardView wizardView, EditClassMatchingView editClassMatchingView, EditPropertyMatchingView editPropertyMatchingView) {
        this.confirmPotentialDataLoss();
        new WizardController(() -> {
            this.setCurrentConfig(this.currentConfig);
            this.view.getGraphBuild().graphBuildController.deleteGraph();
        }, () -> {}, wizardView, new EditClassMatchingController(this.currentConfig, editClassMatchingView), new EditPropertyMatchingController(this.currentConfig, editPropertyMatchingView));
    }

    public void editConfig(WizardView wizardView, EditPropertyMatchingView editPropertyMatchingView) {
        this.confirmPotentialDataLoss();
        new WizardController(() -> {
            this.setCurrentConfig(this.currentConfig);
            this.view.getGraphBuild().graphBuildController.deleteGraph();
        }, () -> {}, wizardView, new EditPropertyMatchingController(this.currentConfig, editPropertyMatchingView));
    }

    public void loadConfig(File file) {
        this.confirmPotentialDataLoss();
        try {
            this.setCurrentConfig(Config.loadFromFile(file));
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            MainView.showErrorWithStacktrace("An error occured", "Exception while loading config: " + e.getMessage(), e);
        }
    }

    public void saveConfig(File file) {
        if (this.currentConfig == null) {
            return;
        }
        this.checkAndUpdateMetric();
        try {
            this.currentConfig.save(file);
        }
        catch (Exception e) {
            MainView.showErrorWithStacktrace("An error occured", "Exception while saving config: " + e.getMessage(), e);
        }
    }

    public void exit() {
        this.confirmPotentialDataLoss();
        Platform.exit();
    }

    private void confirmPotentialDataLoss() {
        if (this.currentConfig == null) {
            return;
        }
    }

    public void map() {
        if (this.currentConfig == null) {
            return;
        }
        if (this.checkAndUpdateMetric()) {
            ObservableList results = FXCollections.observableArrayList();
            Task<Void> mapTask = this.currentConfig.createMappingTask((ObservableList<Result>)results);
            TaskProgressView taskProgressView = new TaskProgressView("Mapping");
            TaskProgressController taskProgressController = new TaskProgressController(taskProgressView, new Task[0]);
            taskProgressController.addTask(mapTask, items -> {
                ResultView resultView = new ResultView(this.currentConfig);
                resultView.showResults((ObservableList<Result>)results, this.currentConfig.getMapping());
            }, error -> MainView.showErrorWithStacktrace("Error during mapping", error.getMessage(), mapTask.getException()));
        }
    }

    private boolean checkAndUpdateMetric() {
        if (this.view.getGraphBuild().edited && !this.view.getGraphBuild().graphBuildController.getOutputNode().nodeData.isComplete()) {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setContentText("Metric is not complete!");
            alert.showAndWait();
            return false;
        }
        this.view.getGraphBuild().graphBuildController.setConfigFromGraph();
        return true;
    }

    public void showBatchLearning() {
        if (this.currentConfig != null) {
            new MachineLearningView(this.view, new BatchLearningController(this.currentConfig, this.currentConfig.getSourceEndpoint().getCache(), this.currentConfig.getTargetEndpoint().getCache(), this), MLImplementationType.SUPERVISED_BATCH);
        } else {
            logger.error("Config is null!");
        }
    }

    public void showUnsupervisedLearning() {
        if (this.currentConfig != null) {
            new MachineLearningView(this.view, new UnsupervisedLearningController(this.currentConfig, this.currentConfig.getSourceEndpoint().getCache(), this.currentConfig.getTargetEndpoint().getCache(), this), MLImplementationType.UNSUPERVISED);
        } else {
            logger.error("Config is null!");
        }
    }

    public void showActiveLearning() {
        if (this.currentConfig != null) {
            new MachineLearningView(this.view, new ActiveLearningController(this.currentConfig, this.currentConfig.getSourceEndpoint().getCache(), this.currentConfig.getTargetEndpoint().getCache(), this), MLImplementationType.SUPERVISED_ACTIVE);
        } else {
            logger.error("Config is null!");
        }
    }

    public Config getCurrentConfig() {
        return this.currentConfig;
    }

    public void setCurrentConfig(Config currentConfig) {
        this.currentConfig = currentConfig;
        this.view.showLoadedConfig(currentConfig != null);
        if (currentConfig != null) {
            this.view.showLoadedConfig(true);
            this.view.toolBox.showLoadedConfig(currentConfig);
            this.view.getGraphBuild().graphBuildController.setConfig(currentConfig);
            if (currentConfig.getMetricExpression() != null && !currentConfig.getMetricExpression().equals("")) {
                this.view.getGraphBuild().graphBuildController.generateGraphFromConfig();
            } else {
                this.view.getGraphBuild().graphBuildController.deleteGraph();
            }
        }
    }
}

