/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.controller;

import java.util.List;
import javafx.concurrent.Task;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.aksw.limes.core.gui.controller.IEditController;
import org.aksw.limes.core.gui.controller.TaskProgressController;
import org.aksw.limes.core.gui.model.Config;
import org.aksw.limes.core.gui.model.GetAutomatedPropertiesTask;
import org.aksw.limes.core.gui.model.GetPropertiesTask;
import org.aksw.limes.core.gui.util.SourceOrTarget;
import org.aksw.limes.core.gui.view.EditPropertyMatchingView;
import org.aksw.limes.core.gui.view.IEditView;
import org.aksw.limes.core.gui.view.MainView;
import org.aksw.limes.core.gui.view.TaskProgressView;
import org.aksw.limes.core.io.mapping.AMapping;

public class EditPropertyMatchingController
implements IEditController {
    private final Config config;
    private final EditPropertyMatchingView view;
    private TaskProgressView taskProgressView;

    public EditPropertyMatchingController(Config config, EditPropertyMatchingView view) {
        this.config = config;
        this.view = view;
        view.setController(this);
    }

    @Override
    public void load() {
        this.checkIfAutomationIsPossible();
        if (this.view.isAutomated().booleanValue()) {
            this.loadAutomatedPropertyMatching();
        } else {
            this.loadManualPropertyMatching();
        }
    }

    @Override
    public void load(boolean automated) {
        if (automated) {
            this.loadAutomatedPropertyMatching();
        } else {
            this.loadManualPropertyMatching();
        }
    }

    private void loadAutomatedPropertyMatching() {
        GetAutomatedPropertiesTask getPropertiesTask = new GetAutomatedPropertiesTask(this.config.getSourceInfo(), this.config.getTargetInfo(), this.config.getSourceEndpoint().getModel(), this.config.getTargetEndpoint().getModel(), this.config.getSourceEndpoint().getCurrentClass().getUri().toString(), this.config.getTargetEndpoint().getCurrentClass().getUri().toString());
        this.taskProgressView = new TaskProgressView("Getting properties");
        TaskProgressController taskProgressController = new TaskProgressController(this.taskProgressView, new Task[0]);
        taskProgressController.addTask(getPropertiesTask, properties -> this.view.showAutomatedProperties((AMapping)properties), error -> MainView.showErrorWithStacktrace("An error occured", "Error while loading source properties", getPropertiesTask.getException()));
    }

    private void loadManualPropertyMatching() {
        GetPropertiesTask getSourcePropertiesTask = this.config.getSourceEndpoint().createGetPropertiesTask();
        GetPropertiesTask getTargetPropertiesTask = this.config.getTargetEndpoint().createGetPropertiesTask();
        this.taskProgressView = new TaskProgressView("Getting properties");
        TaskProgressController taskProgressController = new TaskProgressController(this.taskProgressView, new Task[0]);
        taskProgressController.addTask(getSourcePropertiesTask, properties -> this.view.showAvailableProperties(SourceOrTarget.SOURCE, (List<String>)properties), error -> MainView.showErrorWithStacktrace("An error occured", "Error while loading source properties", getSourcePropertiesTask.getException()));
        taskProgressController.addTask(getTargetPropertiesTask, properties -> this.view.showAvailableProperties(SourceOrTarget.TARGET, (List<String>)properties), error -> MainView.showErrorWithStacktrace("An error occured", "Error while loading target properties", getTargetPropertiesTask.getException()));
    }

    @Override
    public IEditView getView() {
        return this.view;
    }

    public void save(List<String> sourceProperties, List<String> targetProperties) {
        this.config.setPropertiesMatching(sourceProperties, targetProperties);
    }

    @Override
    public boolean validate() {
        boolean valid = true;
        if (this.view.isAutomated().booleanValue()) {
            if (this.view.getAddedAutomatedPropsList().getItems().size() == 0) {
                this.view.getMissingPropertiesLabel().setVisible(true);
                this.view.getMissingPropertiesLabel().setTextFill((Paint)Color.RED);
                valid = false;
            }
        } else if (this.view.getAddedSourcePropsList().getItems().size() == 0 || this.view.getAddedTargetPropsList().getItems().size() == 0) {
            this.view.getMissingPropertiesLabel().setVisible(true);
            this.view.getMissingPropertiesLabel().setTextFill((Paint)Color.RED);
            valid = false;
        }
        return valid;
    }

    @Override
    public TaskProgressView getTaskProgressView() {
        return this.taskProgressView;
    }

    @Override
    public void setTaskProgressView(TaskProgressView tpv) {
        this.taskProgressView = tpv;
    }

    public Config getConfig() {
        return this.config;
    }

    @Override
    public void checkIfAutomationIsPossible() {
        boolean automated = !this.config.getSourceEndpoint().getCurrentClass().getUri().equals(this.config.getTargetEndpoint().getCurrentClass().getUri());
        this.view.setAutomated(automated);
    }
}

