/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.controller;

import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import org.aksw.limes.core.gui.controller.IEditController;
import org.aksw.limes.core.gui.model.Config;
import org.aksw.limes.core.gui.model.Endpoint;
import org.aksw.limes.core.gui.util.SourceOrTarget;
import org.aksw.limes.core.gui.view.EditEndpointsView;
import org.aksw.limes.core.gui.view.IEditView;
import org.aksw.limes.core.gui.view.TaskProgressView;
import org.aksw.limes.core.io.config.KBInfo;

public class EditEndpointsController
implements IEditController {
    private static final String emptyFieldError = "This field must not be empty!";
    private final Config config;
    private final EditEndpointsView view;

    EditEndpointsController(Config config, EditEndpointsView view) {
        this.config = config;
        this.view = view;
        view.setController(this);
    }

    @Override
    public void load() {
        KBInfo sourceEndpoint = this.config.getSourceInfo();
        this.view.setFields(SourceOrTarget.SOURCE, sourceEndpoint.getEndpoint(), sourceEndpoint.getId(), sourceEndpoint.getGraph(), Integer.toString(sourceEndpoint.getPageSize()));
        KBInfo targetEndpoint = this.config.getTargetInfo();
        this.view.setFields(SourceOrTarget.TARGET, targetEndpoint.getEndpoint(), targetEndpoint.getId(), targetEndpoint.getGraph(), Integer.toString(targetEndpoint.getPageSize()));
    }

    @Override
    public void load(boolean automated) {
        this.load();
    }

    public void save(SourceOrTarget sourceOrTarget, String endpointURL, String idNamespace, String graph, String pageSize) {
        Endpoint endpoint = sourceOrTarget == SourceOrTarget.SOURCE ? this.config.getSourceEndpoint() : this.config.getTargetEndpoint();
        KBInfo info = endpoint.getInfo();
        info.setEndpoint(endpointURL);
        if (idNamespace == null) {
            idNamespace = sourceOrTarget == SourceOrTarget.SOURCE ? "source" : "target";
        }
        info.setId(idNamespace);
        info.setGraph(graph);
        info.setPageSize(Integer.parseInt(pageSize));
        endpoint.update();
    }

    @Override
    public IEditView getView() {
        return this.view;
    }

    @Override
    public boolean validate() {
        boolean valid = true;
        if (((ComboBox)this.view.getSourceFields()[0]).getValue() == null || ((String)((ComboBox)this.view.getSourceFields()[0]).getValue()).equals("") || ((String)((ComboBox)this.view.getSourceFields()[0]).getValue()).equals(emptyFieldError)) {
            ((ComboBox)this.view.getSourceFields()[0]).setValue((Object)emptyFieldError);
            ((ComboBox)this.view.getSourceFields()[0]).setStyle("-fx-text-inner-color: red;");
            ((ComboBox)this.view.getSourceFields()[0]).setOnMouseClicked(e -> {
                if (((String)((ComboBox)this.view.getSourceFields()[0]).getValue()).equals(emptyFieldError)) {
                    ((ComboBox)this.view.getSourceFields()[0]).setStyle("");
                    ((ComboBox)this.view.getSourceFields()[0]).setValue((Object)"");
                }
            });
            valid = false;
        }
        if (((ComboBox)this.view.getTargetFields()[0]).getValue() == null || ((String)((ComboBox)this.view.getTargetFields()[0]).getValue()).equals("") || ((String)((ComboBox)this.view.getTargetFields()[0]).getValue()).equals(emptyFieldError)) {
            ((ComboBox)this.view.getTargetFields()[0]).setValue((Object)emptyFieldError);
            ((ComboBox)this.view.getTargetFields()[0]).setStyle("-fx-text-inner-color: red;");
            ((ComboBox)this.view.getTargetFields()[0]).setOnMouseClicked(e -> {
                if (((String)((ComboBox)this.view.getTargetFields()[0]).getValue()).equals(emptyFieldError)) {
                    ((ComboBox)this.view.getTargetFields()[0]).setStyle("");
                    ((ComboBox)this.view.getTargetFields()[0]).setValue((Object)"");
                }
            });
            valid = false;
        }
        if (((TextField)this.view.getSourceFields()[3]).getText() == null || ((TextField)this.view.getSourceFields()[3]).getText().equals("") || ((TextField)this.view.getSourceFields()[3]).getText().equals(emptyFieldError)) {
            ((TextField)this.view.getSourceFields()[3]).setText(emptyFieldError);
            ((TextField)this.view.getSourceFields()[3]).setStyle("-fx-text-inner-color: red;");
            ((TextField)this.view.getSourceFields()[3]).setOnMouseClicked(e -> {
                if (((TextField)this.view.getSourceFields()[3]).getText().equals(emptyFieldError)) {
                    ((TextField)this.view.getSourceFields()[3]).setStyle("");
                    ((TextField)this.view.getSourceFields()[3]).setText("");
                }
            });
            valid = false;
        }
        if (((TextField)this.view.getTargetFields()[3]).getText() == null || ((TextField)this.view.getTargetFields()[3]).getText().equals("") || ((TextField)this.view.getTargetFields()[3]).getText().equals(emptyFieldError)) {
            ((TextField)this.view.getTargetFields()[3]).setText(emptyFieldError);
            ((TextField)this.view.getTargetFields()[3]).setStyle("-fx-text-inner-color: red;");
            ((TextField)this.view.getTargetFields()[3]).setOnMouseClicked(e -> {
                if (((TextField)this.view.getTargetFields()[3]).getText().equals(emptyFieldError)) {
                    ((TextField)this.view.getTargetFields()[3]).setStyle("");
                    ((TextField)this.view.getTargetFields()[3]).setText("");
                }
            });
            valid = false;
        }
        return valid;
    }

    @Override
    public TaskProgressView getTaskProgressView() {
        return null;
    }

    @Override
    public void setTaskProgressView(TaskProgressView tpv) {
    }

    @Override
    public void checkIfAutomationIsPossible() {
    }
}

