/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.controller;

import java.util.List;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.aksw.limes.core.gui.controller.IEditController;
import org.aksw.limes.core.gui.controller.TaskProgressController;
import org.aksw.limes.core.gui.model.AutomatedClassMatchingNode;
import org.aksw.limes.core.gui.model.ClassMatchingNode;
import org.aksw.limes.core.gui.model.Config;
import org.aksw.limes.core.gui.model.Endpoint;
import org.aksw.limes.core.gui.model.GetAutomatedClassMatchingTask;
import org.aksw.limes.core.gui.model.GetClassesTask;
import org.aksw.limes.core.gui.util.SourceOrTarget;
import org.aksw.limes.core.gui.view.EditClassMatchingView;
import org.aksw.limes.core.gui.view.IEditView;
import org.aksw.limes.core.gui.view.MainView;
import org.aksw.limes.core.gui.view.TaskProgressView;

public class EditClassMatchingController
implements IEditController {
    private final Config config;
    private final EditClassMatchingView view;
    private TaskProgressView taskProgressView;

    EditClassMatchingController(Config config, EditClassMatchingView view) {
        this.config = config;
        this.view = view;
        view.setController(this);
    }

    @Override
    public void load() {
        this.checkIfAutomationIsPossible();
        if (this.view.isAutomated().booleanValue()) {
            this.loadAutomated();
        } else {
            this.loadManual();
        }
    }

    @Override
    public void load(boolean automated) {
        if (automated) {
            this.loadAutomated();
        } else {
            this.loadManual();
        }
    }

    private void loadAutomated() {
        this.taskProgressView = new TaskProgressView("Get classes");
        GetAutomatedClassMatchingTask getClassesTask = new GetAutomatedClassMatchingTask(this.config.getSourceInfo(), this.config.getTargetInfo(), this.config.getSourceEndpoint().getModel(), this.config.getTargetEndpoint().getModel());
        TaskProgressController taskProgressController = new TaskProgressController(this.taskProgressView, new Task[0]);
        taskProgressController.addTask(getClassesTask, items -> this.view.showTable((ObservableList<AutomatedClassMatchingNode>)items), error -> MainView.showErrorWithStacktrace("Error while loading source classes", error.getMessage(), getClassesTask.getException()));
    }

    private void loadManual() {
        this.taskProgressView = new TaskProgressView("Get classes");
        Endpoint sourceEndpoint = this.config.getSourceEndpoint();
        GetClassesTask getSourceClassesTask = sourceEndpoint.createGetClassesTask(this.taskProgressView);
        Endpoint targetEndpoint = this.config.getTargetEndpoint();
        GetClassesTask getTargetClassesTask = targetEndpoint.createGetClassesTask(this.taskProgressView);
        TaskProgressController taskProgressController = new TaskProgressController(this.taskProgressView, new Task[0]);
        taskProgressController.addTask(getSourceClassesTask, items -> this.view.showTree(SourceOrTarget.SOURCE, (List<ClassMatchingNode>)items, sourceEndpoint.getCurrentClass()), error -> MainView.showErrorWithStacktrace("Error while loading source classes", error.getMessage(), getSourceClassesTask.getException()));
        taskProgressController.addTask(getTargetClassesTask, items -> this.view.showTree(SourceOrTarget.TARGET, (List<ClassMatchingNode>)items, targetEndpoint.getCurrentClass()), error -> MainView.showErrorWithStacktrace("Error while loading target classes", error.getMessage(), getTargetClassesTask.getException()));
    }

    public void save(ClassMatchingNode sourceClass, ClassMatchingNode targetClass) {
        this.config.getSourceEndpoint().setCurrentClass(sourceClass);
        this.config.getTargetEndpoint().setCurrentClass(targetClass);
    }

    public void save(String sourceClass, String targetClass) {
        this.config.getSourceEndpoint().setCurrentClassAsString(sourceClass);
        this.config.getTargetEndpoint().setCurrentClassAsString(targetClass);
    }

    @Override
    public IEditView getView() {
        return this.view;
    }

    @Override
    public boolean validate() {
        boolean valid = true;
        if (this.view.isAutomated().booleanValue()) {
            if (this.view.getTableView().getSelectionModel().getSelectedItem() == null) {
                this.view.getErrorAutomatedMissingClassMatchingLabel().setVisible(true);
                this.view.getErrorAutomatedMissingClassMatchingLabel().setTextFill((Paint)Color.RED);
                valid = false;
            }
        } else if (this.view.getSourceTreeView().getSelectionModel().getSelectedItem() == null || this.view.getTargetTreeView().getSelectionModel().getSelectedItem() == null) {
            this.view.getErrorManualMissingClassMatchingLabel().setVisible(true);
            this.view.getErrorManualMissingClassMatchingLabel().setTextFill((Paint)Color.RED);
            valid = false;
        }
        return valid;
    }

    @Override
    public TaskProgressView getTaskProgressView() {
        return this.taskProgressView;
    }

    @Override
    public void setTaskProgressView(TaskProgressView tpv) {
        this.taskProgressView = tpv;
    }

    public Config getConfig() {
        return this.config;
    }

    @Override
    public void checkIfAutomationIsPossible() {
        boolean automated = !this.config.getSourceInfo().getEndpoint().equals(this.config.getTargetInfo().getEndpoint());
        this.view.setAutomated(automated);
    }
}

