/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm;

import java.util.List;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.ml.algorithm.ACoreMLAlgorithm;
import org.aksw.limes.core.ml.algorithm.ActiveMLAlgorithm;
import org.aksw.limes.core.ml.algorithm.LearningParameter;
import org.aksw.limes.core.ml.algorithm.MLResults;
import org.aksw.limes.core.ml.algorithm.SupervisedMLAlgorithm;
import org.aksw.limes.core.ml.algorithm.UnsupervisedMLAlgorithm;

public abstract class AMLAlgorithm {
    private ACoreMLAlgorithm coreMLAlgorithm;

    public String getName() {
        return this.getMl().getName();
    }

    public ACoreMLAlgorithm getMl() {
        return this.coreMLAlgorithm;
    }

    public void init(List<LearningParameter> lp, ACache source, ACache target) {
        this.getMl().init(lp, source, target);
    }

    public AMapping predict(ACache source, ACache target, MLResults mlModel) {
        return this.coreMLAlgorithm.predict(source, target, mlModel);
    }

    public SupervisedMLAlgorithm asSupervised() {
        return (SupervisedMLAlgorithm)this;
    }

    public UnsupervisedMLAlgorithm asUnsupervised() {
        return (UnsupervisedMLAlgorithm)this;
    }

    public ActiveMLAlgorithm asActive() {
        return (ActiveMLAlgorithm)this;
    }

    public List<LearningParameter> getParameters() {
        return this.getMl().getParameters();
    }

    public void setMl(ACoreMLAlgorithm ml) {
        this.coreMLAlgorithm = ml;
    }

    public void setParameter(String par, Object val) {
        this.coreMLAlgorithm.setParameter(par, val);
    }
}

