/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.topology.cobalt.diagonal;

import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.measures.mapper.topology.cobalt.matcher.CobaltDiagonalMatcher;
import org.aksw.limes.core.measures.measure.AMeasure;
import org.aksw.limes.core.util.LimesWktReader;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;

public class CobaltDiagonalDisjointMeasure
extends AMeasure {
    @Override
    public double getSimilarity(Object object1, Object object2) {
        Geometry tGeo;
        Geometry sGeo;
        String sWKT = object1.toString();
        String tWKT = object2.toString();
        LimesWktReader reader = new LimesWktReader();
        try {
            sGeo = reader.read(sWKT);
            tGeo = reader.read(tWKT);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0.0;
        }
        return new CobaltDiagonalMatcher().relate(sGeo.getEnvelopeInternal(), tGeo.getEnvelopeInternal(), "disjoint") ? 1.0 : 0.0;
    }

    @Override
    public double getSimilarity(Instance instance1, Instance instance2, String property1, String property2) {
        double value = 0.0;
        double sim = 0.0;
        for (String source : instance1.getProperty(property1)) {
            for (String target : instance2.getProperty(property2)) {
                sim = this.getSimilarity(source, target);
                if (!(sim > value)) continue;
                value = sim;
            }
        }
        return sim;
    }

    @Override
    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 1000000.0;
    }

    @Override
    public String getName() {
        return "top_cobalt_diagonal_disjoint";
    }

    @Override
    public String getType() {
        return "topology";
    }
}

