/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.string;

import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.measures.measure.string.StringMeasure;
import uk.ac.shef.wit.simmetrics.similaritymetrics.CosineSimilarity;

public class CosineMeasure
extends StringMeasure {
    public double getSimilarityChar(Object a, Object b) {
        String p1 = "" + a;
        String p2 = "" + b;
        Object r1 = "";
        for (int i = 0; i < p1.length(); ++i) {
            r1 = (String)r1 + " " + p1.charAt(i);
        }
        r1 = ((String)r1).trim();
        Object r2 = "";
        for (int i = 0; i < p2.length(); ++i) {
            r2 = (String)r2 + " " + p2.charAt(i);
        }
        r2 = ((String)r2).trim();
        return new CosineSimilarity().getSimilarity((String)r1, (String)r2);
    }

    @Override
    public double getSimilarity(Object object1, Object object2) {
        return new CosineSimilarity().getSimilarity("" + object1, "" + object2);
    }

    @Override
    public String getType() {
        return "string";
    }

    @Override
    public double getSimilarity(Instance instance1, Instance instance2, String property1, String property2) {
        double sim = 0.0;
        double max = 0.0;
        for (String p1 : instance1.getProperty(property1)) {
            for (String p2 : instance2.getProperty(property2)) {
                sim = this.getSimilarity(p1, p2);
                if (!(max < sim)) continue;
                max = sim;
            }
        }
        return max;
    }

    @Override
    public String getName() {
        return "Cosine";
    }

    @Override
    public double getSimilarity(int overlap, int lengthA, int lengthB) {
        return (double)overlap / Math.sqrt(lengthA * lengthB);
    }

    @Override
    public boolean computableViaOverlap() {
        return true;
    }

    @Override
    public int getPrefixLength(int tokensNumber, double threshold) {
        int k = 1;
        if (threshold == 0.0) {
            k = 0;
        }
        return tokensNumber - (int)Math.ceil((float)((double)tokensNumber * threshold * threshold)) + k;
    }

    @Override
    public int getMidLength(int tokensNumber, double threshold) {
        int k = 1;
        if (threshold == 0.0) {
            k = 0;
        }
        return tokensNumber - (int)Math.ceil((float)((double)tokensNumber * threshold)) + k;
    }

    @Override
    public double getSizeFilteringThreshold(int tokensNumber, double threshold) {
        return Math.ceil(threshold * threshold * (double)tokensNumber);
    }

    @Override
    public int getAlpha(int xTokensNumber, int yTokensNumber, double threshold) {
        return (int)Math.ceil((float)(threshold * Math.sqrt(xTokensNumber * yTokensNumber)));
    }

    @Override
    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 1000.0;
    }
}

