/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.semantic.edgecounting.dictionary;

import edu.mit.jwi.IRAMDictionary;
import edu.mit.jwi.RAMDictionary;
import edu.mit.jwi.item.IIndexWord;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.POS;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.aksw.limes.core.exceptions.semanticDictionary.ExportedSemanticDictionaryFileNotFound;
import org.aksw.limes.core.exceptions.semanticDictionary.SemanticDictionaryNotFound;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemanticDictionary {
    private IRAMDictionary dictionary = null;
    private String wordNetFolder = System.getProperty("user.dir") + "/src/main/resources/wordnet/dict/";
    private String exFile = this.wordNetFolder + "JWI_Export_.wn";
    private static final Logger logger = LoggerFactory.getLogger(SemanticDictionary.class);

    public void exportDictionaryToFile() {
        File dictionaryFolder = new File(this.wordNetFolder);
        if (!dictionaryFolder.exists()) {
            logger.error("Wordnet dictionary folder doesn't exist. Can't do anything");
            throw new SemanticDictionaryNotFound("Wordnet dictionary could not be found.\n Please read the instructions in the README.md file on how to download the worndet database files.\n");
        }
        File dicFile = new File(this.exFile);
        if (!dicFile.exists()) {
            logger.info("No exported wordnet file is found. Creating one..");
            this.dictionary = new RAMDictionary(dictionaryFolder);
            this.dictionary.setLoadPolicy(8);
            logger.info("Loaded dictionary into memory. Now exporting it to file.");
            try {
                this.dictionary.open();
                this.dictionary.export((OutputStream)new FileOutputStream(dicFile));
            }
            catch (IOException e1) {
                logger.error("Couldn't open wordnet dictionary. Exiting..");
                e1.printStackTrace();
                throw new RuntimeException();
            }
            finally {
                this.removeDictionary();
            }
        }
    }

    public void removeDictionary() {
        if (this.dictionary != null) {
            this.dictionary.close();
            this.dictionary = null;
        }
    }

    public void openDictionaryFromFile() {
        File dicFile = new File(this.exFile);
        if (!dicFile.exists()) {
            throw new ExportedSemanticDictionaryFileNotFound("No exported wordnet file is found. Exiting..\nPlease execute the exportDictionaryToFile() function first.");
        }
        if (this.dictionary == null) {
            this.dictionary = new RAMDictionary(dicFile);
            try {
                this.dictionary.open();
            }
            catch (IOException e2) {
                logger.error("Couldn't open wordnet dictionary. Exiting..");
                e2.printStackTrace();
                throw new RuntimeException();
            }
        }
    }

    public IWord getWord(IWordID wordID) {
        return this.dictionary.getWord(wordID);
    }

    public IIndexWord getIndexWord(String str, POS pos) {
        return this.dictionary.getIndexWord(str, pos);
    }

    public ISynset getSynset(ISynsetID hypernymId) {
        return this.dictionary.getSynset(hypernymId);
    }

    public IRAMDictionary getDictionary() {
        return this.dictionary;
    }
}

