/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.pointsets.mean;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.aksw.limes.core.datastrutures.Point;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.mapper.pointsets.OrchidMapper;
import org.aksw.limes.core.measures.mapper.pointsets.Polygon;
import org.aksw.limes.core.measures.measure.pointsets.APointsetsMeasure;

public class NaiveMeanMeasure
extends APointsetsMeasure {
    public int computations = 0;

    /*
     * WARNING - void declaration
     */
    public static double distance(Polygon X, Polygon Y, double threshold) {
        void var6_10;
        Point meanX = new Point("meanX", new ArrayList<Double>());
        for (Point point : X.points) {
            meanX = Point.add(meanX, point);
        }
        for (int i = 0; i < meanX.coordinates.size(); ++i) {
            meanX.coordinates.set(i, meanX.coordinates.get(i) / (double)X.points.size());
        }
        Point meanY = new Point("meanY", new ArrayList<Double>());
        for (Point y : Y.points) {
            meanX = Point.add(meanY, y);
        }
        boolean bl = false;
        while (var6_10 < meanY.coordinates.size()) {
            meanX.coordinates.set((int)var6_10, meanY.coordinates.get((int)var6_10) / (double)Y.points.size());
            ++var6_10;
        }
        return NaiveMeanMeasure.pointToPointDistance(meanX, meanY);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double computeDistance(Polygon X, Polygon Y, double threshold) {
        void var7_11;
        Point meanX = new Point();
        for (Point point : X.points) {
            meanX = Point.add(meanX, point);
        }
        for (int i = 0; i < meanX.coordinates.size(); ++i) {
            meanX.coordinates.set(i, meanX.coordinates.get(i) / (double)X.points.size());
        }
        Point meanY = new Point();
        for (Point y : Y.points) {
            meanY = Point.add(meanY, y);
        }
        boolean bl = false;
        while (var7_11 < meanY.coordinates.size()) {
            meanY.coordinates.set((int)var7_11, meanY.coordinates.get((int)var7_11) / (double)Y.points.size());
            ++var7_11;
        }
        return NaiveMeanMeasure.pointToPointDistance(meanX, meanY);
    }

    @Override
    public String getName() {
        return "naiveMean";
    }

    @Override
    public AMapping run(Set<Polygon> source, Set<Polygon> target, double threshold) {
        AMapping m = MappingFactory.createDefaultMapping();
        for (Polygon s : source) {
            for (Polygon t : target) {
                double d = this.computeDistance(s, t, threshold);
                if (!(d <= threshold)) continue;
                m.add(s.uri, t.uri, d);
            }
        }
        return m;
    }

    @Override
    public double getSimilarity(Object object1, Object object2) {
        Polygon p1 = OrchidMapper.getPolygon((String)object1);
        Polygon p2 = OrchidMapper.getPolygon((String)object2);
        double d = this.computeDistance(p1, p2, 0.0);
        return 1.0 / (1.0 + d);
    }

    @Override
    public String getType() {
        return "geodistance";
    }

    @Override
    public double getSimilarity(Instance instance1, Instance instance2, String property1, String property2) {
        TreeSet<String> source = instance1.getProperty(property1);
        TreeSet<String> target = instance2.getProperty(property2);
        HashSet<Polygon> sourcePolygons = new HashSet<Polygon>();
        HashSet<Polygon> targetPolygons = new HashSet<Polygon>();
        for (String s : source) {
            sourcePolygons.add(OrchidMapper.getPolygon(s));
        }
        for (String t : target) {
            targetPolygons.add(OrchidMapper.getPolygon(t));
        }
        double min = Double.MAX_VALUE;
        double d = 0.0;
        for (Polygon p1 : sourcePolygons) {
            for (Polygon p2 : targetPolygons) {
                d = this.computeDistance(p1, p2, 0.0);
                if (!(d < min)) continue;
                min = d;
            }
        }
        return 1.0 / (1.0 + d);
    }

    @Override
    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 1000.0;
    }
}

