/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.pointsets;

import org.aksw.limes.core.datastrutures.Point;
import org.aksw.limes.core.measures.mapper.pointsets.OrchidMapper;
import org.aksw.limes.core.measures.mapper.pointsets.OrthodromicDistance;
import org.aksw.limes.core.measures.mapper.pointsets.Polygon;
import org.aksw.limes.core.measures.measure.AMeasure;
import org.aksw.limes.core.measures.measure.pointsets.IPointsetsMeasure;
import org.aksw.limes.core.measures.measure.space.GeoGreatEllipticMeasure;

public abstract class APointsetsMeasure
extends AMeasure
implements IPointsetsMeasure {
    public static boolean USE_GREAT_ELLIPTIC_DISTANCE = false;
    protected static int computations;

    public static double pointToPointDistance(Point x, Point y) {
        ++computations;
        if (USE_GREAT_ELLIPTIC_DISTANCE) {
            return GeoGreatEllipticMeasure.getDistanceInDegrees(x, y);
        }
        return OrthodromicDistance.getDistanceInDegrees(x, y);
    }

    @Override
    public double getSimilarity(Object object1, Object object2) {
        Polygon p1 = OrchidMapper.getPolygon((String)object1);
        Polygon p2 = OrchidMapper.getPolygon((String)object2);
        double d = this.computeDistance(p1, p2, 0.0);
        return 1.0 / (1.0 + d);
    }

    @Override
    public int getComputations() {
        return computations;
    }
}

