/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.topology.im;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.util.FileManager;
import org.apache.log4j.Logger;

public class Reader {
    private static final Logger logger = Logger.getLogger(Reader.class);

    public static Model readModel(String fileNameOrUri) {
        return Reader.readModel(fileNameOrUri, "");
    }

    public static Model readModel(String fileNameOrUri, String subDir) {
        long startTime = System.currentTimeMillis();
        Model model = ModelFactory.createDefaultModel();
        InputStream in = FileManager.get().open(fileNameOrUri);
        if (in == null) {
            throw new IllegalArgumentException(fileNameOrUri + " not found");
        }
        if (fileNameOrUri.contains(".ttl") || fileNameOrUri.contains(".n3")) {
            logger.info((Object)"Opening Turtle file");
            model.read(in, null, "TTL");
        } else if (fileNameOrUri.contains(".rdf")) {
            logger.info((Object)"Opening RDFXML file");
            model.read(in, null);
        } else if (fileNameOrUri.contains(".nt")) {
            logger.info((Object)"Opening N-Triples file");
            model.read(in, null, "N-TRIPLE");
        } else {
            logger.info((Object)("Content negotiation to get RDFXML from " + fileNameOrUri));
            model.read(fileNameOrUri);
        }
        logger.info((Object)("Loading " + fileNameOrUri + " is done in " + (System.currentTimeMillis() - startTime) + "ms."));
        return model;
    }

    public static void main(String[] args) {
        Reader.readModel(args[0]).write((OutputStream)System.out, "TTL");
    }
}

