/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.topology.im;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;

public class GridSizeHeuristics {
    public static final String AVG = "avg";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String MED = "median";
    public static boolean swap = false;
    private double size;
    private double minX;
    private double maxX;
    private double avgX;
    private double medX;
    private double minY;
    private double maxY;
    private double avgY;
    private double medY;

    public static double[] decideForTheta(GridSizeHeuristics s, GridSizeHeuristics t, String measure) {
        double[] stats;
        switch (measure) {
            case "max": {
                stats = new double[]{s.maxX, s.maxY, t.maxX, t.maxY};
                break;
            }
            case "avg": {
                stats = new double[]{s.avgX, s.avgY, t.avgX, t.avgY};
                break;
            }
            case "median": {
                stats = new double[]{s.medX, s.medY, t.medX, t.medY};
                break;
            }
            default: {
                stats = new double[]{s.minX, s.minY, t.minX, t.minY};
            }
        }
        double estAreaS = stats[0] * stats[1] * s.size;
        double estAreaT = stats[2] * stats[3] * t.size;
        swap = estAreaS > estAreaT;
        return new double[]{2.0 / (stats[0] + stats[2]), 2.0 / (stats[1] + stats[3])};
    }

    public GridSizeHeuristics(Collection<Geometry> input) {
        double[] x = new double[input.size()];
        double[] y = new double[input.size()];
        int i = 0;
        for (Geometry geometry : input) {
            Envelope e = geometry.getEnvelopeInternal();
            y[i] = e.getHeight();
            x[i] = e.getWidth();
            ++i;
        }
        this.size = input.size();
        Arrays.sort(x);
        this.minX = x[0];
        this.maxX = x[x.length - 1];
        this.avgX = Arrays.stream(x).average().getAsDouble();
        this.medX = x.length % 2 == 0 ? (x[x.length / 2 - 1] + x[x.length / 2]) / 2.0 : x[x.length / 2];
        Arrays.sort(y);
        this.minY = y[0];
        this.maxY = y[y.length - 1];
        this.avgY = Arrays.stream(y).average().getAsDouble();
        this.medY = y.length % 2 == 0 ? (y[y.length / 2 - 1] + y[y.length / 2]) / 2.0 : y[y.length / 2];
    }

    public double getSize() {
        return this.size;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getAvgX() {
        return this.avgX;
    }

    public double getMedX() {
        return this.medX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getAvgY() {
        return this.avgY;
    }

    public double getMedY() {
        return this.medY;
    }

    public String toString() {
        DecimalFormat df = new DecimalFormat("0.0000");
        return "[MIN(" + df.format(this.minX) + ";" + df.format(this.minY) + ");MAX(" + df.format(this.maxX) + ";" + df.format(this.maxY) + ";AVG(" + df.format(this.avgX) + ";" + df.format(this.avgY) + ");MED(" + df.format(this.medX) + ";" + df.format(this.medY) + ")]";
    }
}

