/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.topology.cobalt.splitting;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aksw.limes.core.measures.mapper.topology.cobalt.matcher.ICobaltMatcher;
import org.aksw.limes.core.measures.mapper.topology.cobalt.splitting.ICobaltSplitter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class CobaltSplitMatcher {
    private Map<String, Envelope[][]> splitA = new ConcurrentHashMap<String, Envelope[][]>();
    private Map<String, Envelope[][]> splitB = new ConcurrentHashMap<String, Envelope[][]>();
    private GeometryFactory factory = new GeometryFactory();
    private int splitTimes;
    private ICobaltSplitter splitter;
    private ICobaltMatcher matcher;

    public CobaltSplitMatcher(int splitTimes, ICobaltSplitter splitter, ICobaltMatcher matcher) {
        this.splitTimes = splitTimes;
        this.splitter = splitter;
        this.matcher = matcher;
    }

    public boolean relate(String uriA, Geometry geoA, String uriB, Geometry geoB, String relation) {
        Envelope[][] splitB;
        Envelope[][] splitA;
        if (this.splitA.containsKey(uriA)) {
            splitA = this.splitA.get(uriA);
        } else {
            splitA = this.splitter.getSplit(geoA, this.splitTimes);
            this.splitA.put(uriA, splitA);
        }
        if (this.splitB.containsKey(uriB)) {
            splitB = this.splitB.get(uriB);
        } else {
            splitB = this.splitter.getSplit(geoB, this.splitTimes);
            this.splitB.put(uriB, splitB);
        }
        switch (relation) {
            case "equals": {
                for (int i = 0; i < splitA.length; ++i) {
                    for (int j = 0; j < splitA[i].length; ++j) {
                        Envelope eA = splitA[i][j];
                        Envelope eB = splitB[i][j];
                        if (this.matcher.relate(eA, eB, "equals") || eA.isNull() && eB.isNull() || eA.getArea() == 0.0 && eB.getArea() == 0.0) continue;
                        return false;
                    }
                }
                return true;
            }
            case "intersects": {
                for (int i1 = 0; i1 < splitA.length; ++i1) {
                    for (int j1 = 0; j1 < splitA[i1].length; ++j1) {
                        for (int i2 = 0; i2 < splitB.length; ++i2) {
                            for (int j2 = 0; j2 < splitB[i2].length; ++j2) {
                                Envelope eA = splitA[i1][j1];
                                Envelope eB = splitB[i2][j2];
                                if (eA.isNull() || eB.isNull() || !this.matcher.relate(eA, eB, "intersects")) continue;
                                return true;
                            }
                        }
                    }
                }
                return false;
            }
            case "touches": {
                boolean atLeastOneTouch = false;
                for (int i1 = 0; i1 < splitA.length; ++i1) {
                    for (int j1 = 0; j1 < splitA[i1].length; ++j1) {
                        for (int i2 = 0; i2 < splitB.length; ++i2) {
                            for (int j2 = 0; j2 < splitB[i2].length; ++j2) {
                                Envelope eA = splitA[i1][j1];
                                Envelope eB = splitB[i2][j2];
                                if (!eA.isNull() && !eB.isNull() && this.matcher.relate(eA, eB, "touches")) {
                                    atLeastOneTouch = true;
                                    continue;
                                }
                                if (eA.isNull() || eB.isNull() || !this.matcher.relate(eA, eB, "intersects")) continue;
                                return false;
                            }
                        }
                    }
                }
                return atLeastOneTouch;
            }
            case "contains": 
            case "covers": {
                return this.relate(uriB, geoB, uriA, geoA, "within");
            }
            case "within": 
            case "coveredby": {
                for (int i1 = 0; i1 < splitA.length; ++i1) {
                    for (int j1 = 0; j1 < splitA[i1].length; ++j1) {
                        Envelope eA = splitA[i1][j1];
                        if (eA.isNull() || eA.getArea() == 0.0) continue;
                        ArrayList<Envelope> intersecting = new ArrayList<Envelope>();
                        for (int i2 = 0; i2 < splitB.length; ++i2) {
                            for (int j2 = 0; j2 < splitB[i2].length; ++j2) {
                                Envelope eB = splitB[i2][j2];
                                if (!this.matcher.relate(eA, eB, "intersects")) continue;
                                intersecting.add(eB);
                            }
                        }
                        if (intersecting.isEmpty()) {
                            return false;
                        }
                        double minX = Double.POSITIVE_INFINITY;
                        double minY = Double.POSITIVE_INFINITY;
                        double maxX = Double.NEGATIVE_INFINITY;
                        double maxY = Double.NEGATIVE_INFINITY;
                        for (Envelope envelope : intersecting) {
                            if (envelope.getMinX() < minX) {
                                minX = envelope.getMinX();
                            }
                            if (envelope.getMinY() < minY) {
                                minY = envelope.getMinY();
                            }
                            if (envelope.getMaxX() > maxX) {
                                maxX = envelope.getMaxX();
                            }
                            if (!(envelope.getMaxY() > maxY)) continue;
                            maxY = envelope.getMaxY();
                        }
                        Envelope boundary = new Envelope(minX, maxX, minY, maxY);
                        if (this.matcher.relate(eA, boundary, "within")) continue;
                        return false;
                    }
                }
                return true;
            }
            case "overlaps": {
                boolean anyAOutsideB = this.checkAnyPartOfAOutsideAllPartsOfB(splitA, splitB);
                if (!anyAOutsideB) {
                    return false;
                }
                boolean anyBOutsideA = this.checkAnyPartOfAOutsideAllPartsOfB(splitB, splitA);
                if (!anyBOutsideA) {
                    return false;
                }
                for (int i1 = 0; i1 < splitA.length; ++i1) {
                    for (int j1 = 0; j1 < splitA[i1].length; ++j1) {
                        for (int i2 = 0; i2 < splitB.length; ++i2) {
                            for (int j2 = 0; j2 < splitB[i2].length; ++j2) {
                                Envelope eA = splitA[i1][j1];
                                Envelope eB = splitB[i2][j2];
                                if ((eA.isNull() || eB.isNull() || !this.matcher.relate(eA, eB, "contains")) && !this.matcher.relate(eA, eB, "within") && !this.matcher.relate(eA, eB, "overlaps")) continue;
                                return true;
                            }
                        }
                    }
                }
                return false;
            }
        }
        return false;
    }

    private boolean checkAnyPartOfAOutsideAllPartsOfB(Envelope[][] splitA, Envelope[][] splitB) {
        for (int i1 = 0; i1 < splitA.length; ++i1) {
            for (int j1 = 0; j1 < splitA[i1].length; ++j1) {
                Envelope eA = splitA[i1][j1];
                if (eA.isNull()) continue;
                ArrayList<Envelope> intersecting = new ArrayList<Envelope>();
                for (int i2 = 0; i2 < splitB.length; ++i2) {
                    for (int j2 = 0; j2 < splitB[i2].length; ++j2) {
                        Envelope eB = splitB[i2][j2];
                        if (!this.matcher.relate(eA, eB, "intersects")) continue;
                        intersecting.add(eB);
                    }
                }
                if (intersecting.isEmpty()) {
                    return true;
                }
                double minX = Double.POSITIVE_INFINITY;
                double minY = Double.POSITIVE_INFINITY;
                double maxX = Double.NEGATIVE_INFINITY;
                double maxY = Double.NEGATIVE_INFINITY;
                for (Envelope envelope : intersecting) {
                    if (envelope.getMinX() < minX) {
                        minX = envelope.getMinX();
                    }
                    if (envelope.getMinY() < minY) {
                        minY = envelope.getMinY();
                    }
                    if (envelope.getMaxX() > maxX) {
                        maxX = envelope.getMaxX();
                    }
                    if (!(envelope.getMaxY() > maxY)) continue;
                    maxY = envelope.getMaxY();
                }
                Envelope boundary = new Envelope(minX, maxX, minY, maxY);
                if (this.matcher.relate(eA, boundary, "within")) continue;
                return true;
            }
        }
        return false;
    }

    public void reset() {
        this.splitA = new ConcurrentHashMap<String, Envelope[][]>();
        this.splitB = new ConcurrentHashMap<String, Envelope[][]>();
    }
}

