/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.topology.cobalt.matcher;

import org.aksw.limes.core.measures.mapper.topology.cobalt.CobaltMeasures;
import org.aksw.limes.core.measures.mapper.topology.cobalt.matcher.ICobaltMatcher;
import org.locationtech.jts.geom.Envelope;

public class CobaltDiagonalMatcher
implements ICobaltMatcher {
    @Override
    public boolean relate(Envelope mbrA, Envelope mbrB, String relation) {
        double X = CobaltMeasures.fD(mbrA, mbrB);
        double Y = CobaltMeasures.fD(mbrB, mbrA);
        double Z = X + Y;
        return this.relate(X, Y, Z, relation);
    }

    public boolean relate(double X, double Y, double Z, String relation) {
        switch (relation) {
            case "equals": {
                return X == 1.0 && Y == 1.0 && Z == 2.0;
            }
            case "disjoint": {
                return 0.0 < X && X < 1.0 && 0.0 < Y && Y < 1.0 && 0.0 < Z && Z < 2.0;
            }
            case "intersects": {
                return this.relate(X, Y, Z, "equals") || this.relate(X, Y, Z, "touches") || this.relate(X, Y, Z, "contains") || this.relate(X, Y, Z, "covers") || this.relate(X, Y, Z, "coveredby") || this.relate(X, Y, Z, "within") || this.relate(X, Y, Z, "overlaps");
            }
            case "touches": {
                return 0.0 < X && X < 1.0 && 0.0 < Y && Y < 1.0 && 1.0 <= Z && Z <= 2.0;
            }
            case "within": 
            case "coveredby": {
                if (0.0 < X && X < 1.0 && Y == 1.0 && 1.0 < Z && Z < 2.0) {
                    return true;
                }
                return this.relate(X, Y, Z, "equals");
            }
            case "contains": 
            case "covers": {
                if (X == 1.0 && 0.0 < Y && Y < 1.0 && 1.0 < Z && Z < 2.0) {
                    return true;
                }
                return this.relate(X, Y, Z, "equals");
            }
            case "overlaps": {
                return 0.0 < X && X < 1.0 && 0.0 < Y && Y < 1.0 && 1.0 < Z && Z < 2.0;
            }
        }
        return false;
    }
}

