/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.string.triefilter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentMap;
import org.aksw.limes.core.measures.measure.string.ITrieFilterableStringMeasure;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Pair;

public class TrieFilter
implements Runnable {
    private final Map<String, Map<String, Double>> result;
    private double threshold;
    private List<String> listA;
    private List<String> listB;
    private List<Pair<List<String>, List<String>>> matchCandidateListPairs;
    private Map<String, Map<String, Double>> tempResult;
    private ITrieFilterableStringMeasure metric;
    private TrieNode trieRoot;
    private boolean swapped;
    private int minLenInA;
    private int maxLenInA;

    public TrieFilter(Pair<List<String>, List<String>> lists, ConcurrentMap<String, Map<String, Double>> result, ITrieFilterableStringMeasure metric, double threshold) {
        this.threshold = threshold;
        this.result = result;
        this.metric = metric;
        this.matchCandidateListPairs = new LinkedList<Pair<List<String>, List<String>>>();
        this.tempResult = new HashMap<String, Map<String, Double>>();
        this.trieRoot = new TrieNode();
        this.listA = (List)lists.getLeft();
        this.listB = (List)lists.getRight();
        this.swapped = false;
        if (this.listA.get(this.listA.size() - 1).length() > this.listB.get(this.listB.size() - 1).length()) {
            List<String> _swap = this.listA;
            this.listA = this.listB;
            this.listB = _swap;
            this.swapped = true;
        }
        this.minLenInA = this.listA.get(0).length();
        this.maxLenInA = this.listA.get(this.listA.size() - 1).length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        for (String s : this.listA) {
            this.trieRoot.addChild(s, s);
        }
        HashMap partitions = new HashMap();
        for (String s : this.listB) {
            char[] key = s.toCharArray();
            Arrays.sort(key);
            String skey = String.valueOf(key);
            if (partitions.get(skey) == null) {
                partitions.put(skey, new LinkedList());
            }
            ((List)partitions.get(skey)).add(s);
        }
        for (String key : partitions.keySet()) {
            this.trieSearch(key, (List)partitions.get(key));
        }
        this.reducePairsToResultMap();
        Map<String, Map<String, Double>> map = this.result;
        synchronized (map) {
            for (String s : this.tempResult.keySet()) {
                if (this.result.containsKey(s)) {
                    this.result.get(s).putAll(this.tempResult.get(s));
                    continue;
                }
                this.result.put(s, this.tempResult.get(s));
            }
        }
    }

    private void reducePairsToResultMap() {
        HashMap<String, Double> similarityTable = new HashMap<String, Double>();
        for (Pair<List<String>, List<String>> filteredPair : this.matchCandidateListPairs) {
            for (String a : this.swapped ? (List)filteredPair.getRight() : (List)filteredPair.getLeft()) {
                similarityTable.clear();
                for (String b : !this.swapped ? (List)filteredPair.getRight() : (List)filteredPair.getLeft()) {
                    double currentSim = this.metric.proximity(a, b);
                    if (!(currentSim >= this.threshold)) continue;
                    similarityTable.put(b, currentSim);
                }
                if (similarityTable.size() <= 0) continue;
                this.tempResult.put(a, (HashMap)similarityTable.clone());
            }
        }
    }

    private void trieSearch(String b, List<String> partition) {
        LinkedList<String> matchCandidateList = new LinkedList<String>();
        int bLen = b.length();
        int matches = 0;
        Stack<Character> referenceStack = new Stack<Character>();
        char[] charArray = b.toCharArray();
        for (int i = charArray.length - 1; i >= 0; --i) {
            char c = charArray[i];
            referenceStack.push(Character.valueOf(c));
        }
        Stack<MutableTriple> searchStack = new Stack<MutableTriple>();
        for (Character key : this.trieRoot.children.keySet()) {
            searchStack.add(new MutableTriple((Object)((Stack)referenceStack.clone()), (Object)this.trieRoot.children.get(key), (Object)matches));
        }
        while (!searchStack.isEmpty()) {
            int currentOrder;
            MutableTriple current = (MutableTriple)searchStack.pop();
            int maxPossibleMatches = Math.min(((Stack)current.getLeft()).size(), this.maxLenInA - ((TrieNode)current.getMiddle()).getLevel() + 1) + (Integer)current.getRight();
            if (maxPossibleMatches < this.metric.characterMatchLowerBound(bLen, this.minLenInA, this.threshold)) continue;
            int n = currentOrder = ((Stack)current.getLeft()).isEmpty() ? -1 : new Character(((TrieNode)current.getMiddle()).key).compareTo((Character)((Stack)current.getLeft()).peek());
            if (currentOrder <= 0) {
                if (currentOrder == 0) {
                    ((Stack)current.getLeft()).pop();
                    current.setRight((Object)((Integer)current.getRight() + 1));
                    if ((Integer)current.getRight() >= this.metric.characterMatchLowerBound(bLen, ((TrieNode)current.getMiddle()).getLevel(), this.threshold) && ((TrieNode)current.getMiddle()).data != null && ((TrieNode)current.getMiddle()).data.size() > 0 && this.metric.characterFrequencyUpperBound(((TrieNode)current.getMiddle()).getLevel(), b.length(), (Integer)current.getRight()) >= this.threshold) {
                        matchCandidateList.addAll(((TrieNode)current.getMiddle()).data);
                    }
                }
                for (Character key : ((TrieNode)current.getMiddle()).children.keySet()) {
                    searchStack.push(new MutableTriple((Object)((Stack)((Stack)current.getLeft()).clone()), (Object)((TrieNode)current.getMiddle()).children.get(key), (Object)((Integer)current.getRight())));
                }
                continue;
            }
            ((Stack)current.getLeft()).pop();
            searchStack.push(current);
        }
        if (matchCandidateList.size() > 0) {
            this.matchCandidateListPairs.add((Pair<List<String>, List<String>>)new MutablePair(new LinkedList(matchCandidateList), partition));
        }
    }

    class TrieNode {
        public List<String> data;
        public char key;
        public TrieNode parent;
        public HashMap<Character, TrieNode> children;

        public TrieNode(char key) {
            this.key = key;
            this.data = null;
            this.children = new HashMap();
        }

        public TrieNode() {
            this.key = (char)32;
            this.data = null;
            this.children = new HashMap();
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public TrieNode addChild(String key, String data) {
            char[] sortedKey = key.toCharArray();
            Arrays.sort(sortedKey);
            TrieNode currentNode = this;
            for (char c : sortedKey) {
                if (!currentNode.children.containsKey(Character.valueOf(c))) {
                    currentNode.children.put(Character.valueOf(c), new TrieNode(c));
                    currentNode.children.get((Object)Character.valueOf((char)c)).parent = currentNode;
                }
                currentNode = currentNode.children.get(Character.valueOf(c));
            }
            if (currentNode.data == null) {
                currentNode.data = new LinkedList<String>();
            }
            currentNode.data.add(data);
            return currentNode;
        }

        public int getLevel() {
            if (this.isRoot()) {
                return 0;
            }
            return this.parent.getLevel() + 1;
        }

        public String toString() {
            return this.data != null ? this.data.toString() : "[data null]";
        }
    }
}

