/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.pointsets;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.limes.core.measures.mapper.pointsets.GeoSquare;
import org.aksw.limes.core.measures.mapper.pointsets.Polygon;

public class GeoIndex {
    public Map<Integer, Map<Integer, GeoSquare>> squares = new HashMap<Integer, Map<Integer, GeoSquare>>();
    public Map<String, Set<List<Integer>>> polygonsToSquares = new HashMap<String, Set<List<Integer>>>();

    public GeoIndex add(GeoIndex geoIndex) {
        for (Integer latIndex : geoIndex.squares.keySet()) {
            for (Integer longIndex : geoIndex.squares.get(latIndex).keySet()) {
                for (Polygon p : this.squares.get((Object)latIndex).get((Object)longIndex).elements) {
                    this.addPolygon(p, latIndex, longIndex);
                }
            }
        }
        return this;
    }

    public void addPolygon(Polygon X, int latIndex, int longIndex) {
        if (!this.squares.containsKey(latIndex)) {
            this.squares.put(latIndex, new HashMap());
        }
        if (!this.squares.get(latIndex).containsKey(longIndex)) {
            this.squares.get(latIndex).put(longIndex, new GeoSquare());
        }
        this.squares.get((Object)Integer.valueOf((int)latIndex)).get((Object)Integer.valueOf((int)longIndex)).elements.add(X);
        if (!this.polygonsToSquares.containsKey(X.uri)) {
            this.polygonsToSquares.put(X.uri, new HashSet());
        }
        this.polygonsToSquares.get(X.uri).add(Arrays.asList(latIndex, longIndex));
    }

    public GeoSquare getSquare(int latIndex, int longIndex) {
        if (this.squares.containsKey(latIndex) && this.squares.get(latIndex).containsKey(longIndex)) {
            return this.squares.get(latIndex).get(longIndex);
        }
        return new GeoSquare();
    }

    public Set<List<Integer>> getIndexes(Polygon X) {
        return this.polygonsToSquares.get(X.uri);
    }

    public String toString() {
        return this.squares.toString();
    }
}

