/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper;

import org.aksw.limes.core.exceptions.InvalidMeasureException;
import org.aksw.limes.core.measures.mapper.AMapper;
import org.aksw.limes.core.measures.mapper.phonetic.Caverphone1Mapper;
import org.aksw.limes.core.measures.mapper.phonetic.Caverphone2Mapper;
import org.aksw.limes.core.measures.mapper.phonetic.DaitchMokotoffMapper;
import org.aksw.limes.core.measures.mapper.phonetic.DoubleMetaPhoneMapper;
import org.aksw.limes.core.measures.mapper.phonetic.KoelnPhoneticMapper;
import org.aksw.limes.core.measures.mapper.phonetic.MatchRatingMapper;
import org.aksw.limes.core.measures.mapper.phonetic.MetaPhoneMapper;
import org.aksw.limes.core.measures.mapper.phonetic.NysiisMapper;
import org.aksw.limes.core.measures.mapper.phonetic.RefinedSoundexMapper;
import org.aksw.limes.core.measures.mapper.phonetic.SoundexMapper;
import org.aksw.limes.core.measures.mapper.pointsets.OrchidMapper;
import org.aksw.limes.core.measures.mapper.pointsets.SymmetricHausdorffMapper;
import org.aksw.limes.core.measures.mapper.resourcesets.SetJaccardMapper;
import org.aksw.limes.core.measures.mapper.semantic.edgecounting.EdgeCountingSemanticMapper;
import org.aksw.limes.core.measures.mapper.space.HR3Mapper;
import org.aksw.limes.core.measures.mapper.string.EDJoinMapper;
import org.aksw.limes.core.measures.mapper.string.ExactMatchMapper;
import org.aksw.limes.core.measures.mapper.string.JaroMapper;
import org.aksw.limes.core.measures.mapper.string.JaroWinklerMapper;
import org.aksw.limes.core.measures.mapper.string.LessThanMapper;
import org.aksw.limes.core.measures.mapper.string.MongeElkanMapper;
import org.aksw.limes.core.measures.mapper.string.PPJoinPlusPlus;
import org.aksw.limes.core.measures.mapper.string.RatcliffObershelpMapper;
import org.aksw.limes.core.measures.mapper.string.fastngram.FastNGramMapper;
import org.aksw.limes.core.measures.mapper.temporal.allenAlgebra.complex.AfterMapper;
import org.aksw.limes.core.measures.mapper.temporal.allenAlgebra.complex.BeforeMapper;
import org.aksw.limes.core.measures.mapper.temporal.allenAlgebra.complex.DuringMapper;
import org.aksw.limes.core.measures.mapper.temporal.allenAlgebra.complex.DuringReverseMapper;
import org.aksw.limes.core.measures.mapper.temporal.allenAlgebra.complex.EqualsMapper;
import org.aksw.limes.core.measures.mapper.temporal.allenAlgebra.complex.FinishesMapper;
import org.aksw.limes.core.measures.mapper.temporal.allenAlgebra.complex.IsFinishedByMapper;
import org.aksw.limes.core.measures.mapper.temporal.allenAlgebra.complex.IsMetByMapper;
import org.aksw.limes.core.measures.mapper.temporal.allenAlgebra.complex.IsOverlappedByMapper;
import org.aksw.limes.core.measures.mapper.temporal.allenAlgebra.complex.IsStartedByMapper;
import org.aksw.limes.core.measures.mapper.temporal.allenAlgebra.complex.MeetsMapper;
import org.aksw.limes.core.measures.mapper.temporal.allenAlgebra.complex.OverlapsMapper;
import org.aksw.limes.core.measures.mapper.temporal.allenAlgebra.complex.StartsMapper;
import org.aksw.limes.core.measures.mapper.temporal.simpleTemporal.ConcurrentMapper;
import org.aksw.limes.core.measures.mapper.temporal.simpleTemporal.PredecessorMapper;
import org.aksw.limes.core.measures.mapper.temporal.simpleTemporal.SuccessorMapper;
import org.aksw.limes.core.measures.mapper.topology.ContainsMapper;
import org.aksw.limes.core.measures.mapper.topology.CoveredbyMapper;
import org.aksw.limes.core.measures.mapper.topology.CoversMapper;
import org.aksw.limes.core.measures.mapper.topology.CrossesMapper;
import org.aksw.limes.core.measures.mapper.topology.DisjointMapper;
import org.aksw.limes.core.measures.mapper.topology.IntersectsMapper;
import org.aksw.limes.core.measures.mapper.topology.TouchesMapper;
import org.aksw.limes.core.measures.mapper.topology.WithinMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.area.CobaltAreaContainsMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.area.CobaltAreaCoveredbyMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.area.CobaltAreaCoversMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.area.CobaltAreaDisjointMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.area.CobaltAreaEqualsMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.area.CobaltAreaIntersectsMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.area.CobaltAreaOverlapsMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.area.CobaltAreaTouchesMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.area.CobaltAreaWithinMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.diagonal.CobaltDiagonalContainsMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.diagonal.CobaltDiagonalCoveredbyMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.diagonal.CobaltDiagonalCoversMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.diagonal.CobaltDiagonalDisjointMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.diagonal.CobaltDiagonalEqualsMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.diagonal.CobaltDiagonalIntersectsMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.diagonal.CobaltDiagonalOverlapsMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.diagonal.CobaltDiagonalTouchesMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.diagonal.CobaltDiagonalWithinMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.mixed.CobaltMixedContainsMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.mixed.CobaltMixedCoveredbyMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.mixed.CobaltMixedCoversMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.mixed.CobaltMixedDisjointMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.mixed.CobaltMixedEqualsMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.mixed.CobaltMixedIntersectsMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.mixed.CobaltMixedOverlapsMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.mixed.CobaltMixedTouchesMapper;
import org.aksw.limes.core.measures.mapper.topology.cobalt.mixed.CobaltMixedWithinMapper;
import org.aksw.limes.core.measures.measure.MeasureType;

public class MapperFactory {
    public static AMapper createMapper(MeasureType type) {
        switch (type) {
            case JAROWINKLER: {
                return new JaroWinklerMapper();
            }
            case JARO: {
                return new JaroMapper();
            }
            case QGRAMS: 
            case TRIGRAM: {
                return new FastNGramMapper();
            }
            case COSINE: 
            case OVERLAP: 
            case JACCARD: {
                return new PPJoinPlusPlus();
            }
            case LEVENSHTEIN: {
                return new EDJoinMapper();
            }
            case EXACTMATCH: {
                return new ExactMatchMapper();
            }
            case LESS_THAN: {
                return new LessThanMapper();
            }
            case SOUNDEX: {
                return new SoundexMapper();
            }
            case REFINEDSOUNDEX: {
                return new RefinedSoundexMapper();
            }
            case DOUBLEMETA: {
                return new DoubleMetaPhoneMapper();
            }
            case META: {
                return new MetaPhoneMapper();
            }
            case CAVERPHONE1: {
                return new Caverphone1Mapper();
            }
            case CAVERPHONE2: {
                return new Caverphone2Mapper();
            }
            case KOELN: {
                return new KoelnPhoneticMapper();
            }
            case DAITCHMOKOTOFF: {
                return new DaitchMokotoffMapper();
            }
            case MATCHRATING: {
                return new MatchRatingMapper();
            }
            case NYSIIS: {
                return new NysiisMapper();
            }
            case MONGEELKAN: {
                return new MongeElkanMapper();
            }
            case RATCLIFF: {
                return new RatcliffObershelpMapper();
            }
            case EUCLIDEAN: {
                return new HR3Mapper();
            }
            case MANHATTAN: {
                return new HR3Mapper();
            }
            case GEO_ORTHODROMIC: 
            case GEO_GREAT_ELLIPTIC: {
                return new HR3Mapper();
            }
            case GEO_CENTROID_INDEXED_HAUSDORFF: 
            case GEO_FAST_HAUSDORFF: 
            case GEO_HAUSDORFF: 
            case GEO_INDEXED_HAUSDORFF: 
            case GEO_NAIVE_HAUSDORFF: 
            case GEO_SCAN_INDEXED_HAUSDORFF: {
                return new OrchidMapper();
            }
            case GEO_SYMMETRIC_HAUSDORFF: {
                return new SymmetricHausdorffMapper();
            }
            case GEO_MAX: 
            case GEO_MEAN: 
            case GEO_MIN: 
            case GEO_AVG: 
            case GEO_FRECHET: 
            case GEO_LINK: 
            case GEO_SUM_OF_MIN: 
            case GEO_NAIVE_SURJECTION: 
            case GEO_FAIR_SURJECTION: {
                return new OrchidMapper();
            }
            case TMP_CONCURRENT: {
                return new ConcurrentMapper();
            }
            case TMP_PREDECESSOR: {
                return new PredecessorMapper();
            }
            case TMP_SUCCESSOR: {
                return new SuccessorMapper();
            }
            case TMP_AFTER: {
                return new AfterMapper();
            }
            case TMP_BEFORE: {
                return new BeforeMapper();
            }
            case TMP_DURING_REVERSE: {
                return new DuringReverseMapper();
            }
            case TMP_DURING: {
                return new DuringMapper();
            }
            case TMP_EQUALS: {
                return new EqualsMapper();
            }
            case TMP_FINISHES: {
                return new FinishesMapper();
            }
            case TMP_IS_FINISHED_BY: {
                return new IsFinishedByMapper();
            }
            case TMP_IS_MET_BY: {
                return new IsMetByMapper();
            }
            case TMP_IS_OVERLAPPED_BY: {
                return new IsOverlappedByMapper();
            }
            case TMP_IS_STARTED_BY: {
                return new IsStartedByMapper();
            }
            case TMP_MEETS: {
                return new MeetsMapper();
            }
            case TMP_OVERLAPS: {
                return new OverlapsMapper();
            }
            case TMP_STARTS: {
                return new StartsMapper();
            }
            case TOP_CONTAINS: {
                return new ContainsMapper();
            }
            case TOP_COVERED_BY: {
                return new CoveredbyMapper();
            }
            case TOP_COVERS: {
                return new CoversMapper();
            }
            case TOP_CROSSES: {
                return new CrossesMapper();
            }
            case TOP_DISJOINT: {
                return new DisjointMapper();
            }
            case TOP_EQUALS: {
                return new org.aksw.limes.core.measures.mapper.topology.EqualsMapper();
            }
            case TOP_INTERSECTS: {
                return new IntersectsMapper();
            }
            case TOP_OVERLAPS: {
                return new org.aksw.limes.core.measures.mapper.topology.OverlapsMapper();
            }
            case TOP_TOUCHES: {
                return new TouchesMapper();
            }
            case TOP_WITHIN: {
                return new WithinMapper();
            }
            case TOP_COBALT_AREA_CONTAINS: {
                return new CobaltAreaContainsMapper();
            }
            case TOP_COBALT_AREA_COVERED_BY: {
                return new CobaltAreaCoveredbyMapper();
            }
            case TOP_COBALT_AREA_COVERS: {
                return new CobaltAreaCoversMapper();
            }
            case TOP_COBALT_AREA_DISJOINT: {
                return new CobaltAreaDisjointMapper();
            }
            case TOP_COBALT_AREA_EQUALS: {
                return new CobaltAreaEqualsMapper();
            }
            case TOP_COBALT_AREA_INTERSECTS: {
                return new CobaltAreaIntersectsMapper();
            }
            case TOP_COBALT_AREA_OVERLAPS: {
                return new CobaltAreaOverlapsMapper();
            }
            case TOP_COBALT_AREA_TOUCHES: {
                return new CobaltAreaTouchesMapper();
            }
            case TOP_COBALT_AREA_WITHIN: {
                return new CobaltAreaWithinMapper();
            }
            case TOP_COBALT_DIAGONAL_CONTAINS: {
                return new CobaltDiagonalContainsMapper();
            }
            case TOP_COBALT_DIAGONAL_COVERED_BY: {
                return new CobaltDiagonalCoveredbyMapper();
            }
            case TOP_COBALT_DIAGONAL_COVERS: {
                return new CobaltDiagonalCoversMapper();
            }
            case TOP_COBALT_DIAGONAL_DISJOINT: {
                return new CobaltDiagonalDisjointMapper();
            }
            case TOP_COBALT_DIAGONAL_EQUALS: {
                return new CobaltDiagonalEqualsMapper();
            }
            case TOP_COBALT_DIAGONAL_INTERSECTS: {
                return new CobaltDiagonalIntersectsMapper();
            }
            case TOP_COBALT_DIAGONAL_OVERLAPS: {
                return new CobaltDiagonalOverlapsMapper();
            }
            case TOP_COBALT_DIAGONAL_TOUCHES: {
                return new CobaltDiagonalTouchesMapper();
            }
            case TOP_COBALT_DIAGONAL_WITHIN: {
                return new CobaltDiagonalWithinMapper();
            }
            case TOP_COBALT_MIXED_CONTAINS: {
                return new CobaltMixedContainsMapper();
            }
            case TOP_COBALT_MIXED_COVERED_BY: {
                return new CobaltMixedCoveredbyMapper();
            }
            case TOP_COBALT_MIXED_COVERS: {
                return new CobaltMixedCoversMapper();
            }
            case TOP_COBALT_MIXED_DISJOINT: {
                return new CobaltMixedDisjointMapper();
            }
            case TOP_COBALT_MIXED_EQUALS: {
                return new CobaltMixedEqualsMapper();
            }
            case TOP_COBALT_MIXED_INTERSECTS: {
                return new CobaltMixedIntersectsMapper();
            }
            case TOP_COBALT_MIXED_OVERLAPS: {
                return new CobaltMixedOverlapsMapper();
            }
            case TOP_COBALT_MIXED_TOUCHES: {
                return new CobaltMixedTouchesMapper();
            }
            case TOP_COBALT_MIXED_WITHIN: {
                return new CobaltMixedWithinMapper();
            }
            case SET_JACCARD: {
                return new SetJaccardMapper();
            }
            case SHORTEST_PATH: {
                return new EdgeCountingSemanticMapper();
            }
            case LCH: {
                return new EdgeCountingSemanticMapper();
            }
            case LI: {
                return new EdgeCountingSemanticMapper();
            }
            case WUPALMER: {
                return new EdgeCountingSemanticMapper();
            }
        }
        throw new InvalidMeasureException(type.toString());
    }
}

